/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class ConfigurationBeanFactoryMetadata
implements ApplicationContextAware {
    public static final String BEAN_NAME = ConfigurationBeanFactoryMetadata.class.getName();
    private ConfigurableApplicationContext applicationContext;

    public <A extends Annotation> Map<String, Object> getBeansWithFactoryAnnotation(Class<A> type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String name : this.applicationContext.getBeanFactory().getBeanDefinitionNames()) {
            if (this.findFactoryAnnotation(name, type) == null) continue;
            result.put(name, this.applicationContext.getBean(name));
        }
        return result;
    }

    public <A extends Annotation> A findFactoryAnnotation(String beanName, Class<A> type) {
        Method method = this.findFactoryMethod(beanName);
        return (A)(method != null ? AnnotationUtils.findAnnotation((Method)method, type) : null);
    }

    public Method findFactoryMethod(String beanName) {
        BeanDefinition beanDefinition;
        ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
        if (beanFactory.containsBeanDefinition(beanName) && (beanDefinition = beanFactory.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
            return ((RootBeanDefinition)beanDefinition).getResolvedFactoryMethod();
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }
}

