/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.netty;

import io.rsocket.RSocketFactory;
import io.rsocket.SocketAcceptor;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.server.CloseableChannel;
import io.rsocket.transport.netty.server.TcpServerTransport;
import io.rsocket.transport.netty.server.WebsocketServerTransport;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.rsocket.netty.NettyRSocketServer;
import org.springframework.boot.rsocket.server.ConfigurableRSocketServerFactory;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.boot.rsocket.server.RSocketServerFactory;
import org.springframework.boot.rsocket.server.ServerRSocketFactoryCustomizer;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServer;
import reactor.netty.tcp.TcpServer;

public class NettyRSocketServerFactory
implements RSocketServerFactory,
ConfigurableRSocketServerFactory {
    private int port = 9898;
    private InetAddress address;
    private RSocketServer.TRANSPORT transport = RSocketServer.TRANSPORT.TCP;
    private ReactorResourceFactory resourceFactory;
    private Duration lifecycleTimeout;
    private List<ServerRSocketFactoryCustomizer> serverCustomizers = new ArrayList<ServerRSocketFactoryCustomizer>();

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    @Override
    public void setTransport(RSocketServer.TRANSPORT transport) {
        this.transport = transport;
    }

    public void setResourceFactory(ReactorResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public void setServerCustomizers(Collection<? extends ServerRSocketFactoryCustomizer> serverCustomizers) {
        Assert.notNull(serverCustomizers, (String)"ServerCustomizers must not be null");
        this.serverCustomizers = new ArrayList<ServerRSocketFactoryCustomizer>(serverCustomizers);
    }

    public void addServerCustomizers(ServerRSocketFactoryCustomizer ... serverCustomizers) {
        Assert.notNull((Object)serverCustomizers, (String)"ServerCustomizer must not be null");
        this.serverCustomizers.addAll(Arrays.asList(serverCustomizers));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    @Override
    public NettyRSocketServer create(SocketAcceptor socketAcceptor) {
        ServerTransport<CloseableChannel> transport = this.createTransport();
        RSocketFactory.ServerRSocketFactory factory = RSocketFactory.receive();
        for (ServerRSocketFactoryCustomizer customizer : this.serverCustomizers) {
            factory = (RSocketFactory.ServerRSocketFactory)customizer.apply(factory);
        }
        Mono starter = factory.acceptor(socketAcceptor).transport(transport).start();
        return new NettyRSocketServer((Mono<CloseableChannel>)starter, this.lifecycleTimeout);
    }

    private ServerTransport<CloseableChannel> createTransport() {
        if (this.transport == RSocketServer.TRANSPORT.WEBSOCKET) {
            if (this.resourceFactory != null) {
                HttpServer httpServer = HttpServer.create().tcpConfiguration(tcpServer -> tcpServer.runOn(this.resourceFactory.getLoopResources()));
                return WebsocketServerTransport.create((HttpServer)httpServer);
            }
            return WebsocketServerTransport.create((InetSocketAddress)this.getListenAddress());
        }
        if (this.resourceFactory != null) {
            TcpServer tcpServer2 = TcpServer.create().runOn(this.resourceFactory.getLoopResources()).addressSupplier(this::getListenAddress);
            return TcpServerTransport.create((TcpServer)tcpServer2);
        }
        return TcpServerTransport.create((InetSocketAddress)this.getListenAddress());
    }

    private InetSocketAddress getListenAddress() {
        if (this.address != null) {
            return new InetSocketAddress(this.address.getHostAddress(), this.port);
        }
        return new InetSocketAddress(this.port);
    }
}

