/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.AotBeanProcessingException;
import org.springframework.beans.factory.aot.AutowiredArgumentsCodeGenerator;
import org.springframework.beans.factory.aot.BeanInstanceSupplier;
import org.springframework.beans.factory.aot.CodeWarnings;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingSupplier;

public class InstanceSupplierCodeGenerator {
    private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
    private static final String ARGS_PARAMETER_NAME = "args";
    private static final javax.lang.model.element.Modifier[] PRIVATE_STATIC = new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC};
    private static final CodeBlock NO_ARGS = CodeBlock.of((String)"", (Object[])new Object[0]);
    private final GenerationContext generationContext;
    private final ClassName className;
    private final GeneratedMethods generatedMethods;
    private final boolean allowDirectSupplierShortcut;

    public InstanceSupplierCodeGenerator(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, boolean allowDirectSupplierShortcut) {
        this.generationContext = generationContext;
        this.className = className;
        this.generatedMethods = generatedMethods;
        this.allowDirectSupplierShortcut = allowDirectSupplierShortcut;
    }

    @Deprecated(since="6.1.7")
    public CodeBlock generateCode(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        return this.generateCode(registeredBean, new RegisteredBean.InstantiationDescriptor(constructorOrFactoryMethod, constructorOrFactoryMethod.getDeclaringClass()));
    }

    public CodeBlock generateCode(RegisteredBean registeredBean, RegisteredBean.InstantiationDescriptor instantiationDescriptor) {
        Method method;
        Executable constructorOrFactoryMethod = instantiationDescriptor.executable();
        this.registerRuntimeHintsIfNecessary(registeredBean, constructorOrFactoryMethod);
        if (constructorOrFactoryMethod instanceof Constructor) {
            Constructor constructor = (Constructor)constructorOrFactoryMethod;
            return this.generateCodeForConstructor(registeredBean, constructor);
        }
        if (constructorOrFactoryMethod instanceof Method && !KotlinDetector.isSuspendingFunction((Method)(method = (Method)constructorOrFactoryMethod))) {
            return this.generateCodeForFactoryMethod(registeredBean, method, instantiationDescriptor.targetClass());
        }
        throw new AotBeanProcessingException(registeredBean, "no suitable constructor or factory method found");
    }

    private void registerRuntimeHintsIfNecessary(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = registeredBean.getBeanFactory();
        if (configurableListableBeanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)configurableListableBeanFactory;
            RuntimeHints runtimeHints = this.generationContext.getRuntimeHints();
            ProxyRuntimeHintsRegistrar registrar = new ProxyRuntimeHintsRegistrar(dlbf.getAutowireCandidateResolver());
            if (constructorOrFactoryMethod instanceof Method) {
                Method method = (Method)constructorOrFactoryMethod;
                registrar.registerRuntimeHints(runtimeHints, method);
            } else if (constructorOrFactoryMethod instanceof Constructor) {
                Constructor constructor = (Constructor)constructorOrFactoryMethod;
                registrar.registerRuntimeHints(runtimeHints, constructor);
            }
        }
    }

    private CodeBlock generateCodeForConstructor(RegisteredBean registeredBean, Constructor<?> constructor) {
        String beanName = registeredBean.getBeanName();
        Class<?> beanClass = registeredBean.getBeanClass();
        Class<?> declaringClass = constructor.getDeclaringClass();
        boolean dependsOnBean = ClassUtils.isInnerClass(declaringClass);
        AccessControl.Visibility accessVisibility = this.getAccessVisibility(registeredBean, constructor);
        if (KotlinDetector.isKotlinReflectPresent() && KotlinDelegate.hasConstructorWithOptionalParameter(beanClass)) {
            return this.generateCodeForInaccessibleConstructor(beanName, beanClass, constructor, dependsOnBean, hints -> hints.registerType(beanClass, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
        }
        if (accessVisibility != AccessControl.Visibility.PRIVATE) {
            return this.generateCodeForAccessibleConstructor(beanName, beanClass, constructor, dependsOnBean, declaringClass);
        }
        return this.generateCodeForInaccessibleConstructor(beanName, beanClass, constructor, dependsOnBean, hints -> hints.registerConstructor(constructor, ExecutableMode.INVOKE));
    }

    private CodeBlock generateCodeForAccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor, boolean dependsOnBean, Class<?> declaringClass) {
        this.generationContext.getRuntimeHints().reflection().registerConstructor(constructor, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && constructor.getParameterCount() == 0) {
            if (!this.allowDirectSupplierShortcut) {
                return CodeBlock.of((String)"$T.using($T::new)", (Object[])new Object[]{InstanceSupplier.class, declaringClass});
            }
            if (!this.isThrowingCheckedException(constructor)) {
                return CodeBlock.of((String)"$T::new", (Object[])new Object[]{declaringClass});
            }
            return CodeBlock.of((String)"$T.of($T::new)", (Object[])new Object[]{ThrowingSupplier.class, declaringClass});
        }
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method -> this.buildGetInstanceMethodForConstructor((MethodSpec.Builder)method, beanName, beanClass, constructor, declaringClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(generatedMethod);
    }

    private CodeBlock generateCodeForInaccessibleConstructor(String beanName, Class<?> beanClass, Constructor<?> constructor, boolean dependsOnBean, Consumer<ReflectionHints> hints) {
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(beanClass, constructor).detectDeprecation(Arrays.stream(constructor.getParameters()).map(Parameter::getType));
        hints.accept(this.generationContext.getRuntimeHints().reflection());
        GeneratedMethod generatedMethod = this.generateGetInstanceSupplierMethod(method -> {
            method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
            method.addModifiers(PRIVATE_STATIC);
            codeWarnings.suppress((MethodSpec.Builder)method);
            method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{beanClass}));
            int parameterOffset = !dependsOnBean ? 0 : 1;
            method.addStatement(this.generateResolverForConstructor(beanClass, constructor, parameterOffset));
        });
        return this.generateReturnStatement(generatedMethod);
    }

    private void buildGetInstanceMethodForConstructor(MethodSpec.Builder method, String beanName, Class<?> beanClass, Constructor<?> constructor, Class<?> declaringClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(beanClass, constructor, declaringClass).detectDeprecation(Arrays.stream(constructor.getParameters()).map(Parameter::getType));
        method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
        method.addModifiers(modifiers);
        codeWarnings.suppress(method);
        method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{beanClass}));
        int parameterOffset = !dependsOnBean ? 0 : 1;
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateResolverForConstructor(beanClass, constructor, parameterOffset));
        boolean hasArguments = constructor.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(declaringClass, constructor).generateCode(constructor.getParameterTypes(), parameterOffset) : NO_ARGS;
        CodeBlock newInstance = this.generateNewInstanceCodeForConstructor(dependsOnBean, declaringClass, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance));
        method.addStatement(code.build());
    }

    private CodeBlock generateResolverForConstructor(Class<?> beanClass, Constructor<?> constructor, int parameterOffset) {
        CodeBlock parameterTypes = this.generateParameterTypesCode(constructor.getParameterTypes(), parameterOffset);
        return CodeBlock.of((String)"return $T.<$T>forConstructor($L)", (Object[])new Object[]{BeanInstanceSupplier.class, beanClass, parameterTypes});
    }

    private CodeBlock generateNewInstanceCodeForConstructor(boolean dependsOnBean, Class<?> declaringClass, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{declaringClass, args});
        }
        return CodeBlock.of((String)"$L.getBeanFactory().getBean($T.class).new $L($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, declaringClass.getEnclosingClass(), declaringClass.getSimpleName(), args});
    }

    private CodeBlock generateCodeForFactoryMethod(RegisteredBean registeredBean, Method factoryMethod, Class<?> targetClass) {
        String beanName = registeredBean.getBeanName();
        Class targetClassToUse = ClassUtils.getUserClass(targetClass);
        boolean dependsOnBean = !Modifier.isStatic(factoryMethod.getModifiers());
        AccessControl.Visibility accessVisibility = this.getAccessVisibility(registeredBean, factoryMethod);
        if (accessVisibility != AccessControl.Visibility.PRIVATE) {
            return this.generateCodeForAccessibleFactoryMethod(beanName, factoryMethod, targetClassToUse, dependsOnBean);
        }
        return this.generateCodeForInaccessibleFactoryMethod(beanName, factoryMethod, targetClassToUse);
    }

    private CodeBlock generateCodeForAccessibleFactoryMethod(String beanName, Method factoryMethod, Class<?> targetClass, boolean dependsOnBean) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INTROSPECT);
        if (!dependsOnBean && factoryMethod.getParameterCount() == 0) {
            Class suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.<$T>forFactoryMethod($T.class, $S)", new Object[]{BeanInstanceSupplier.class, suppliedType, targetClass, factoryMethod.getName()});
            code.add(".withGenerator(($L) -> $T.$L())", new Object[]{REGISTERED_BEAN_PARAMETER_NAME, targetClass, factoryMethod.getName()});
            return code.build();
        }
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method -> this.buildGetInstanceMethodForFactoryMethod((MethodSpec.Builder)method, beanName, factoryMethod, targetClass, dependsOnBean, PRIVATE_STATIC));
        return this.generateReturnStatement(getInstanceMethod);
    }

    private CodeBlock generateCodeForInaccessibleFactoryMethod(String beanName, Method factoryMethod, Class<?> targetClass) {
        this.generationContext.getRuntimeHints().reflection().registerMethod(factoryMethod, ExecutableMode.INVOKE);
        GeneratedMethod getInstanceMethod = this.generateGetInstanceSupplierMethod(method -> {
            Class suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
            method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
            method.addModifiers(PRIVATE_STATIC);
            method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{suppliedType}));
            method.addStatement(this.generateInstanceSupplierForFactoryMethod(factoryMethod, suppliedType, targetClass, factoryMethod.getName()));
        });
        return this.generateReturnStatement(getInstanceMethod);
    }

    private void buildGetInstanceMethodForFactoryMethod(MethodSpec.Builder method, String beanName, Method factoryMethod, Class<?> targetClass, boolean dependsOnBean, javax.lang.model.element.Modifier ... modifiers) {
        String factoryMethodName = factoryMethod.getName();
        Class suppliedType = ClassUtils.resolvePrimitiveIfNecessary(factoryMethod.getReturnType());
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(targetClass, factoryMethod, suppliedType).detectDeprecation(Arrays.stream(factoryMethod.getParameters()).map(Parameter::getType));
        method.addJavadoc("Get the bean instance supplier for '$L'.", new Object[]{beanName});
        method.addModifiers(modifiers);
        codeWarnings.suppress(method);
        method.returns((TypeName)ParameterizedTypeName.get(BeanInstanceSupplier.class, (Type[])new Type[]{suppliedType}));
        CodeBlock.Builder code = CodeBlock.builder();
        code.add(this.generateInstanceSupplierForFactoryMethod(factoryMethod, suppliedType, targetClass, factoryMethodName));
        boolean hasArguments = factoryMethod.getParameterCount() > 0;
        CodeBlock arguments = hasArguments ? new AutowiredArgumentsCodeGenerator(targetClass, factoryMethod).generateCode(factoryMethod.getParameterTypes()) : NO_ARGS;
        CodeBlock newInstance = this.generateNewInstanceCodeForMethod(dependsOnBean, targetClass, factoryMethodName, arguments);
        code.add(this.generateWithGeneratorCode(hasArguments, newInstance));
        method.addStatement(code.build());
    }

    private CodeBlock generateInstanceSupplierForFactoryMethod(Method factoryMethod, Class<?> suppliedType, Class<?> targetClass, String factoryMethodName) {
        if (factoryMethod.getParameterCount() == 0) {
            return CodeBlock.of((String)"return $T.<$T>forFactoryMethod($T.class, $S)", (Object[])new Object[]{BeanInstanceSupplier.class, suppliedType, targetClass, factoryMethodName});
        }
        CodeBlock parameterTypes = this.generateParameterTypesCode(factoryMethod.getParameterTypes(), 0);
        return CodeBlock.of((String)"return $T.<$T>forFactoryMethod($T.class, $S, $L)", (Object[])new Object[]{BeanInstanceSupplier.class, suppliedType, targetClass, factoryMethodName, parameterTypes});
    }

    private CodeBlock generateNewInstanceCodeForMethod(boolean dependsOnBean, Class<?> targetClass, String factoryMethodName, CodeBlock args) {
        if (!dependsOnBean) {
            return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{targetClass, factoryMethodName, args});
        }
        return CodeBlock.of((String)"$L.getBeanFactory().getBean($T.class).$L($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, targetClass, factoryMethodName, args});
    }

    private CodeBlock generateReturnStatement(GeneratedMethod generatedMethod) {
        return generatedMethod.toMethodReference().toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), this.className);
    }

    private CodeBlock generateWithGeneratorCode(boolean hasArguments, CodeBlock newInstance) {
        CodeBlock lambdaArguments = hasArguments ? CodeBlock.of((String)"($L, $L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME, ARGS_PARAMETER_NAME}) : CodeBlock.of((String)"($L)", (Object[])new Object[]{REGISTERED_BEAN_PARAMETER_NAME});
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("\n", new Object[0]);
        code.indent().indent();
        code.add(".withGenerator($L -> $L)", new Object[]{lambdaArguments, newInstance});
        code.unindent().unindent();
        return code.build();
    }

    private AccessControl.Visibility getAccessVisibility(RegisteredBean registeredBean, Member member) {
        AccessControl beanTypeAccessControl = AccessControl.forResolvableType((ResolvableType)registeredBean.getBeanType());
        AccessControl memberAccessControl = AccessControl.forMember((Member)member);
        return AccessControl.lowest((AccessControl[])new AccessControl[]{beanTypeAccessControl, memberAccessControl}).getVisibility();
    }

    private CodeBlock generateParameterTypesCode(Class<?>[] parameterTypes, int offset) {
        CodeBlock.Builder code = CodeBlock.builder();
        for (int i = offset; i < parameterTypes.length; ++i) {
            code.add(i != offset ? ", " : "", new Object[0]);
            code.add("$T.class", new Object[]{parameterTypes[i]});
        }
        return code.build();
    }

    private GeneratedMethod generateGetInstanceSupplierMethod(Consumer<MethodSpec.Builder> method) {
        return this.generatedMethods.add("getInstanceSupplier", method);
    }

    private boolean isThrowingCheckedException(Executable executable) {
        return Arrays.stream(executable.getGenericExceptionTypes()).map(ResolvableType::forType).map(ResolvableType::toClass).anyMatch(Exception.class::isAssignableFrom);
    }

    private static class ProxyRuntimeHintsRegistrar {
        private final AutowireCandidateResolver candidateResolver;

        public ProxyRuntimeHintsRegistrar(AutowireCandidateResolver candidateResolver) {
            this.candidateResolver = candidateResolver;
        }

        public void registerRuntimeHints(RuntimeHints runtimeHints, Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                MethodParameter methodParam = new MethodParameter(method, i);
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
            }
        }

        public void registerRuntimeHints(RuntimeHints runtimeHints, Constructor<?> constructor) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                MethodParameter methodParam = new MethodParameter(constructor, i);
                DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(methodParam, true);
                this.registerProxyIfNecessary(runtimeHints, dependencyDescriptor);
            }
        }

        private void registerProxyIfNecessary(RuntimeHints runtimeHints, DependencyDescriptor dependencyDescriptor) {
            Class<?> proxyType = this.candidateResolver.getLazyResolutionProxyClass(dependencyDescriptor, null);
            if (proxyType != null && Proxy.isProxyClass(proxyType)) {
                runtimeHints.proxies().registerJdkProxy((Class[])proxyType.getInterfaces());
            }
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean hasConstructorWithOptionalParameter(Class<?> beanClass) {
            if (KotlinDetector.isKotlinType(beanClass)) {
                KClass kClass = JvmClassMappingKt.getKotlinClass(beanClass);
                for (KFunction constructor : kClass.getConstructors()) {
                    for (KParameter parameter : constructor.getParameters()) {
                        if (!parameter.isOptional()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

