/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.Map;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationMethod;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.Nullable;

final class BeanMethod
extends ConfigurationMethod {
    BeanMethod(MethodMetadata metadata, ConfigurationClass configurationClass) {
        super(metadata, configurationClass);
    }

    @Override
    public void validate(ProblemReporter problemReporter) {
        if ("void".equals(this.getMetadata().getReturnTypeName())) {
            problemReporter.error((Problem)new VoidDeclaredMethodError());
        }
        if (this.getMetadata().isStatic()) {
            return;
        }
        Map attributes = this.getConfigurationClass().getMetadata().getAnnotationAttributes(Configuration.class.getName());
        if (attributes != null && ((Boolean)attributes.get("proxyBeanMethods")).booleanValue() && !this.getMetadata().isOverridable()) {
            problemReporter.error((Problem)new NonOverridableMethodError());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof BeanMethod)) return false;
        BeanMethod that = (BeanMethod)other;
        if (!this.configurationClass.equals(that.configurationClass)) return false;
        if (!BeanMethod.getLocalMethodIdentifier(this.metadata).equals(BeanMethod.getLocalMethodIdentifier(that.metadata))) return false;
        return true;
    }

    public int hashCode() {
        return this.configurationClass.hashCode() * 31 + BeanMethod.getLocalMethodIdentifier(this.metadata).hashCode();
    }

    @Override
    public String toString() {
        return "BeanMethod: " + this.metadata;
    }

    private static String getLocalMethodIdentifier(MethodMetadata metadata) {
        String metadataString = metadata.toString();
        int index = metadataString.indexOf(metadata.getDeclaringClassName());
        return index >= 0 ? metadataString.substring(index + metadata.getDeclaringClassName().length()) : metadataString;
    }

    private class VoidDeclaredMethodError
    extends Problem {
        VoidDeclaredMethodError() {
            super("@Bean method '%s' must not be declared as void; change the method's return type or its annotation.".formatted(BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }

    private class NonOverridableMethodError
    extends Problem {
        NonOverridableMethodError() {
            super("@Bean method '%s' must not be private or final; change the method's modifiers to continue.".formatted(BeanMethod.this.getMetadata().getMethodName()), BeanMethod.this.getResourceLocation());
        }
    }
}

