/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class ReflectionHelper {
    @Nullable
    static ArgumentsMatchKind compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((expectedArgTypes.size() == suppliedArgTypes.size() ? 1 : 0) != 0, (String)"Expected argument types and supplied argument types should be lists of the same size");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        for (int i = 0; i < expectedArgTypes.size() && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals((Object)suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        return match;
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> paramTypes, List<TypeDescriptor> argTypes) {
        int result = 0;
        for (int i = 0; i < paramTypes.size(); ++i) {
            TypeDescriptor argType;
            TypeDescriptor paramType = paramTypes.get(i);
            TypeDescriptor typeDescriptor = argType = i < argTypes.size() ? argTypes.get(i) : null;
            if (argType == null) {
                if (!paramType.isPrimitive()) continue;
                return Integer.MAX_VALUE;
            }
            Class<Object> paramTypeClazz = paramType.getType();
            if (!ClassUtils.isAssignable((Class)paramTypeClazz, (Class)argType.getType())) {
                return Integer.MAX_VALUE;
            }
            if (paramTypeClazz.isPrimitive()) {
                paramTypeClazz = Object.class;
            }
            Class superClass = argType.getType().getSuperclass();
            while (superClass != null) {
                if (paramTypeClazz.equals(superClass)) {
                    result += 2;
                    superClass = null;
                    continue;
                }
                if (ClassUtils.isAssignable(paramTypeClazz, superClass)) {
                    result += 2;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
            if (!paramTypeClazz.isInterface()) continue;
            ++result;
        }
        return result;
    }

    @Nullable
    static ArgumentsMatchKind compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue((!CollectionUtils.isEmpty(expectedArgTypes) ? 1 : 0) != 0, (String)"Expected arguments must at least include one array (the varargs parameter)");
        Assert.isTrue((boolean)expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), (String)"Final expected argument should be array type (the varargs parameter)");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        for (int i = 0; i < argCountUpToVarargs && match != null; ++i) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
            TypeDescriptor expectedArg = expectedArgTypes.get(i);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals((Object)suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals((Object)suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            TypeDescriptor varargsDesc = expectedArgTypes.get(expectedArgTypes.size() - 1);
            TypeDescriptor componentTypeDesc = varargsDesc.getElementTypeDescriptor();
            Assert.state((componentTypeDesc != null ? 1 : 0) != 0, (String)"Component type must not be null for a varargs array");
            Class varargsComponentType = componentTypeDesc.getType();
            for (int i = expectedArgTypes.size() - 1; i < suppliedArgTypes.size(); ++i) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i);
                if (suppliedArg == null) {
                    if (!varargsComponentType.isPrimitive()) continue;
                    match = null;
                    continue;
                }
                if (varargsComponentType == suppliedArg.getType()) continue;
                if (ClassUtils.isAssignable((Class)varargsComponentType, (Class)suppliedArg.getType())) {
                    if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                    match = ArgumentsMatchKind.CLOSE;
                    continue;
                }
                match = typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf((Class)varargsComponentType)) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
            }
        }
        return match;
    }

    public static boolean convertAllArguments(TypeConverter converter, Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = method.isVarArgs() ? Integer.valueOf(method.getParameterCount() - 1) : null;
        return ReflectionHelper.convertArguments(converter, arguments, method, varargsPosition);
    }

    static boolean convertArguments(TypeConverter converter, Object[] arguments, Executable executable, @Nullable Integer varargsPosition) throws EvaluationException {
        boolean conversionOccurred;
        block8: {
            TypeDescriptor componentTypeDesc;
            block9: {
                TypeDescriptor targetType;
                block7: {
                    conversionOccurred = false;
                    if (varargsPosition != null) break block7;
                    for (int i = 0; i < arguments.length; ++i) {
                        TypeDescriptor targetType2 = new TypeDescriptor(MethodParameter.forExecutable((Executable)executable, (int)i));
                        Object argument = arguments[i];
                        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)argument);
                        arguments[i] = converter.convertValue(argument, sourceType, targetType2);
                        conversionOccurred |= argument != arguments[i];
                    }
                    break block8;
                }
                for (int i = 0; i < varargsPosition; ++i) {
                    targetType = new TypeDescriptor(MethodParameter.forExecutable((Executable)executable, (int)i));
                    Object argument = arguments[i];
                    TypeDescriptor sourceType = TypeDescriptor.forObject((Object)argument);
                    arguments[i] = converter.convertValue(argument, sourceType, targetType);
                    conversionOccurred |= argument != arguments[i];
                }
                MethodParameter methodParam = MethodParameter.forExecutable((Executable)executable, (int)varargsPosition);
                targetType = new TypeDescriptor(methodParam);
                componentTypeDesc = targetType.getElementTypeDescriptor();
                Assert.state((componentTypeDesc != null ? 1 : 0) != 0, (String)"Component type must not be null for a varargs array");
                if (varargsPosition != arguments.length - 1) break block9;
                Object argument = arguments[varargsPosition];
                TypeDescriptor sourceType = TypeDescriptor.forObject((Object)argument);
                if (argument == null) {
                    if (componentTypeDesc.getObjectType() == Optional.class) {
                        arguments[varargsPosition.intValue()] = Optional.empty();
                        conversionOccurred = true;
                    }
                } else if (!sourceType.isAssignableTo(componentTypeDesc)) {
                    arguments[varargsPosition.intValue()] = converter.convertValue(argument, sourceType, targetType);
                }
                if (argument == arguments[varargsPosition] || ReflectionHelper.isFirstEntryInArray(argument, arguments[varargsPosition])) break block8;
                conversionOccurred = true;
                break block8;
            }
            for (int i = varargsPosition.intValue(); i < arguments.length; ++i) {
                Object argument = arguments[i];
                TypeDescriptor sourceType = TypeDescriptor.forObject((Object)argument);
                arguments[i] = converter.convertValue(argument, sourceType, componentTypeDesc);
                conversionOccurred |= argument != arguments[i];
            }
        }
        return conversionOccurred;
    }

    public static boolean convertAllMethodHandleArguments(TypeConverter converter, Object[] arguments, MethodHandle methodHandle, @Nullable Integer varargsPosition) throws EvaluationException {
        boolean conversionOccurred;
        block8: {
            TypeDescriptor varargsComponentType;
            block9: {
                TypeDescriptor sourceType;
                Object argument;
                MethodType methodHandleType;
                block7: {
                    conversionOccurred = false;
                    methodHandleType = methodHandle.type();
                    if (varargsPosition != null) break block7;
                    for (int i = 0; i < arguments.length; ++i) {
                        TypeDescriptor.OfField argumentClass = methodHandleType.parameterType(i);
                        ResolvableType resolvableType = ResolvableType.forClass((Class)argumentClass);
                        TypeDescriptor targetType = new TypeDescriptor(resolvableType, (Class)argumentClass, null);
                        Object argument2 = arguments[i];
                        TypeDescriptor sourceType2 = TypeDescriptor.forObject((Object)argument2);
                        arguments[i] = converter.convertValue(argument2, sourceType2, targetType);
                        conversionOccurred |= argument2 != arguments[i];
                    }
                    break block8;
                }
                for (int i = 0; i < varargsPosition; ++i) {
                    TypeDescriptor.OfField argumentClass = methodHandleType.parameterType(i);
                    ResolvableType resolvableType = ResolvableType.forClass((Class)argumentClass);
                    TypeDescriptor targetType = new TypeDescriptor(resolvableType, (Class)argumentClass, null);
                    argument = arguments[i];
                    sourceType = TypeDescriptor.forObject((Object)argument);
                    arguments[i] = converter.convertValue(argument, sourceType, targetType);
                    conversionOccurred |= argument != arguments[i];
                }
                Class<?> varargsArrayClass = methodHandleType.lastParameterType();
                Class varargsComponentClass = ClassUtils.resolvePrimitiveIfNecessary((Class)varargsArrayClass.componentType());
                TypeDescriptor varargsArrayType = TypeDescriptor.array((TypeDescriptor)TypeDescriptor.valueOf((Class)varargsComponentClass));
                varargsComponentType = varargsArrayType.getElementTypeDescriptor();
                Assert.state((varargsComponentType != null ? 1 : 0) != 0, (String)"Component type must not be null for a varargs array");
                if (varargsPosition != arguments.length - 1) break block9;
                argument = arguments[varargsPosition];
                sourceType = TypeDescriptor.forObject((Object)argument);
                if (argument == null) {
                    if (varargsComponentType.getObjectType() == Optional.class) {
                        arguments[varargsPosition.intValue()] = Optional.empty();
                        conversionOccurred = true;
                    }
                } else if (!sourceType.isAssignableTo(varargsComponentType) || sourceType.isArray() && !sourceType.isAssignableTo(varargsArrayType)) {
                    TypeDescriptor targetTypeToUse = sourceType.isArray() ? varargsArrayType : varargsComponentType;
                    arguments[varargsPosition.intValue()] = converter.convertValue(argument, sourceType, targetTypeToUse);
                }
                if (argument == arguments[varargsPosition] || ReflectionHelper.isFirstEntryInArray(argument, arguments[varargsPosition])) break block8;
                conversionOccurred = true;
                break block8;
            }
            for (int i = varargsPosition.intValue(); i < arguments.length; ++i) {
                Object argument = arguments[i];
                TypeDescriptor sourceType = TypeDescriptor.forObject((Object)argument);
                arguments[i] = converter.convertValue(argument, sourceType, varargsComponentType);
                conversionOccurred |= argument != arguments[i];
            }
        }
        return conversionOccurred;
    }

    private static boolean isFirstEntryInArray(Object value, @Nullable Object possibleArray) {
        if (possibleArray == null) {
            return false;
        }
        Class<?> type = possibleArray.getClass();
        if (!type.isArray() || Array.getLength(possibleArray) == 0 || !ClassUtils.isAssignableValue((Class)type.componentType(), (Object)value)) {
            return false;
        }
        Object arrayValue = Array.get(possibleArray, 0);
        return ((Class)type.componentType()).isPrimitive() ? arrayValue.equals(value) : arrayValue == value;
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class<?>[] requiredParameterTypes, Object ... args) {
        Object lastArgument;
        Assert.notEmpty((Object[])requiredParameterTypes, (String)"Required parameter types array must not be empty");
        int parameterCount = requiredParameterTypes.length;
        Class<?> lastRequiredParameterType = requiredParameterTypes[parameterCount - 1];
        Assert.isTrue((boolean)lastRequiredParameterType.isArray(), (String)"The last required parameter type must be an array to support varargs invocation");
        int argumentCount = args.length;
        Object object = lastArgument = argumentCount > 0 ? args[argumentCount - 1] : null;
        if (parameterCount != argumentCount || !lastRequiredParameterType.isInstance(lastArgument)) {
            Object[] newArgs = new Object[parameterCount];
            System.arraycopy(args, 0, newArgs, 0, newArgs.length - 1);
            int varargsArraySize = 0;
            if (argumentCount >= parameterCount) {
                varargsArraySize = argumentCount - (parameterCount - 1);
            }
            TypeDescriptor.OfField componentType = lastRequiredParameterType.componentType();
            Object varargsArray = Array.newInstance(componentType, varargsArraySize);
            for (int i = 0; i < varargsArraySize; ++i) {
                Array.set(varargsArray, i, args[parameterCount - 1 + i]);
            }
            newArgs[newArgs.length - 1] = varargsArray;
            return newArgs;
        }
        return args;
    }

    static enum ArgumentsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;


        public boolean isExactMatch() {
            return this == EXACT;
        }

        public boolean isCloseMatch() {
            return this == CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this == REQUIRES_CONVERSION;
        }
    }
}

