/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import java.io.IOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenPersistenceManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_PERSISTENCE_MANAGER_FACTORY_BEAN_NAME = "persistenceManagerFactory";
    private String persistenceManagerFactoryBeanName = "persistenceManagerFactory";

    public void setPersistenceManagerFactoryBeanName(String persistenceManagerFactoryBeanName) {
        this.persistenceManagerFactoryBeanName = persistenceManagerFactoryBeanName;
    }

    protected String getPersistenceManagerFactoryBeanName() {
        return this.persistenceManagerFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        PersistenceManagerFactory pmf = this.lookupPersistenceManagerFactory();
        PersistenceManager pm = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource((Object)pmf)) {
            participate = true;
        } else {
            this.logger.debug((Object)"Opening JDO persistence manager in OpenPersistenceManagerInViewFilter");
            pm = PersistenceManagerFactoryUtils.getPersistenceManager(pmf, true);
            TransactionSynchronizationManager.bindResource((Object)pmf, (Object)((Object)new PersistenceManagerHolder(pm)));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var8_7 = null;
            if (participate) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (participate) throw throwable;
            TransactionSynchronizationManager.unbindResource((Object)pmf);
            this.logger.debug((Object)"Closing JDO persistence manager in OpenPersistenceManagerInViewFilter");
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, pmf);
            throw throwable;
        }
        TransactionSynchronizationManager.unbindResource((Object)pmf);
        this.logger.debug((Object)"Closing JDO persistence manager in OpenPersistenceManagerInViewFilter");
        PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, pmf);
    }

    protected PersistenceManagerFactory lookupPersistenceManagerFactory() {
        this.logger.info((Object)("Using persistence manager factory '" + this.getPersistenceManagerFactoryBeanName() + "' for OpenPersistenceManagerInViewFilter"));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (PersistenceManagerFactory)wac.getBean(this.getPersistenceManagerFactoryBeanName());
    }
}

