/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.HttpMediaTypeException;

public class HttpMediaTypeNotAcceptableException
extends HttpMediaTypeException {
    public HttpMediaTypeNotAcceptableException(String message) {
        super(message);
        this.getBody().setDetail("Could not parse Accept header.");
    }

    public HttpMediaTypeNotAcceptableException(List<MediaType> mediaTypes) {
        super("No acceptable representation", mediaTypes);
        this.getBody().setDetail("Acceptable representations: " + mediaTypes.stream().map(MimeType::toString).collect(Collectors.joining(", ", "'", "'")) + ".");
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.NOT_ACCEPTABLE;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (CollectionUtils.isEmpty(this.getSupportedMediaTypes())) {
            return HttpHeaders.EMPTY;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(this.getSupportedMediaTypes());
        return headers;
    }
}

