/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.observation.reactive;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.observation.reactive.DefaultHttpRequestsObservationConvention;
import org.springframework.web.observation.reactive.HttpRequestsObservationContext;
import org.springframework.web.observation.reactive.HttpRequestsObservationConvention;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class HttpRequestsObservationWebFilter
implements WebFilter {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = HttpRequestsObservationWebFilter.class.getName() + ".context";
    private static final HttpRequestsObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultHttpRequestsObservationConvention();
    private static final Set<String> DISCONNECTED_CLIENT_EXCEPTIONS = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException");
    private final ObservationRegistry observationRegistry;
    private final HttpRequestsObservationConvention observationConvention;

    public HttpRequestsObservationWebFilter(ObservationRegistry observationRegistry) {
        this(observationRegistry, new DefaultHttpRequestsObservationConvention());
    }

    public HttpRequestsObservationWebFilter(ObservationRegistry observationRegistry, HttpRequestsObservationConvention observationConvention) {
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    public static Optional<HttpRequestsObservationContext> findObservationContext(ServerWebExchange exchange2) {
        return Optional.ofNullable((HttpRequestsObservationContext)((Object)exchange2.getAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE)));
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        HttpRequestsObservationContext observationContext = new HttpRequestsObservationContext(exchange2);
        exchange2.getAttributes().put(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE, (Object)observationContext);
        return chain.filter(exchange2).transformDeferred(call -> this.filter(exchange2, observationContext, (Mono<Void>)call));
    }

    private Publisher<Void> filter(ServerWebExchange exchange2, HttpRequestsObservationContext observationContext, Mono<Void> call) {
        Observation observation = Observation.createNotStarted((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, (Observation.Context)observationContext, (ObservationRegistry)this.observationRegistry);
        observation.start();
        return call.doOnEach(signal -> {
            Throwable throwable = signal.getThrowable();
            if (throwable != null) {
                if (DISCONNECTED_CLIENT_EXCEPTIONS.contains(throwable.getClass().getSimpleName())) {
                    observationContext.setConnectionAborted(true);
                }
                observationContext.setError(throwable);
            }
            this.onTerminalSignal(observation, exchange2);
        }).doOnCancel(() -> {
            observationContext.setConnectionAborted(true);
            observation.stop();
        });
    }

    private void onTerminalSignal(Observation observation, ServerWebExchange exchange2) {
        ServerHttpResponse response = exchange2.getResponse();
        if (response.isCommitted()) {
            observation.stop();
        } else {
            response.beforeCommit(() -> {
                observation.stop();
                return Mono.empty();
            });
        }
    }
}

