/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.ws.java2wsdl.Java2WSDLCodegenEngine;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class Java2WSDLTask
extends Task
implements Java2WSDLConstants {
    private String className = null;
    private String outputLocation = null;
    private String classpathURI = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private String serviceName = null;
    private String outputFileName = null;

    private Map fillOptionMap() {
        HashMap optionMap = new HashMap();
        if (this.className == null) {
            throw new BuildException("You must specify a classname");
        }
        this.addToOptionMap(optionMap, "cn", this.className);
        this.addToOptionMap(optionMap, "o", this.outputLocation);
        this.addToOptionMap(optionMap, "cp", this.classpathURI);
        this.addToOptionMap(optionMap, "tn", this.targetNamespace);
        this.addToOptionMap(optionMap, "tp", this.targetNamespacePrefix);
        this.addToOptionMap(optionMap, "stn", this.schemaTargetNamespace);
        this.addToOptionMap(optionMap, "stp", this.schemaTargetNamespacePrefix);
        this.addToOptionMap(optionMap, "sn", this.serviceName);
        this.addToOptionMap(optionMap, "of", this.outputFileName);
        return optionMap;
    }

    private String[] getStringArray(String value) {
        String[] values = new String[]{value};
        return values;
    }

    private void addToOptionMap(Map map, String option, String value) {
        if (value != null) {
            map.put(option, new Java2WSDLCommandLineOption(option, this.getStringArray(value)));
        }
    }

    public void execute() throws BuildException {
        try {
            AntClassLoader cl = new AntClassLoader(null, this.getProject(), null, false);
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            if (this.outputLocation != null) {
                cl.addPathElement(this.outputLocation);
            }
            Map commandLineOptions = this.fillOptionMap();
            new Java2WSDLCodegenEngine(commandLineOptions).generate();
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public void setClassPathURI(String classpathURI) {
        this.classpathURI = classpathURI;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }
}

