/*
 * Decompiled with CFR 0.152.
 */
package cn.apiclub.captcha.gimpy;

import cn.apiclub.captcha.gimpy.GimpyRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class FishEyeGimpyRenderer
implements GimpyRenderer {
    private final Color _hColor;
    private final Color _vColor;

    public FishEyeGimpyRenderer() {
        this(Color.BLACK, Color.BLACK);
    }

    public FishEyeGimpyRenderer(Color hColor, Color vColor) {
        this._hColor = hColor;
        this._vColor = vColor;
    }

    @Override
    public void gimp(BufferedImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        int hstripes = height / 7;
        int vstripes = width / 7;
        int hspace = height / (hstripes + 1);
        int vspace = width / (vstripes + 1);
        Graphics2D graph = (Graphics2D)image.getGraphics();
        int i = hspace;
        while (i < height) {
            graph.setColor(this._hColor);
            graph.drawLine(0, i, width, i);
            i += hspace;
        }
        i = vspace;
        while (i < width) {
            graph.setColor(this._vColor);
            graph.drawLine(i, 0, i, height);
            i += vspace;
        }
        int[] pix = new int[height * width];
        int j = 0;
        int j1 = 0;
        while (j1 < width) {
            int k1 = 0;
            while (k1 < height) {
                pix[j] = image.getRGB(j1, k1);
                ++j;
                ++k1;
            }
            ++j1;
        }
        double distance = this.ranInt(width / 4, width / 3);
        int wMid = image.getWidth() / 2;
        int hMid = image.getHeight() / 2;
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int relX = x - wMid;
                int relY = y - hMid;
                double d1 = Math.sqrt(relX * relX + relY * relY);
                if (d1 < distance) {
                    int j2 = wMid + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(x - wMid));
                    int k2 = hMid + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(y - hMid));
                    image.setRGB(x, y, pix[j2 * height + k2]);
                }
                ++y;
            }
            ++x;
        }
        graph.dispose();
    }

    private final int ranInt(int i, int j) {
        double d = Math.random();
        return (int)((double)i + (double)(j - i + 1) * d);
    }

    private final double fishEyeFormula(double s) {
        if (s < 0.0) {
            return 0.0;
        }
        if (s > 1.0) {
            return s;
        }
        return -0.75 * s * s * s + 1.5 * s * s + 0.25 * s;
    }
}

