/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RemoteSource
implements JsonpSerializable {
    private final Time connectTimeout;
    private final String host;
    private final String username;
    private final String password;
    private final Time socketTimeout;
    public static final JsonpDeserializer<RemoteSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteSource::setupRemoteSourceDeserializer);

    private RemoteSource(Builder builder) {
        this.connectTimeout = ApiTypeHelper.requireNonNull(builder.connectTimeout, this, "connectTimeout");
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
        this.password = ApiTypeHelper.requireNonNull(builder.password, this, "password");
        this.socketTimeout = ApiTypeHelper.requireNonNull(builder.socketTimeout, this, "socketTimeout");
    }

    public static RemoteSource of(Function<Builder, ObjectBuilder<RemoteSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Time connectTimeout() {
        return this.connectTimeout;
    }

    public final String host() {
        return this.host;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final Time socketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("connect_timeout");
        this.connectTimeout.serialize(generator, mapper);
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("username");
        generator.write(this.username);
        generator.writeKey("password");
        generator.write(this.password);
        generator.writeKey("socket_timeout");
        this.socketTimeout.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRemoteSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connectTimeout, Time._DESERIALIZER, "connect_timeout");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::socketTimeout, Time._DESERIALIZER, "socket_timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoteSource> {
        private Time connectTimeout;
        private String host;
        private String username;
        private String password;
        private Time socketTimeout;

        public final Builder connectTimeout(Time value) {
            this.connectTimeout = value;
            return this;
        }

        public final Builder connectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.connectTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        public final Builder password(String value) {
            this.password = value;
            return this;
        }

        public final Builder socketTimeout(Time value) {
            this.socketTimeout = value;
            return this;
        }

        public final Builder socketTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.socketTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoteSource build() {
            this._checkSingleUse();
            return new RemoteSource(this);
        }
    }
}

