/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoMemory;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoOSCPU;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeOperatingSystemInfo
implements JsonpSerializable {
    private final String arch;
    private final int availableProcessors;
    @Nullable
    private final Integer allocatedProcessors;
    private final String name;
    private final String prettyName;
    private final int refreshIntervalInMillis;
    private final String version;
    @Nullable
    private final NodeInfoOSCPU cpu;
    @Nullable
    private final NodeInfoMemory mem;
    @Nullable
    private final NodeInfoMemory swap;
    public static final JsonpDeserializer<NodeOperatingSystemInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeOperatingSystemInfo::setupNodeOperatingSystemInfoDeserializer);

    private NodeOperatingSystemInfo(Builder builder) {
        this.arch = ApiTypeHelper.requireNonNull(builder.arch, this, "arch");
        this.availableProcessors = ApiTypeHelper.requireNonNull(builder.availableProcessors, this, "availableProcessors");
        this.allocatedProcessors = builder.allocatedProcessors;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.prettyName = ApiTypeHelper.requireNonNull(builder.prettyName, this, "prettyName");
        this.refreshIntervalInMillis = ApiTypeHelper.requireNonNull(builder.refreshIntervalInMillis, this, "refreshIntervalInMillis");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.cpu = builder.cpu;
        this.mem = builder.mem;
        this.swap = builder.swap;
    }

    public static NodeOperatingSystemInfo of(Function<Builder, ObjectBuilder<NodeOperatingSystemInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String arch() {
        return this.arch;
    }

    public final int availableProcessors() {
        return this.availableProcessors;
    }

    @Nullable
    public final Integer allocatedProcessors() {
        return this.allocatedProcessors;
    }

    public final String name() {
        return this.name;
    }

    public final String prettyName() {
        return this.prettyName;
    }

    public final int refreshIntervalInMillis() {
        return this.refreshIntervalInMillis;
    }

    public final String version() {
        return this.version;
    }

    @Nullable
    public final NodeInfoOSCPU cpu() {
        return this.cpu;
    }

    @Nullable
    public final NodeInfoMemory mem() {
        return this.mem;
    }

    @Nullable
    public final NodeInfoMemory swap() {
        return this.swap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("arch");
        generator.write(this.arch);
        generator.writeKey("available_processors");
        generator.write(this.availableProcessors);
        if (this.allocatedProcessors != null) {
            generator.writeKey("allocated_processors");
            generator.write(this.allocatedProcessors.intValue());
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("pretty_name");
        generator.write(this.prettyName);
        generator.writeKey("refresh_interval_in_millis");
        generator.write(this.refreshIntervalInMillis);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.cpu != null) {
            generator.writeKey("cpu");
            this.cpu.serialize(generator, mapper);
        }
        if (this.mem != null) {
            generator.writeKey("mem");
            this.mem.serialize(generator, mapper);
        }
        if (this.swap != null) {
            generator.writeKey("swap");
            this.swap.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeOperatingSystemInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::arch, JsonpDeserializer.stringDeserializer(), "arch");
        op.add(Builder::availableProcessors, JsonpDeserializer.integerDeserializer(), "available_processors");
        op.add(Builder::allocatedProcessors, JsonpDeserializer.integerDeserializer(), "allocated_processors");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::prettyName, JsonpDeserializer.stringDeserializer(), "pretty_name");
        op.add(Builder::refreshIntervalInMillis, JsonpDeserializer.integerDeserializer(), "refresh_interval_in_millis");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::cpu, NodeInfoOSCPU._DESERIALIZER, "cpu");
        op.add(Builder::mem, NodeInfoMemory._DESERIALIZER, "mem");
        op.add(Builder::swap, NodeInfoMemory._DESERIALIZER, "swap");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeOperatingSystemInfo> {
        private String arch;
        private Integer availableProcessors;
        @Nullable
        private Integer allocatedProcessors;
        private String name;
        private String prettyName;
        private Integer refreshIntervalInMillis;
        private String version;
        @Nullable
        private NodeInfoOSCPU cpu;
        @Nullable
        private NodeInfoMemory mem;
        @Nullable
        private NodeInfoMemory swap;

        public final Builder arch(String value) {
            this.arch = value;
            return this;
        }

        public final Builder availableProcessors(int value) {
            this.availableProcessors = value;
            return this;
        }

        public final Builder allocatedProcessors(@Nullable Integer value) {
            this.allocatedProcessors = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder prettyName(String value) {
            this.prettyName = value;
            return this;
        }

        public final Builder refreshIntervalInMillis(int value) {
            this.refreshIntervalInMillis = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        public final Builder cpu(@Nullable NodeInfoOSCPU value) {
            this.cpu = value;
            return this;
        }

        public final Builder cpu(Function<NodeInfoOSCPU.Builder, ObjectBuilder<NodeInfoOSCPU>> fn) {
            return this.cpu(fn.apply(new NodeInfoOSCPU.Builder()).build());
        }

        public final Builder mem(@Nullable NodeInfoMemory value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<NodeInfoMemory.Builder, ObjectBuilder<NodeInfoMemory>> fn) {
            return this.mem(fn.apply(new NodeInfoMemory.Builder()).build());
        }

        public final Builder swap(@Nullable NodeInfoMemory value) {
            this.swap = value;
            return this;
        }

        public final Builder swap(Function<NodeInfoMemory.Builder, ObjectBuilder<NodeInfoMemory>> fn) {
            return this.swap(fn.apply(new NodeInfoMemory.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeOperatingSystemInfo build() {
            this._checkSingleUse();
            return new NodeOperatingSystemInfo(this);
        }
    }
}

