/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jsonb;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.spi.JsonbProvider;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumSet;

public class JsonbJsonpMapper
extends JsonpMapperBase {
    private final JsonProvider jsonProvider;
    private final Jsonb jsonb;

    public JsonbJsonpMapper(JsonProvider jsonProvider, Jsonb jsonb) {
        this.jsonProvider = jsonProvider;
        this.jsonb = jsonb;
    }

    public JsonbJsonpMapper(JsonProvider jsonProvider, JsonbProvider jsonbProvider) {
        this(jsonProvider, jsonbProvider.create().build());
    }

    public JsonbJsonpMapper() {
        this(JsonpUtils.provider(), JsonbProvider.provider());
    }

    @Override
    protected <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> clazz) {
        return new Deserializer<T>(clazz);
    }

    @Override
    public <T> void serialize(T value, JsonGenerator generator) {
        if (value instanceof JsonpSerializable) {
            ((JsonpSerializable)value).serialize(generator, this);
            return;
        }
        CharArrayWriter caw = new CharArrayWriter();
        this.jsonb.toJson(value, (Writer)caw);
        CharArrayReader car = new CharArrayReader(caw.toCharArray());
        JsonParser parser = this.jsonProvider.createParser((Reader)car);
        this.transferAll(parser, generator);
    }

    @Override
    public JsonProvider jsonProvider() {
        return this.jsonProvider;
    }

    private void transferAll(JsonParser from, JsonGenerator to) {
        this.transferAll(from, from.next(), to);
    }

    private void transferAll(JsonParser from, JsonParser.Event event, JsonGenerator to) {
        this.transferEvent(from, event, to);
        switch (event) {
            case START_OBJECT: {
                int depth = 1;
                do {
                    event = from.next();
                    this.transferEvent(from, event, to);
                    switch (event) {
                        case START_OBJECT: {
                            ++depth;
                            break;
                        }
                        case END_OBJECT: {
                            --depth;
                        }
                    }
                } while (event != JsonParser.Event.END_OBJECT || depth != 0);
                break;
            }
            case START_ARRAY: {
                int depth = 1;
                do {
                    event = from.next();
                    this.transferEvent(from, event, to);
                    switch (event) {
                        case START_ARRAY: {
                            ++depth;
                            break;
                        }
                        case END_ARRAY: {
                            --depth;
                        }
                    }
                } while (event != JsonParser.Event.END_ARRAY || depth != 0);
                break;
            }
        }
    }

    private void transferEvent(JsonParser from, JsonParser.Event event, JsonGenerator to) {
        switch (event) {
            case START_OBJECT: {
                to.writeStartObject();
                break;
            }
            case START_ARRAY: {
                to.writeStartArray();
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                to.writeEnd();
                break;
            }
            case KEY_NAME: {
                to.writeKey(from.getString());
                break;
            }
            case VALUE_STRING: {
                to.write(from.getString());
                break;
            }
            case VALUE_NUMBER: {
                if (from.isIntegralNumber()) {
                    to.write(from.getLong());
                    break;
                }
                to.write(from.getBigDecimal());
                break;
            }
            case VALUE_NULL: {
                to.writeNull();
                break;
            }
            case VALUE_TRUE: {
                to.write(true);
                break;
            }
            case VALUE_FALSE: {
                to.write(false);
            }
        }
    }

    private class Deserializer<T>
    extends JsonpDeserializerBase<T> {
        private final Class<T> clazz;

        Deserializer(Class<T> clazz) {
            super(EnumSet.allOf(JsonParser.Event.class));
            this.clazz = clazz;
        }

        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            CharArrayWriter caw = new CharArrayWriter();
            JsonGenerator generator = JsonbJsonpMapper.this.jsonProvider.createGenerator((Writer)caw);
            JsonbJsonpMapper.this.transferAll(parser, event, generator);
            generator.close();
            CharArrayReader car = new CharArrayReader(caw.toCharArray());
            return (T)JsonbJsonpMapper.this.jsonb.fromJson((Reader)car, this.clazz);
        }
    }
}

