/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.HealthReportResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class HealthReportRequest
extends RequestBase {
    private final List<String> feature;
    @Nullable
    private final Integer size;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean verbose;
    public static final Endpoint<HealthReportRequest, HealthReportResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HealthReportRequest, HealthReportResponse>("es/health_report", request -> "GET", request -> {
        boolean _feature = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.feature())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_health_report");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_health_report");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.feature.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, HealthReportResponse._DESERIALIZER);

    private HealthReportRequest(Builder builder) {
        this.feature = ApiTypeHelper.unmodifiable(builder.feature);
        this.size = builder.size;
        this.timeout = builder.timeout;
        this.verbose = builder.verbose;
    }

    public static HealthReportRequest of(Function<Builder, ObjectBuilder<HealthReportRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> feature() {
        return this.feature;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HealthReportRequest> {
        @Nullable
        private List<String> feature;
        @Nullable
        private Integer size;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean verbose;

        public final Builder feature(List<String> list) {
            this.feature = Builder._listAddAll(this.feature, list);
            return this;
        }

        public final Builder feature(String value, String ... values) {
            this.feature = Builder._listAdd(this.feature, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HealthReportRequest build() {
            this._checkSingleUse();
            return new HealthReportRequest(this);
        }
    }
}

