/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol.okhttp;

import com.alibaba.dashscope.base.HalfDuplexParamBase;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.ErrorType;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.common.Status;
import com.alibaba.dashscope.exception.ApiException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.HalfDuplexClient;
import com.alibaba.dashscope.protocol.HalfDuplexRequest;
import com.alibaba.dashscope.protocol.HttpMethod;
import com.alibaba.dashscope.protocol.HttpRequest;
import com.alibaba.dashscope.protocol.NetworkResponse;
import com.alibaba.dashscope.protocol.Protocol;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.io.IOException;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpHttpClient
implements HalfDuplexClient {
    private static final Logger log = LoggerFactory.getLogger(OkHttpHttpClient.class);
    private final OkHttpClient client;
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    private Status parseStreamEventData(String data) {
        try {
            JsonObject jsonResponse = JsonUtils.parse(data);
            String code = "";
            String message = "";
            String requestId = "";
            if (jsonResponse.has("request_id")) {
                requestId = jsonResponse.get("request_id").getAsString();
            }
            if (jsonResponse.has("code")) {
                code = jsonResponse.get("code").getAsString();
            }
            if (jsonResponse.has("message")) {
                message = jsonResponse.get("message").getAsString();
            }
            return Status.builder().statusCode(400).code(code).message(message).requestId(requestId).isJson(true).build();
        }
        catch (Throwable e) {
            return Status.builder().statusCode(400).code(ErrorType.RESPONSE_ERROR.getValue()).message(data).isJson(false).build();
        }
    }

    private Status parseFailedJson(int statusCode, String body) {
        try {
            JsonObject jsonResponse = JsonUtils.parse(body);
            String code = "";
            String message = "";
            String requestId = "";
            if (jsonResponse.has("request_id")) {
                requestId = jsonResponse.get("request_id").getAsString();
            }
            if (jsonResponse.has("code")) {
                code = jsonResponse.get("code").getAsString();
            }
            if (jsonResponse.has("message")) {
                message = jsonResponse.get("message").getAsString();
            }
            return Status.builder().statusCode(statusCode).code(code).message(message).requestId(requestId).isJson(true).build();
        }
        catch (Throwable e) {
            return Status.builder().statusCode(statusCode).code(ErrorType.RESPONSE_ERROR.getValue()).message(body).isJson(true).build();
        }
    }

    private Status parseFailed(Response response) {
        if (response == null) {
            return Status.builder().statusCode(-1).code(ErrorType.NETORK_ERROR.getValue()).message("Get response failed!").isJson(false).build();
        }
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.toLowerCase().contains("application/json")) {
            String body;
            try {
                body = response.body().string();
            }
            catch (IOException e) {
                return Status.builder().statusCode(response.code()).code(ErrorType.RESPONSE_ERROR.getValue()).message("Failed read response body: " + e.getMessage()).isJson(true).build();
            }
            return this.parseFailedJson(response.code(), body);
        }
        if (contentType != null && contentType.toLowerCase().contains("text/event-stream")) {
            try {
                String body = response.body().string();
                for (String part : body.split("\n")) {
                    if (!(part = part.trim()).startsWith("data:")) continue;
                    body = part.replace("data:", "");
                    return this.parseFailedJson(response.code(), body);
                }
                return Status.builder().statusCode(response.code()).code(ErrorType.RESPONSE_ERROR.getValue()).message(body).isJson(false).build();
            }
            catch (IOException e) {
                return Status.builder().statusCode(response.code()).code(ErrorType.RESPONSE_ERROR.getValue()).message("Failed read response body: " + e.getMessage()).isJson(true).build();
            }
        }
        return Status.builder().statusCode(response.code()).code(ErrorType.RESPONSE_ERROR.getValue()).message(response.message()).isJson(false).build();
    }

    public OkHttpHttpClient(OkHttpClient client) {
        this.client = client;
    }

    private <T extends HalfDuplexParamBase> Request buildRequest(HttpRequest req) throws NoApiKeyException, ApiException {
        Request request = null;
        if (req.getHttpMethod() == HttpMethod.GET) {
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)req.getUrl()).newBuilder();
            if (req.getParameters() != null) {
                for (Map.Entry<String, Object> entry : req.getParameters().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue().toString();
                    httpBuilder.addQueryParameter(key, value);
                }
            }
            request = new Request.Builder().url(httpBuilder.build()).headers(Headers.of(req.getHeaders())).build();
        } else if (req.getHttpMethod() == HttpMethod.POST) {
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(req.getUrl()).headers(Headers.of(req.getHeaders()));
            if (req.getBody() != null) {
                requestBuilder.post(RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)((String)req.getBody())));
            } else {
                requestBuilder.post(RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)""));
            }
            request = requestBuilder.build();
        } else if (req.getHttpMethod() == HttpMethod.DELETE) {
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(req.getUrl()).headers(Headers.of(req.getHeaders()));
            if (req.getBody() != null) {
                requestBuilder.delete(RequestBody.create((MediaType)MEDIA_TYPE_APPLICATION_JSON, (String)((String)req.getBody())));
            } else {
                requestBuilder.delete();
            }
            request = requestBuilder.build();
        } else {
            Status status = Status.builder().statusCode(400).code("BadRequest").message(String.format("Unsupported method: %s", new Object[]{req.getHttpMethod()})).build();
            throw new ApiException(status);
        }
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DashScopeResult send(HalfDuplexRequest req) throws NoApiKeyException, ApiException {
        Request request = this.buildRequest(req.getHttpRequest());
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                Status status = this.parseFailed(response);
                throw new ApiException(status);
            }
            DashScopeResult dashScopeResult = (DashScopeResult)new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(response.body().string()).build(), req.getIsFlatten());
            return dashScopeResult;
        }
        catch (Throwable e) {
            throw new ApiException(e);
        }
    }

    @Override
    public void send(final HalfDuplexRequest req, final ResultCallback<DashScopeResult> callback) throws NoApiKeyException, ApiException {
        Request request = this.buildRequest(req.getHttpRequest());
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onError(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (!response.isSuccessful()) {
                        Status status = OkHttpHttpClient.this.parseFailed(response);
                        callback.onError(new ApiException(status));
                    } else {
                        callback.onEvent(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(response.body().string()).build(), req.getIsFlatten()));
                        callback.onComplete();
                    }
                }
            }
        });
    }

    private void handleSSEEvent(FlowableEmitter<DashScopeResult> emitter, String id, String eventType, String data, boolean isFlattenResult) {
        log.debug(String.format("Event: id %s, type: %s, data: %s", id, eventType, data));
        if ("error".equals(eventType)) {
            Status st = this.parseStreamEventData(data);
            emitter.onError((Throwable)new ApiException(st));
        } else if ("data".equals(eventType) || "result".equals(eventType)) {
            emitter.onNext(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(data).event(eventType).build(), isFlattenResult));
        } else if ("done".equals(eventType)) {
            log.debug(String.format("Ignore event id: %s, type: %s, data: %s", id, eventType, data));
        } else if (eventType != null) {
            emitter.onNext(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(data).event(eventType).build(), isFlattenResult));
        } else if (eventType == null) {
            emitter.onNext(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(data).build(), isFlattenResult));
        }
    }

    @Override
    public Flowable<DashScopeResult> streamOut(final HalfDuplexRequest req) throws NoApiKeyException, ApiException {
        Flowable flowable = Flowable.create(emitter -> {
            Request request = this.buildRequest(req.getHttpRequest());
            EventSources.createFactory((OkHttpClient)this.client).newEventSource(request, new EventSourceListener(){

                public void onEvent(EventSource eventSource, String id, String type, String data) {
                    OkHttpHttpClient.this.handleSSEEvent((FlowableEmitter<DashScopeResult>)emitter, id, type, data, req.getIsFlatten());
                }

                public void onOpen(EventSource eventSource, Response response) {
                    super.onOpen(eventSource, response);
                }

                public void onFailure(EventSource eventSource, Throwable t, Response response) {
                    super.onFailure(eventSource, t, response);
                    emitter.onError((Throwable)new ApiException(OkHttpHttpClient.this.parseFailed(response)));
                }

                public void onClosed(EventSource eventSource) {
                    super.onClosed(eventSource);
                    emitter.onComplete();
                }
            });
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        return flowable;
    }

    @Override
    public void streamOut(final HalfDuplexRequest req, final ResultCallback<DashScopeResult> callback) throws NoApiKeyException, ApiException {
        Request request = this.buildRequest(req.getHttpRequest());
        EventSources.createFactory((OkHttpClient)this.client).newEventSource(request, new EventSourceListener(){

            public void onEvent(EventSource eventSource, String id, String type, String data) {
                log.debug(String.format("Event: id %s, type: %s, data: %s", id, type, data));
                if ("error".equals(type)) {
                    Status st = OkHttpHttpClient.this.parseStreamEventData(data);
                    callback.onError(new ApiException(st));
                } else if ("data".equals(type) || "result".equals(type)) {
                    callback.onEvent(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(data).event(type).build(), req.getIsFlatten()));
                } else if (type != null) {
                    callback.onEvent(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(data).event(type).build(), req.getIsFlatten()));
                } else if (type == null) {
                    callback.onEvent(new DashScopeResult().fromResponse(Protocol.HTTP, NetworkResponse.builder().message(data).build(), req.getIsFlatten()));
                }
            }

            public void onOpen(EventSource eventSource, Response response) {
                callback.onOpen(null);
            }

            public void onFailure(EventSource eventSource, Throwable t, Response response) {
                callback.onError(new ApiException(OkHttpHttpClient.this.parseFailed(response)));
            }

            public void onClosed(EventSource eventSource) {
                callback.onComplete();
            }
        });
    }

    private class SSEEventType {
        public static final String ERROR = "error";
        public static final String DATA = "data";
        public static final String DONE = "done";
        public static final String RESULT = "result";

        private SSEEventType() {
        }
    }
}

