/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.metadata.property;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.enums.HeadKindEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.Holder;
import com.alibaba.excel.util.ClassUtils;
import com.alibaba.excel.util.FieldUtils;
import com.alibaba.excel.util.MapUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.write.metadata.holder.AbstractWriteHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHeadProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelHeadProperty.class);
    private Class<?> headClazz;
    private HeadKindEnum headKind;
    private int headRowNumber;
    private Map<Integer, Head> headMap;
    private Map<String, Field> ignoreMap;

    public ExcelHeadProperty(Holder holder, Class<?> headClazz, List<List<String>> head) {
        this.headClazz = headClazz;
        this.headMap = new TreeMap<Integer, Head>();
        this.ignoreMap = MapUtils.newHashMap();
        this.headKind = HeadKindEnum.NONE;
        this.headRowNumber = 0;
        if (head != null && !head.isEmpty()) {
            int headIndex = 0;
            for (int i = 0; i < head.size(); ++i) {
                if (holder instanceof AbstractWriteHolder && ((AbstractWriteHolder)holder).ignore(null, i)) continue;
                this.headMap.put(headIndex, new Head(headIndex, null, null, head.get(i), Boolean.FALSE, Boolean.TRUE));
                ++headIndex;
            }
            this.headKind = HeadKindEnum.STRING;
        }
        this.initColumnProperties(holder);
        this.initHeadRowNumber();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The initialization sheet/table 'ExcelHeadProperty' is complete , head kind is {}", (Object)this.headKind);
        }
    }

    private void initHeadRowNumber() {
        List<String> list;
        this.headRowNumber = 0;
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.size() <= this.headRowNumber) continue;
            this.headRowNumber = list.size();
        }
        for (Head head : this.headMap.values()) {
            list = head.getHeadNameList();
            if (list == null || list.isEmpty() || list.size() >= this.headRowNumber) continue;
            int lack = this.headRowNumber - list.size();
            int last = list.size() - 1;
            for (int i = 0; i < lack; ++i) {
                list.add(list.get(last));
            }
        }
    }

    private void initColumnProperties(Holder holder) {
        if (this.headClazz == null) {
            return;
        }
        TreeMap<Integer, Field> sortedAllFieldMap = MapUtils.newTreeMap();
        TreeMap<Integer, Field> indexFieldMap = MapUtils.newTreeMap();
        boolean needIgnore = holder instanceof AbstractWriteHolder && (!CollectionUtils.isEmpty(((AbstractWriteHolder)holder).getExcludeColumnFieldNames()) || !CollectionUtils.isEmpty(((AbstractWriteHolder)holder).getExcludeColumnIndexes()) || !CollectionUtils.isEmpty(((AbstractWriteHolder)holder).getIncludeColumnFieldNames()) || !CollectionUtils.isEmpty(((AbstractWriteHolder)holder).getIncludeColumnIndexes()));
        ClassUtils.declaredFields(this.headClazz, sortedAllFieldMap, indexFieldMap, this.ignoreMap, needIgnore, holder);
        for (Map.Entry entry : sortedAllFieldMap.entrySet()) {
            this.initOneColumnProperty((Integer)entry.getKey(), (Field)entry.getValue(), indexFieldMap.containsKey(entry.getKey()));
        }
        this.headKind = HeadKindEnum.CLASS;
    }

    private void initOneColumnProperty(int index, Field field, Boolean forceIndex) {
        boolean notForceName;
        ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
        ArrayList<String> tmpHeadList = new ArrayList<String>();
        String fieldName = FieldUtils.resolveCglibFieldName(field);
        boolean bl = notForceName = excelProperty == null || excelProperty.value().length <= 0 || excelProperty.value().length == 1 && StringUtils.isEmpty(excelProperty.value()[0]);
        if (this.headMap.containsKey(index)) {
            tmpHeadList.addAll(this.headMap.get(index).getHeadNameList());
        } else if (notForceName) {
            tmpHeadList.add(fieldName);
        } else {
            Collections.addAll(tmpHeadList, excelProperty.value());
        }
        Head head = new Head(index, field, fieldName, tmpHeadList, forceIndex, !notForceName);
        this.headMap.put(index, head);
    }

    public boolean hasHead() {
        return this.headKind != HeadKindEnum.NONE;
    }

    public Class<?> getHeadClazz() {
        return this.headClazz;
    }

    public HeadKindEnum getHeadKind() {
        return this.headKind;
    }

    public int getHeadRowNumber() {
        return this.headRowNumber;
    }

    public Map<Integer, Head> getHeadMap() {
        return this.headMap;
    }

    public Map<String, Field> getIgnoreMap() {
        return this.ignoreMap;
    }

    public void setHeadClazz(Class<?> headClazz) {
        this.headClazz = headClazz;
    }

    public void setHeadKind(HeadKindEnum headKind) {
        this.headKind = headKind;
    }

    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    public void setHeadMap(Map<Integer, Head> headMap) {
        this.headMap = headMap;
    }

    public void setIgnoreMap(Map<String, Field> ignoreMap) {
        this.ignoreMap = ignoreMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelHeadProperty)) {
            return false;
        }
        ExcelHeadProperty other = (ExcelHeadProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHeadRowNumber() != other.getHeadRowNumber()) {
            return false;
        }
        Class<?> this$headClazz = this.getHeadClazz();
        Class<?> other$headClazz = other.getHeadClazz();
        if (this$headClazz == null ? other$headClazz != null : !this$headClazz.equals(other$headClazz)) {
            return false;
        }
        HeadKindEnum this$headKind = this.getHeadKind();
        HeadKindEnum other$headKind = other.getHeadKind();
        if (this$headKind == null ? other$headKind != null : !((Object)((Object)this$headKind)).equals((Object)other$headKind)) {
            return false;
        }
        Map<Integer, Head> this$headMap = this.getHeadMap();
        Map<Integer, Head> other$headMap = other.getHeadMap();
        if (this$headMap == null ? other$headMap != null : !((Object)this$headMap).equals(other$headMap)) {
            return false;
        }
        Map<String, Field> this$ignoreMap = this.getIgnoreMap();
        Map<String, Field> other$ignoreMap = other.getIgnoreMap();
        return !(this$ignoreMap == null ? other$ignoreMap != null : !((Object)this$ignoreMap).equals(other$ignoreMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelHeadProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHeadRowNumber();
        Class<?> $headClazz = this.getHeadClazz();
        result = result * 59 + ($headClazz == null ? 43 : $headClazz.hashCode());
        HeadKindEnum $headKind = this.getHeadKind();
        result = result * 59 + ($headKind == null ? 43 : ((Object)((Object)$headKind)).hashCode());
        Map<Integer, Head> $headMap = this.getHeadMap();
        result = result * 59 + ($headMap == null ? 43 : ((Object)$headMap).hashCode());
        Map<String, Field> $ignoreMap = this.getIgnoreMap();
        result = result * 59 + ($ignoreMap == null ? 43 : ((Object)$ignoreMap).hashCode());
        return result;
    }
}

