/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser.deserializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public class JavaObjectDeserializer
implements ObjectDeserializer {
    public static final JavaObjectDeserializer instance = new JavaObjectDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            if (componentType instanceof TypeVariable) {
                TypeVariable componentVar = (TypeVariable)componentType;
                componentType = componentVar.getBounds()[0];
            }
            ArrayList list = new ArrayList();
            parser.parseArray(componentType, list);
            if (componentType instanceof Class) {
                Class componentClass = (Class)componentType;
                if (componentClass == Boolean.TYPE) {
                    return (T)TypeUtils.cast(list, boolean[].class, parser.getConfig());
                }
                if (componentClass == Short.TYPE) {
                    return (T)TypeUtils.cast(list, short[].class, parser.getConfig());
                }
                if (componentClass == Integer.TYPE) {
                    return (T)TypeUtils.cast(list, int[].class, parser.getConfig());
                }
                if (componentClass == Long.TYPE) {
                    return (T)TypeUtils.cast(list, long[].class, parser.getConfig());
                }
                if (componentClass == Float.TYPE) {
                    return (T)TypeUtils.cast(list, float[].class, parser.getConfig());
                }
                if (componentClass == Double.TYPE) {
                    return (T)TypeUtils.cast(list, double[].class, parser.getConfig());
                }
                Object[] array = (Object[])Array.newInstance(componentClass, list.size());
                list.toArray(array);
                return (T)array;
            }
            return (T)list.toArray();
        }
        return (T)parser.parse(fieldName);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

