/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexerBase;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.DateUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.util.Calendar;

public class JSONScanner
extends JSONLexerBase
implements Closeable {
    private final JSONReader reader;
    private boolean orderedField;
    protected int token;
    private String strVal;
    protected Calendar calendar;
    protected String str;

    public JSONScanner(JSONReader reader) {
        this.reader = reader;
    }

    public JSONScanner(String str) {
        this.reader = JSONReader.of((String)str);
        this.str = str;
    }

    public JSONScanner(String str, int features) {
        this.reader = JSONReader.of((String)str, (JSONReader.Context)JSON.createReadContext(features, new Feature[0]));
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    public boolean scanISO8601DateIfMatch(boolean strict) {
        if (this.str != null) {
            try {
                long millis = DateUtils.parseMillis((String)this.str);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(millis);
                this.calendar = calendar;
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public JSONReader getReader() {
        return this.reader;
    }

    public boolean isOrderedField() {
        return this.orderedField;
    }

    @Override
    public String stringVal() {
        return this.strVal;
    }

    @Override
    public BigDecimal decimalValue() {
        return this.reader.getBigDecimal();
    }

    public int token() {
        return this.token;
    }

    public void config(Feature feature, boolean state) {
        JSONReader.Feature rawFeature = null;
        boolean not = false;
        switch (feature) {
            case AllowUnQuotedFieldNames: {
                rawFeature = JSONReader.Feature.AllowUnQuotedFieldNames;
                break;
            }
            case SupportArrayToBean: {
                rawFeature = JSONReader.Feature.SupportArrayToBean;
                break;
            }
            case DisableFieldSmartMatch: {
                rawFeature = JSONReader.Feature.SupportSmartMatch;
                not = true;
                break;
            }
            case SupportAutoType: {
                rawFeature = JSONReader.Feature.SupportAutoType;
                break;
            }
            case NonStringKeyAsString: {
                rawFeature = JSONReader.Feature.NonStringKeyAsString;
                break;
            }
            case ErrorOnEnumNotMatch: {
                rawFeature = JSONReader.Feature.ErrorOnEnumNotMatch;
                break;
            }
            case SupportClassForName: {
                rawFeature = JSONReader.Feature.SupportClassForName;
                break;
            }
            case ErrorOnNotSupportAutoType: {
                rawFeature = JSONReader.Feature.ErrorOnNotSupportAutoType;
                break;
            }
            case UseNativeJavaObject: {
                rawFeature = JSONReader.Feature.UseNativeObject;
                break;
            }
            case UseBigDecimal: {
                rawFeature = JSONReader.Feature.UseDoubleForDecimals;
                not = true;
                break;
            }
            case OrderedField: {
                this.orderedField = state;
                break;
            }
        }
        if (rawFeature == null) {
            return;
        }
        if (not) {
            state = !state;
        }
        JSONReader.Context context = this.reader.getContext();
        context.config(rawFeature, state);
    }

    public boolean isEnabled(Feature feature) {
        JSONReader.Feature rawFeature = null;
        switch (feature) {
            case AllowUnQuotedFieldNames: {
                rawFeature = JSONReader.Feature.AllowUnQuotedFieldNames;
                break;
            }
            case SupportArrayToBean: {
                rawFeature = JSONReader.Feature.SupportArrayToBean;
                break;
            }
            case DisableFieldSmartMatch: {
                return !this.reader.isEnabled(JSONReader.Feature.SupportSmartMatch);
            }
            case SupportAutoType: {
                rawFeature = JSONReader.Feature.SupportAutoType;
                break;
            }
            case NonStringKeyAsString: {
                rawFeature = JSONReader.Feature.NonStringKeyAsString;
                break;
            }
            case ErrorOnEnumNotMatch: {
                rawFeature = JSONReader.Feature.ErrorOnEnumNotMatch;
                break;
            }
            case SupportClassForName: {
                rawFeature = JSONReader.Feature.SupportClassForName;
                break;
            }
            case ErrorOnNotSupportAutoType: {
                rawFeature = JSONReader.Feature.ErrorOnNotSupportAutoType;
                break;
            }
            case UseNativeJavaObject: {
                rawFeature = JSONReader.Feature.UseNativeObject;
                break;
            }
            case UseBigDecimal: {
                return !this.reader.isEnabled(JSONReader.Feature.UseDoubleForDecimals);
            }
        }
        if (rawFeature == null) {
            return true;
        }
        return this.reader.isEnabled(rawFeature);
    }

    @Override
    public boolean isBlankInput() {
        return this.reader.isEnd();
    }

    @Override
    public int intValue() {
        return this.reader.getInt32Value();
    }

    @Override
    public long longValue() {
        return this.reader.getInt64Value();
    }

    @Override
    public final void nextToken() {
        this.strVal = null;
        char ch = this.reader.current();
        switch (ch) {
            case '[': {
                this.reader.next();
                this.token = 14;
                return;
            }
            case ']': {
                this.reader.next();
                this.token = 15;
                return;
            }
            case '{': {
                this.reader.next();
                this.token = 12;
                return;
            }
            case '}': {
                this.reader.next();
                this.token = 13;
                return;
            }
            case ':': {
                this.reader.next();
                this.token = 17;
                return;
            }
            case '\"': 
            case '\'': {
                this.strVal = this.reader.readString();
                this.token = 4;
                return;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                Number number = this.reader.readNumber();
                this.token = number instanceof BigDecimal || number instanceof Float || number instanceof Double ? 3 : 2;
                return;
            }
            case 'f': 
            case 't': {
                boolean boolValue = this.reader.readBoolValue();
                this.token = boolValue ? 6 : 7;
                return;
            }
            case 'n': {
                this.reader.readNull();
                this.token = 8;
                return;
            }
            case '\u001a': {
                this.token = 20;
                return;
            }
        }
        if (this.reader.nextIfNull()) {
            return;
        }
        throw new JSONException("not support operation");
    }

    @Override
    public char getCurrent() {
        return this.reader.current();
    }

    @Override
    public final void nextToken(int expect) {
        this.nextToken();
    }

    @Override
    public boolean isEOF() {
        return this.reader.isEnd();
    }

    @Override
    public void close() {
    }
}

