/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerCrashException;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class UnassignProcedure
extends RegionTransitionProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(UnassignProcedure.class);
    protected volatile ServerName hostingServer;
    protected volatile ServerName destinationServer;
    private boolean force;
    private boolean removeAfterUnassigning;

    public UnassignProcedure() {
    }

    public UnassignProcedure(RegionInfo regionInfo, ServerName hostingServer, boolean force, boolean removeAfterUnassigning) {
        this(regionInfo, hostingServer, null, force, removeAfterUnassigning);
    }

    public UnassignProcedure(RegionInfo regionInfo, ServerName hostingServer, ServerName destinationServer, boolean force) {
        this(regionInfo, hostingServer, destinationServer, force, false);
    }

    public UnassignProcedure(RegionInfo regionInfo, ServerName hostingServer, ServerName destinationServer, boolean force, boolean removeAfterUnassigning) {
        super(regionInfo);
        this.hostingServer = hostingServer;
        this.destinationServer = destinationServer;
        this.force = force;
        this.removeAfterUnassigning = removeAfterUnassigning;
        this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH);
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_UNASSIGN;
    }

    @Override
    protected boolean isRollbackSupported(MasterProcedureProtos.RegionTransitionState state) {
        switch (state) {
            case REGION_TRANSITION_QUEUE: 
            case REGION_TRANSITION_DISPATCH: {
                return true;
            }
        }
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.UnassignRegionStateData.Builder state = MasterProcedureProtos.UnassignRegionStateData.newBuilder().setTransitionState(this.getTransitionState()).setHostingServer(ProtobufUtil.toServerName((ServerName)this.hostingServer)).setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.getRegionInfo()));
        if (this.destinationServer != null) {
            state.setDestinationServer(ProtobufUtil.toServerName((ServerName)this.destinationServer));
        }
        if (this.force) {
            state.setForce(true);
        }
        if (this.removeAfterUnassigning) {
            state.setRemoveAfterUnassigning(true);
        }
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.UnassignRegionStateData state = (MasterProcedureProtos.UnassignRegionStateData)serializer.deserialize(MasterProcedureProtos.UnassignRegionStateData.class);
        this.setTransitionState(state.getTransitionState());
        this.setRegionInfo(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)state.getRegionInfo()));
        this.hostingServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getHostingServer());
        this.force = state.getForce();
        if (state.hasDestinationServer()) {
            this.destinationServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getDestinationServer());
        }
        this.removeAfterUnassigning = state.getRemoveAfterUnassigning();
    }

    @Override
    protected boolean startTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean updateTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException {
        if (regionNode.isInState(RegionState.State.CLOSED, RegionState.State.OFFLINE)) {
            LOG.info("Not unassigned " + this + "; " + regionNode.toShortString());
            return false;
        }
        if (this.aborted.get() && regionNode.isInState(RegionState.State.OPEN)) {
            this.setAbortFailure(this.getClass().getSimpleName(), "abort requested");
            return false;
        }
        env.getAssignmentManager().markRegionAsClosing(regionNode);
        if (!this.addToRemoteDispatcher(env, regionNode.getRegionLocation())) {
            // empty if block
        }
        return true;
    }

    @Override
    protected void finishTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) throws IOException {
        AssignmentManager am = env.getAssignmentManager();
        RegionInfo regionInfo = this.getRegionInfo();
        if (!this.removeAfterUnassigning) {
            am.markRegionAsClosed(regionNode);
        } else {
            am.getRegionStates().deleteRegion(regionInfo);
            env.getMasterServices().getServerManager().removeRegion(regionInfo);
            FavoredNodesManager fnm = env.getMasterServices().getFavoredNodesManager();
            if (fnm != null) {
                fnm.deleteFavoredNodesForRegions(Lists.newArrayList((Object[])new RegionInfo[]{regionInfo}));
            }
        }
    }

    @Override
    public RemoteProcedureDispatcher.RemoteOperation remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        assert (serverName.equals((Object)this.getRegionState(env).getRegionLocation()));
        return new RSProcedureDispatcher.RegionCloseOperation(this, this.getRegionInfo(), this.destinationServer);
    }

    @Override
    protected void reportTransition(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long seqId) throws UnexpectedStateException {
        switch (code) {
            case CLOSED: {
                this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_FINISH);
                break;
            }
            default: {
                throw new UnexpectedStateException(String.format("Received report unexpected transition state=%s for region=%s server=%s, expected CLOSED.", code, regionNode.getRegionInfo(), regionNode.getRegionLocation()));
            }
        }
    }

    @Override
    protected boolean remoteCallFailed(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode, IOException exception) {
        if (exception instanceof ServerCrashException) {
            try {
                this.reportTransition(env, regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED, -1L);
            }
            catch (UnexpectedStateException e) {
                throw new RuntimeException(e);
            }
        } else if (exception instanceof RegionServerAbortedException || exception instanceof RegionServerStoppedException || exception instanceof ServerNotRunningYetException) {
            LOG.info("Ignoring; waiting on ServerCrashProcedure", (Throwable)exception);
        } else if (exception instanceof NotServingRegionException) {
            LOG.info("IS THIS OK? ANY LOGS TO REPLAY; ACTING AS THOUGH ALL GOOD " + regionNode, (Throwable)exception);
            this.setTransitionState(MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_FINISH);
        } else {
            LOG.warn("Expiring server " + this + "; " + regionNode.toShortString() + ", exception=" + exception);
            env.getMasterServices().getServerManager().expireServer(regionNode.getRegionLocation());
            return false;
        }
        return true;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        super.toStringClassDetails(sb);
        sb.append(", server=").append(this.hostingServer);
    }

    @Override
    public ServerName getServer(MasterProcedureEnv env) {
        return this.hostingServer;
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getUnassignProcMetrics();
    }
}

