/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SpaceQuotaRefresherChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceQuotaRefresherChore.class);
    static final String POLICY_REFRESHER_CHORE_PERIOD_KEY = "hbase.regionserver.quotas.policy.refresher.chore.period";
    static final int POLICY_REFRESHER_CHORE_PERIOD_DEFAULT = 60000;
    static final String POLICY_REFRESHER_CHORE_DELAY_KEY = "hbase.regionserver.quotas.policy.refresher.chore.delay";
    static final long POLICY_REFRESHER_CHORE_DELAY_DEFAULT = 15000L;
    static final String POLICY_REFRESHER_CHORE_TIMEUNIT_KEY = "hbase.regionserver.quotas.policy.refresher.chore.timeunit";
    static final String POLICY_REFRESHER_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    static final String POLICY_REFRESHER_CHORE_REPORT_PERCENT_KEY = "hbase.regionserver.quotas.policy.refresher.report.percent";
    static final double POLICY_REFRESHER_CHORE_REPORT_PERCENT_DEFAULT = 0.95;
    private final RegionServerSpaceQuotaManager manager;
    private final Connection conn;

    public SpaceQuotaRefresherChore(RegionServerSpaceQuotaManager manager, Connection conn) {
        super(SpaceQuotaRefresherChore.class.getSimpleName(), (Stoppable)manager.getRegionServerServices(), SpaceQuotaRefresherChore.getPeriod(manager.getRegionServerServices().getConfiguration()), SpaceQuotaRefresherChore.getInitialDelay(manager.getRegionServerServices().getConfiguration()), SpaceQuotaRefresherChore.getTimeUnit(manager.getRegionServerServices().getConfiguration()));
        this.manager = manager;
        this.conn = conn;
    }

    protected void chore() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Reading current quota snapshots from hbase:quota.");
            }
            Map<TableName, SpaceQuotaSnapshot> currentSnapshots = this.getManager().copyQuotaSnapshots();
            Map<TableName, SpaceQuotaSnapshot> newSnapshots = this.fetchSnapshotsFromQuotaTable();
            if (LOG.isTraceEnabled()) {
                LOG.trace(currentSnapshots.size() + " table quota snapshots are collected, read " + newSnapshots.size() + " from the quota table.");
            }
            for (Map.Entry<TableName, SpaceQuotaSnapshot> entry : newSnapshots.entrySet()) {
                TableName tableName = entry.getKey();
                SpaceQuotaSnapshot newSnapshot = entry.getValue();
                SpaceQuotaSnapshot currentSnapshot = currentSnapshots.get(tableName);
                if (LOG.isTraceEnabled()) {
                    LOG.trace(tableName + ": current=" + currentSnapshot + ", new=" + newSnapshot);
                }
                if (newSnapshot.equals((Object)currentSnapshot)) continue;
                if (!this.isInViolation(currentSnapshot) && newSnapshot.getQuotaStatus().isInViolation()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Enabling " + newSnapshot + " on " + tableName);
                    }
                    this.getManager().enforceViolationPolicy(tableName, newSnapshot);
                }
                if (!this.isInViolation(currentSnapshot) || newSnapshot.getQuotaStatus().isInViolation()) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removing quota violation policy on " + tableName);
                }
                this.getManager().disableViolationPolicyEnforcement(tableName);
            }
            this.getManager().updateQuotaSnapshot(newSnapshots);
        }
        catch (IOException e) {
            LOG.warn("Caught exception while refreshing enforced quota violation policies, will retry.", (Throwable)e);
        }
    }

    boolean isInViolation(SpaceQuotaSnapshot snapshot) {
        if (snapshot == null) {
            return false;
        }
        return snapshot.getQuotaStatus().isInViolation();
    }

    /*
     * Exception decompiling
     */
    public Map<TableName, SpaceQuotaSnapshot> fetchSnapshotsFromQuotaTable() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void extractQuotaSnapshot(Result result, Map<TableName, SpaceQuotaSnapshot> snapshots) {
        QuotaTableUtil.extractQuotaSnapshot((Result)result, snapshots);
    }

    Connection getConnection() {
        return this.conn;
    }

    RegionServerSpaceQuotaManager getManager() {
        return this.manager;
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(POLICY_REFRESHER_CHORE_PERIOD_KEY, 60000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(POLICY_REFRESHER_CHORE_DELAY_KEY, 15000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(POLICY_REFRESHER_CHORE_TIMEUNIT_KEY, POLICY_REFRESHER_CHORE_TIMEUNIT_DEFAULT));
    }

    static Double getRegionReportPercent(Configuration conf) {
        return conf.getDouble(POLICY_REFRESHER_CHORE_REPORT_PERCENT_KEY, 0.95);
    }
}

