/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FIFOCompactionPolicy
extends ExploringCompactionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FIFOCompactionPolicy.class);

    public FIFOCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    @Override
    public CompactionRequestImpl selectCompaction(Collection<HStoreFile> candidateFiles, List<HStoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
        boolean isAfterSplit;
        if (forceMajor) {
            LOG.warn("Major compaction is not supported for FIFO compaction policy. Ignore the flag.");
        }
        if (isAfterSplit = StoreUtils.hasReferences(candidateFiles)) {
            LOG.info("Split detected, delegate selection to the parent policy.");
            return super.selectCompaction(candidateFiles, filesCompacting, isUserCompaction, mayUseOffPeak, forceMajor);
        }
        Collection<HStoreFile> toCompact = this.getExpiredStores(candidateFiles, filesCompacting);
        CompactionRequestImpl result = new CompactionRequestImpl(toCompact);
        return result;
    }

    @Override
    public boolean shouldPerformMajorCompaction(Collection<HStoreFile> filesToCompact) throws IOException {
        boolean isAfterSplit = StoreUtils.hasReferences(filesToCompact);
        if (isAfterSplit) {
            LOG.info("Split detected, delegate to the parent policy.");
            return super.shouldPerformMajorCompaction(filesToCompact);
        }
        return false;
    }

    @Override
    public boolean needsCompaction(Collection<HStoreFile> storeFiles, List<HStoreFile> filesCompacting) {
        boolean isAfterSplit = StoreUtils.hasReferences(storeFiles);
        if (isAfterSplit) {
            LOG.info("Split detected, delegate to the parent policy.");
            return super.needsCompaction(storeFiles, filesCompacting);
        }
        return this.hasExpiredStores(storeFiles);
    }

    private boolean hasExpiredStores(Collection<HStoreFile> files) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        for (HStoreFile sf : files) {
            long maxTs = sf.getReader().getMaxTimestamp();
            long maxTtl = this.storeConfigInfo.getStoreFileTtl();
            if (maxTtl == Long.MAX_VALUE || currentTime - maxTtl < maxTs) continue;
            return true;
        }
        return false;
    }

    private Collection<HStoreFile> getExpiredStores(Collection<HStoreFile> files, Collection<HStoreFile> filesCompacting) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        ArrayList<HStoreFile> expiredStores = new ArrayList<HStoreFile>();
        for (HStoreFile sf : files) {
            long maxTs = sf.getReader().getMaxTimestamp();
            long maxTtl = this.storeConfigInfo.getStoreFileTtl();
            if (maxTtl == Long.MAX_VALUE || currentTime - maxTtl < maxTs || filesCompacting != null && filesCompacting.contains(sf)) continue;
            expiredStores.add(sf);
        }
        return expiredStores;
    }
}

