/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.SecureBulkLoadClient;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.FsDelegationToken;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimaps;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.RateLimiter;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class LoadIncrementalHFiles
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(LoadIncrementalHFiles.class);
    public static final String NAME = "completebulkload";
    static final String RETRY_ON_IO_EXCEPTION = "hbase.bulkload.retries.retryOnIOException";
    public static final String MAX_FILES_PER_REGION_PER_FAMILY = "hbase.mapreduce.bulkload.max.hfiles.perRegion.perFamily";
    private static final String ASSIGN_SEQ_IDS = "hbase.mapreduce.bulkload.assign.sequenceNumbers";
    public static final String CREATE_TABLE_CONF_KEY = "create.table";
    public static final String IGNORE_UNMATCHED_CF_CONF_KEY = "ignore.unmatched.families";
    public static final String ALWAYS_COPY_FILES = "always.copy.files";
    static final String TMP_DIR = ".tmp";
    private final int maxFilesPerRegionPerFamily;
    private final boolean assignSeqIds;
    private final FsDelegationToken fsDelegationToken;
    private final UserProvider userProvider;
    private final int nrThreads;
    private AtomicInteger numRetries;
    private final RpcControllerFactory rpcControllerFactory;
    private RateLimiter rateLimiter;
    private String bulkToken;

    public LoadIncrementalHFiles(Configuration conf) {
        super(HBaseConfiguration.create((Configuration)conf));
        conf = this.getConf();
        conf.setFloat("hfile.block.cache.size", 0.0f);
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.fsDelegationToken = new FsDelegationToken(this.userProvider, "renewer");
        this.assignSeqIds = conf.getBoolean(ASSIGN_SEQ_IDS, true);
        this.maxFilesPerRegionPerFamily = conf.getInt(MAX_FILES_PER_REGION_PER_FAMILY, 32);
        this.nrThreads = conf.getInt("hbase.loadincremental.threads.max", Runtime.getRuntime().availableProcessors());
        this.numRetries = new AtomicInteger(0);
        this.rpcControllerFactory = new RpcControllerFactory(conf);
    }

    private void usage() {
        System.err.println("usage: completebulkload /path/to/hfileoutputformat-output tablename -loadTable\n -Dcreate.table=no - can be used to avoid creation of table by this tool\n  Note: if you set this to 'no', then the target table must already exist in HBase\n -loadTable implies your baseDirectory to store file has a depth of 3 ,you must have an existing table\n-Dignore.unmatched.families=yes - can be used to ignore unmatched column families\n\n");
    }

    public void prepareHFileQueue(Path hfilesDir, Table table, Deque<LoadQueueItem> queue, boolean validateHFile) throws IOException {
        this.prepareHFileQueue(hfilesDir, table, queue, validateHFile, false);
    }

    public void prepareHFileQueue(Path hfilesDir, Table table, Deque<LoadQueueItem> queue, boolean validateHFile, boolean silence) throws IOException {
        this.discoverLoadQueue(queue, hfilesDir, validateHFile);
        this.validateFamiliesInHFiles(table, queue, silence);
    }

    public void prepareHFileQueue(Map<byte[], List<Path>> map, Table table, Deque<LoadQueueItem> queue, boolean silence) throws IOException {
        this.populateLoadQueue(queue, map);
        this.validateFamiliesInHFiles(table, queue, silence);
    }

    public Map<LoadQueueItem, ByteBuffer> doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator) throws TableNotFoundException, IOException {
        return this.doBulkLoad(hfofDir, admin, table, regionLocator, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LoadQueueItem, ByteBuffer> doBulkLoad(Map<byte[], List<Path>> map, Admin admin, Table table, RegionLocator regionLocator, boolean silence, boolean copyFile) throws TableNotFoundException, IOException {
        SecureBulkLoadClient secureClient;
        ExecutorService pool;
        ArrayDeque<LoadQueueItem> queue;
        block4: {
            Map<LoadQueueItem, ByteBuffer> map2;
            if (!admin.isTableAvailable(regionLocator.getName())) {
                throw new TableNotFoundException("Table " + table.getName() + " is not currently available.");
            }
            queue = new ArrayDeque<LoadQueueItem>();
            pool = null;
            secureClient = null;
            try {
                this.prepareHFileQueue(map, table, queue, silence);
                if (!queue.isEmpty()) break block4;
                LOG.warn("Bulk load operation did not get any files to load");
                map2 = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                this.cleanup(admin, queue, pool, secureClient);
                throw throwable;
            }
            this.cleanup(admin, queue, pool, secureClient);
            return map2;
        }
        pool = this.createExecutorService();
        secureClient = new SecureBulkLoadClient(table.getConfiguration(), table);
        Map<LoadQueueItem, ByteBuffer> map3 = this.performBulkLoad(admin, table, regionLocator, queue, pool, secureClient, copyFile);
        this.cleanup(admin, queue, pool, secureClient);
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LoadQueueItem, ByteBuffer> doBulkLoad(Path hfofDir, Admin admin, Table table, RegionLocator regionLocator, boolean silence, boolean copyFile) throws TableNotFoundException, IOException {
        SecureBulkLoadClient secureClient;
        ExecutorService pool;
        ArrayDeque<LoadQueueItem> queue;
        block7: {
            Map<LoadQueueItem, ByteBuffer> map;
            if (!admin.isTableAvailable(regionLocator.getName())) {
                throw new TableNotFoundException("Table " + table.getName() + " is not currently available.");
            }
            double loadedFilesPerSeconds = this.getConf().getDouble("hbase.loadincremental.regions.per.seconds", -1.0);
            double minimumLoadedFilesPerSeconds = this.getConf().getDouble("hbase.loadincremental.regions.per.seconds.minimum-limit", 0.016666666666666666);
            if (loadedFilesPerSeconds <= 0.0) {
                this.rateLimiter = null;
            } else {
                this.rateLimiter = RateLimiter.create((double)Math.max(loadedFilesPerSeconds, minimumLoadedFilesPerSeconds));
                LOG.info("Created RateLimiter for loading " + hfofDir.toUri() + " . Loading region rate is set to " + this.rateLimiter.getRate() + "/s");
            }
            boolean validateHFile = this.getConf().getBoolean("hbase.loadincremental.validate.hfile", true);
            if (!validateHFile) {
                LOG.warn("You are skipping HFiles validation, it might cause some data loss if files are not correct. If you fail to read data from your table after using this option, consider removing the files and bulkload again without this option. See HBASE-13985");
            }
            queue = new ArrayDeque<LoadQueueItem>();
            pool = null;
            secureClient = null;
            try {
                this.prepareHFileQueue(hfofDir, table, queue, validateHFile, silence);
                if (!queue.isEmpty()) break block7;
                LOG.warn("Bulk load operation did not find any files to load in directory " + hfofDir != null ? hfofDir.toUri().toString() : ".  Does it contain files in subdirectories that correspond to column family names?");
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                this.cleanup(admin, queue, pool, secureClient);
                throw throwable;
            }
            this.cleanup(admin, queue, pool, secureClient);
            return map;
        }
        pool = this.createExecutorService();
        secureClient = new SecureBulkLoadClient(table.getConfiguration(), table);
        Map<LoadQueueItem, ByteBuffer> map = this.performBulkLoad(admin, table, regionLocator, queue, pool, secureClient, copyFile);
        this.cleanup(admin, queue, pool, secureClient);
        return map;
    }

    public void loadHFileQueue(Table table, Connection conn, Deque<LoadQueueItem> queue, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        this.loadHFileQueue(table, conn, queue, startEndKeys, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHFileQueue(Table table, Connection conn, Deque<LoadQueueItem> queue, Pair<byte[][], byte[][]> startEndKeys, boolean copyFile) throws IOException {
        ExecutorService pool = null;
        try {
            pool = this.createExecutorService();
            Multimap regionGroups = (Multimap)this.groupOrSplitPhase(table, pool, queue, startEndKeys).getFirst();
            this.bulkLoadPhase(table, conn, pool, queue, (Multimap<ByteBuffer, LoadQueueItem>)regionGroups, copyFile, null);
        }
        finally {
            if (pool != null) {
                pool.shutdown();
            }
        }
    }

    private Map<LoadQueueItem, ByteBuffer> performBulkLoad(Admin admin, Table table, RegionLocator regionLocator, Deque<LoadQueueItem> queue, ExecutorService pool, SecureBulkLoadClient secureClient, boolean copyFile) throws IOException {
        int count = 0;
        if (this.isSecureBulkLoadEndpointAvailable()) {
            LOG.warn("SecureBulkLoadEndpoint is deprecated. It will be removed in future releases.");
            LOG.warn("Secure bulk load has been integrated into HBase core.");
        }
        this.fsDelegationToken.acquireDelegationToken(queue.peek().getFilePath().getFileSystem(this.getConf()));
        this.bulkToken = secureClient.prepareBulkLoad(admin.getConnection());
        Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> pair = null;
        HashMap<LoadQueueItem, ByteBuffer> item2RegionMap = new HashMap<LoadQueueItem, ByteBuffer>();
        while (!queue.isEmpty()) {
            Pair startEndKeys = regionLocator.getStartEndKeys();
            if (count != 0) {
                LOG.info("Split occurred while grouping HFiles, retry attempt " + count + " with " + queue.size() + " files remaining to group or split");
            }
            int maxRetries = this.getConf().getInt("hbase.bulkload.retries.number", 10);
            if ((maxRetries = Math.max(maxRetries, ((byte[][])startEndKeys.getFirst()).length + 1)) != 0 && count >= maxRetries) {
                throw new IOException("Retry attempted " + count + " times without completing, bailing out");
            }
            ++count;
            pair = this.groupOrSplitPhase(table, pool, queue, (Pair<byte[][], byte[][]>)startEndKeys);
            Multimap regionGroups = (Multimap)pair.getFirst();
            if (!this.checkHFilesCountPerRegionPerFamily((Multimap<ByteBuffer, LoadQueueItem>)regionGroups)) {
                throw new IOException("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to one family of one region");
            }
            this.bulkLoadPhase(table, admin.getConnection(), pool, queue, (Multimap<ByteBuffer, LoadQueueItem>)regionGroups, copyFile, item2RegionMap);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Bulk load aborted with some files not yet loaded.Please check log for more details.");
        }
        return item2RegionMap;
    }

    @VisibleForTesting
    protected void bulkLoadPhase(final Table table, Connection conn, ExecutorService pool, Deque<LoadQueueItem> queue, Multimap<ByteBuffer, LoadQueueItem> regionGroups, boolean copyFile, Map<LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
        HashSet<Future<List<LoadQueueItem>>> loadingFutures = new HashSet<Future<List<LoadQueueItem>>>();
        for (Map.Entry entry : regionGroups.asMap().entrySet()) {
            final byte[] first = ((ByteBuffer)entry.getKey()).array();
            final Collection lqis = (Collection)entry.getValue();
            final ClientServiceCallable<byte[]> serviceCallable = this.buildClientServiceCallable(conn, table.getName(), first, lqis, copyFile);
            Callable<List<LoadQueueItem>> call = new Callable<List<LoadQueueItem>>(){

                @Override
                public List<LoadQueueItem> call() throws Exception {
                    if (LoadIncrementalHFiles.this.rateLimiter != null) {
                        LoadIncrementalHFiles.this.rateLimiter.acquire();
                    }
                    List<LoadQueueItem> toRetry = LoadIncrementalHFiles.this.tryAtomicRegionLoad((ClientServiceCallable<byte[]>)serviceCallable, table.getName(), first, lqis);
                    return toRetry;
                }
            };
            if (item2RegionMap != null) {
                Iterator iterator = lqis.iterator();
                while (iterator.hasNext()) {
                    LoadQueueItem lqi = (LoadQueueItem)iterator.next();
                    item2RegionMap.put(lqi, (ByteBuffer)entry.getKey());
                }
            }
            loadingFutures.add(pool.submit(call));
        }
        for (Future future : loadingFutures) {
            try {
                List toRetry = (List)future.get();
                if (item2RegionMap != null) {
                    for (LoadQueueItem lqi : toRetry) {
                        item2RegionMap.remove(lqi);
                    }
                }
                queue.addAll(toRetry);
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    throw new IOException("BulkLoad encountered an unrecoverable problem", t);
                }
                LOG.error("Unexpected execution exception during bulk load", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during bulk load", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
    }

    @VisibleForTesting
    protected ClientServiceCallable<byte[]> buildClientServiceCallable(final Connection conn, TableName tableName, byte[] first, final Collection<LoadQueueItem> lqis, final boolean copyFile) {
        final List famPaths = lqis.stream().map(lqi -> Pair.newPair((Object)lqi.getFamily(), (Object)lqi.getFilePath().toString())).collect(Collectors.toList());
        return new ClientServiceCallable<byte[]>(conn, tableName, first, (RpcController)this.rpcControllerFactory.newController(), -1){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected byte[] rpcCall() throws Exception {
                SecureBulkLoadClient secureClient = null;
                boolean success = false;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Going to connect to server " + this.getLocation() + " for row " + Bytes.toStringBinary((byte[])this.getRow()) + " with hfile group " + LoadIncrementalHFiles.this.toString(famPaths));
                    }
                    byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                    try (Table table = conn.getTable(this.getTableName());){
                        secureClient = new SecureBulkLoadClient(LoadIncrementalHFiles.this.getConf(), table);
                        success = secureClient.secureBulkLoadHFiles((ClientProtos.ClientService.BlockingInterface)this.getStub(), famPaths, regionName, LoadIncrementalHFiles.this.assignSeqIds, LoadIncrementalHFiles.this.fsDelegationToken.getUserToken(), LoadIncrementalHFiles.this.bulkToken, copyFile);
                    }
                    byte[] byArray = (byte[])(success ? regionName : null);
                    return byArray;
                }
                finally {
                    if (secureClient != null && !success) {
                        FileSystem targetFs = FileSystem.get((Configuration)LoadIncrementalHFiles.this.getConf());
                        FileSystem sourceFs = ((LoadQueueItem)lqis.iterator().next()).getFilePath().getFileSystem(LoadIncrementalHFiles.this.getConf());
                        if (FSHDFSUtils.isSameHdfs(LoadIncrementalHFiles.this.getConf(), sourceFs, targetFs)) {
                            for (Pair el : famPaths) {
                                Path hfileStagingPath = null;
                                Path hfileOrigPath = new Path((String)el.getSecond());
                                try {
                                    hfileStagingPath = new Path(new Path(LoadIncrementalHFiles.this.bulkToken, Bytes.toString((byte[])((byte[])el.getFirst()))), hfileOrigPath.getName());
                                    if (targetFs.rename(hfileStagingPath, hfileOrigPath)) {
                                        LOG.debug("Moved back file " + hfileOrigPath + " from " + hfileStagingPath);
                                        continue;
                                    }
                                    if (!targetFs.exists(hfileStagingPath)) continue;
                                    LOG.debug("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath);
                                }
                                catch (Exception ex) {
                                    LOG.debug("Unable to move back file " + hfileOrigPath + " from " + hfileStagingPath, (Throwable)ex);
                                }
                            }
                        }
                    }
                }
            }
        };
    }

    private boolean checkHFilesCountPerRegionPerFamily(Multimap<ByteBuffer, LoadQueueItem> regionGroups) {
        for (Map.Entry e : regionGroups.asMap().entrySet()) {
            TreeMap<byte[], MutableInt> filesMap = new TreeMap<byte[], MutableInt>(Bytes.BYTES_COMPARATOR);
            for (LoadQueueItem lqi : (Collection)e.getValue()) {
                MutableInt count = filesMap.computeIfAbsent(lqi.getFamily(), k -> new MutableInt());
                count.increment();
                if (count.intValue() <= this.maxFilesPerRegionPerFamily) continue;
                LOG.error("Trying to load more than " + this.maxFilesPerRegionPerFamily + " hfiles to family " + Bytes.toStringBinary((byte[])lqi.getFamily()) + " of region with start key " + Bytes.toStringBinary((ByteBuffer)((ByteBuffer)e.getKey())));
                return false;
            }
        }
        return true;
    }

    private Pair<Multimap<ByteBuffer, LoadQueueItem>, Set<String>> groupOrSplitPhase(final Table table, ExecutorService pool, Deque<LoadQueueItem> queue, final Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        HashMultimap rgs = HashMultimap.create();
        final Multimap regionGroups = Multimaps.synchronizedMultimap((Multimap)rgs);
        HashSet<Object> missingHFiles = new HashSet<Object>();
        Pair pair = new Pair((Object)regionGroups, missingHFiles);
        HashSet<Future<Pair<List<LoadQueueItem>, String>>> splittingFutures = new HashSet<Future<Pair<List<LoadQueueItem>, String>>>();
        while (!queue.isEmpty()) {
            final LoadQueueItem item = queue.remove();
            Callable<Pair<List<LoadQueueItem>, String>> callable = new Callable<Pair<List<LoadQueueItem>, String>>(){

                @Override
                public Pair<List<LoadQueueItem>, String> call() throws Exception {
                    Pair<List<LoadQueueItem>, String> splits = LoadIncrementalHFiles.this.groupOrSplit((Multimap<ByteBuffer, LoadQueueItem>)regionGroups, item, table, (Pair<byte[][], byte[][]>)startEndKeys);
                    return splits;
                }
            };
            splittingFutures.add(pool.submit(callable));
        }
        for (Future future : splittingFutures) {
            try {
                Pair splits = (Pair)future.get();
                if (splits == null) continue;
                if (splits.getFirst() != null) {
                    queue.addAll((Collection)splits.getFirst());
                    continue;
                }
                missingHFiles.add(splits.getSecond());
            }
            catch (ExecutionException e1) {
                Throwable t = e1.getCause();
                if (t instanceof IOException) {
                    LOG.error("IOException during splitting", (Throwable)e1);
                    throw (IOException)t;
                }
                LOG.error("Unexpected execution exception during splitting", (Throwable)e1);
                throw new IllegalStateException(t);
            }
            catch (InterruptedException e1) {
                LOG.error("Unexpected interrupted exception during splitting", (Throwable)e1);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e1);
            }
        }
        return pair;
    }

    private List<LoadQueueItem> splitStoreFile(LoadQueueItem item, Table table, byte[] startKey, byte[] splitKey) throws IOException {
        Path hfilePath = item.getFilePath();
        byte[] family = item.getFamily();
        Path tmpDir = hfilePath.getParent();
        if (!tmpDir.getName().equals(TMP_DIR)) {
            tmpDir = new Path(tmpDir, TMP_DIR);
        }
        LOG.info("HFile at " + hfilePath + " no longer fits inside a single region. Splitting...");
        String uniqueName = this.getUniqueName();
        ColumnFamilyDescriptor familyDesc = table.getDescriptor().getColumnFamily(family);
        Path botOut = new Path(tmpDir, uniqueName + ".bottom");
        Path topOut = new Path(tmpDir, uniqueName + ".top");
        LoadIncrementalHFiles.splitStoreFile(this.getConf(), hfilePath, familyDesc, splitKey, botOut, topOut);
        FileSystem fs = tmpDir.getFileSystem(this.getConf());
        fs.setPermission(tmpDir, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(botOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        fs.setPermission(topOut, FsPermission.valueOf((String)"-rwxrwxrwx"));
        ArrayList<LoadQueueItem> lqis = new ArrayList<LoadQueueItem>(2);
        lqis.add(new LoadQueueItem(family, botOut));
        lqis.add(new LoadQueueItem(family, topOut));
        try {
            if (tmpDir.getName().equals(TMP_DIR)) {
                fs.delete(hfilePath, false);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to delete temporary split file " + hfilePath);
        }
        LOG.info("Successfully split into new HFiles " + botOut + " and " + topOut);
        return lqis;
    }

    @VisibleForTesting
    protected Pair<List<LoadQueueItem>, String> groupOrSplit(Multimap<ByteBuffer, LoadQueueItem> regionGroups, LoadQueueItem item, Table table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
        boolean lastKeyInRange;
        int indexForCallable;
        Optional<byte[]> last;
        Optional<byte[]> first;
        Path hfilePath = item.getFilePath();
        try (HFile.Reader hfr = HFile.createReader(hfilePath.getFileSystem(this.getConf()), hfilePath, new CacheConfig(this.getConf()), true, this.getConf());){
            hfr.loadFileInfo();
            first = hfr.getFirstRowKey();
            last = hfr.getLastRowKey();
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug("encountered", (Throwable)fnfe);
            return new Pair(null, (Object)hfilePath.getName());
        }
        LOG.info("Trying to load hfile=" + hfilePath + " first=" + first.map(Bytes::toStringBinary) + " last=" + last.map(Bytes::toStringBinary));
        if (!first.isPresent() || !last.isPresent()) {
            assert (!first.isPresent() && !last.isPresent());
            LOG.info("hfile " + hfilePath + " has no entries, skipping");
            return null;
        }
        if (Bytes.compareTo((byte[])first.get(), (byte[])last.get()) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])first.get()) + " > " + Bytes.toStringBinary((byte[])last.get()));
        }
        int idx = Arrays.binarySearch((Object[])startEndKeys.getFirst(), first.get(), Bytes.BYTES_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1) - 1;
        }
        if ((indexForCallable = idx) < 0) {
            throw new IOException("The first region info for table " + table.getName() + " can't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable == ((byte[][])startEndKeys.getFirst()).length - 1 && !Bytes.equals((byte[])((byte[][])startEndKeys.getSecond())[indexForCallable], (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IOException("The last region info for table " + table.getName() + " can't be found in hbase:meta.Please use hbck tool to fix it first.");
        }
        if (indexForCallable + 1 < ((byte[][])startEndKeys.getFirst()).length && Bytes.compareTo((byte[])((byte[][])startEndKeys.getSecond())[indexForCallable], (byte[])((byte[][])startEndKeys.getFirst())[indexForCallable + 1]) != 0) {
            throw new IOException("The endkey of one region for table " + table.getName() + " is not equal to the startkey of the next region in hbase:meta.Please use hbck tool to fix it first.");
        }
        boolean bl = lastKeyInRange = Bytes.compareTo((byte[])last.get(), (byte[])((byte[][])startEndKeys.getSecond())[idx]) < 0 || Bytes.equals((byte[])((byte[][])startEndKeys.getSecond())[idx], (byte[])HConstants.EMPTY_BYTE_ARRAY);
        if (!lastKeyInRange) {
            List<LoadQueueItem> lqis = this.splitStoreFile(item, table, ((byte[][])startEndKeys.getFirst())[indexForCallable], ((byte[][])startEndKeys.getSecond())[indexForCallable]);
            return new Pair(lqis, null);
        }
        regionGroups.put((Object)ByteBuffer.wrap(((byte[][])startEndKeys.getFirst())[idx]), (Object)item);
        return null;
    }

    @VisibleForTesting
    protected List<LoadQueueItem> tryAtomicRegionLoad(ClientServiceCallable<byte[]> serviceCallable, TableName tableName, byte[] first, Collection<LoadQueueItem> lqis) throws IOException {
        ArrayList<LoadQueueItem> toRetry = new ArrayList<LoadQueueItem>();
        try {
            Configuration conf = this.getConf();
            byte[] region = (byte[])RpcRetryingCallerFactory.instantiate((Configuration)conf, null).newCaller().callWithRetries(serviceCallable, Integer.MAX_VALUE);
            if (region == null) {
                LOG.warn("Attempt to bulk load region containing " + Bytes.toStringBinary((byte[])first) + " into table " + tableName + " with files " + lqis + " failed.  This is recoverable and they will be retried.");
                toRetry.addAll(lqis);
            }
            return toRetry;
        }
        catch (IOException e) {
            LOG.error("Encountered unrecoverable error from region server, additional details: " + serviceCallable.getExceptionMessageAdditionalDetail(), (Throwable)e);
            LOG.warn("Received a " + e.getClass().getSimpleName() + " from region server: " + serviceCallable.getExceptionMessageAdditionalDetail(), (Throwable)e);
            if (this.getConf().getBoolean(RETRY_ON_IO_EXCEPTION, false) && this.numRetries.get() < this.getConf().getInt("hbase.client.retries.number", 15)) {
                LOG.warn("Will attempt to retry loading failed HFiles. Retry #" + this.numRetries.incrementAndGet());
                toRetry.addAll(lqis);
                return toRetry;
            }
            LOG.error("hbase.bulkload.retries.retryOnIOException is disabled. Unable to recover");
            throw e;
        }
    }

    private void createTable(TableName tableName, String dirPath, Admin admin) throws IOException {
        Path hfofDir = new Path(dirPath);
        final FileSystem fs = hfofDir.getFileSystem(this.getConf());
        final ArrayList familyBuilders = new ArrayList();
        final TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        LoadIncrementalHFiles.visitBulkHFiles(fs, hfofDir, new BulkHFileVisitor<ColumnFamilyDescriptorBuilder>(){

            @Override
            public ColumnFamilyDescriptorBuilder bulkFamily(byte[] familyName) {
                ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyName);
                familyBuilders.add(builder);
                return builder;
            }

            @Override
            public void bulkHFile(ColumnFamilyDescriptorBuilder builder, FileStatus hfileStatus) throws IOException {
                Path hfile = hfileStatus.getPath();
                try (HFile.Reader reader = HFile.createReader(fs, hfile, new CacheConfig(LoadIncrementalHFiles.this.getConf()), true, LoadIncrementalHFiles.this.getConf());){
                    if (builder.getCompressionType() != reader.getFileContext().getCompression()) {
                        builder.setCompressionType(reader.getFileContext().getCompression());
                        LOG.info("Setting compression " + reader.getFileContext().getCompression().name() + " for family " + builder.getNameAsString());
                    }
                    reader.loadFileInfo();
                    byte[] first = reader.getFirstRowKey().get();
                    byte[] last = reader.getLastRowKey().get();
                    LOG.info("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last));
                    Integer value = map.containsKey(first) ? (Integer)map.get(first) : Integer.valueOf(0);
                    map.put(first, value + 1);
                    value = map.containsKey(last) ? (Integer)map.get(last) : Integer.valueOf(0);
                    map.put(last, value - 1);
                }
            }
        });
        byte[][] keys = LoadIncrementalHFiles.inferBoundaries(map);
        TableDescriptorBuilder tdBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        familyBuilders.stream().map(ColumnFamilyDescriptorBuilder::build).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)tdBuilder).setColumnFamily(arg_0));
        admin.createTable(tdBuilder.build(), keys);
        LOG.info("Table " + tableName + " is available!!");
    }

    private void cleanup(Admin admin, Deque<LoadQueueItem> queue, ExecutorService pool, SecureBulkLoadClient secureClient) throws IOException {
        this.fsDelegationToken.releaseDelegationToken();
        if (this.bulkToken != null && secureClient != null) {
            secureClient.cleanupBulkLoad(admin.getConnection(), this.bulkToken);
        }
        if (pool != null) {
            pool.shutdown();
        }
        if (!queue.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("-------------------------------------------------\n");
            err.append("Bulk load aborted with some files not yet loaded:\n");
            err.append("-------------------------------------------------\n");
            for (LoadQueueItem q : queue) {
                err.append("  ").append(q.getFilePath()).append('\n');
            }
            LOG.error(err.toString());
        }
    }

    private String getUniqueName() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private void validateFamiliesInHFiles(Table table, Deque<LoadQueueItem> queue, boolean silence) throws IOException {
        Set familyNames = Arrays.asList(table.getDescriptor().getColumnFamilies()).stream().map(f -> f.getNameAsString()).collect(Collectors.toSet());
        List unmatchedFamilies = queue.stream().map(item -> Bytes.toString((byte[])item.getFamily())).filter(fn -> !familyNames.contains(fn)).distinct().collect(Collectors.toList());
        if (unmatchedFamilies.size() > 0) {
            String msg = "Unmatched family names found: unmatched family names in HFiles to be bulkloaded: " + unmatchedFamilies + "; valid family names of table " + table.getName() + " are: " + familyNames;
            LOG.error(msg);
            if (!silence) {
                throw new IOException(msg);
            }
        }
    }

    private void populateLoadQueue(Deque<LoadQueueItem> ret, Map<byte[], List<Path>> map) {
        map.forEach((k, v) -> v.stream().map(p -> new LoadQueueItem((byte[])k, (Path)p)).forEachOrdered(ret::add));
    }

    private void discoverLoadQueue(final Deque<LoadQueueItem> ret, Path hfofDir, boolean validateHFile) throws IOException {
        LoadIncrementalHFiles.visitBulkHFiles(hfofDir.getFileSystem(this.getConf()), hfofDir, new BulkHFileVisitor<byte[]>(){

            @Override
            public byte[] bulkFamily(byte[] familyName) {
                return familyName;
            }

            @Override
            public void bulkHFile(byte[] family, FileStatus hfile) throws IOException {
                long length = hfile.getLen();
                if (length > LoadIncrementalHFiles.this.getConf().getLong("hbase.hregion.max.filesize", 0x280000000L)) {
                    LOG.warn("Trying to bulk load hfile " + hfile.getPath() + " with size: " + length + " bytes can be problematic as it may lead to oversplitting.");
                }
                ret.add(new LoadQueueItem(family, hfile.getPath()));
            }
        }, validateHFile);
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor) throws IOException {
        LoadIncrementalHFiles.visitBulkHFiles(fs, bulkDir, visitor, true);
    }

    private static <TFamily> void visitBulkHFiles(FileSystem fs, Path bulkDir, BulkHFileVisitor<TFamily> visitor, boolean validateHFile) throws IOException {
        FileStatus[] familyDirStatuses;
        for (FileStatus familyStat : familyDirStatuses = fs.listStatus(bulkDir)) {
            FileStatus[] hfileStatuses;
            if (!familyStat.isDirectory()) {
                LOG.warn("Skipping non-directory " + familyStat.getPath());
                continue;
            }
            Path familyDir = familyStat.getPath();
            byte[] familyName = Bytes.toBytes((String)familyDir.getName());
            try {
                ColumnFamilyDescriptorBuilder.isLegalColumnFamilyName((byte[])familyName);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Skipping invalid " + familyStat.getPath());
                continue;
            }
            TFamily family = visitor.bulkFamily(familyName);
            for (FileStatus hfileStatus : hfileStatuses = fs.listStatus(familyDir)) {
                block12: {
                    if (!fs.isFile(hfileStatus.getPath())) {
                        LOG.warn("Skipping non-file " + hfileStatus);
                        continue;
                    }
                    Path hfile = hfileStatus.getPath();
                    String fileName = hfile.getName();
                    if (fileName.startsWith("_")) continue;
                    if (StoreFileInfo.isReference(fileName)) {
                        LOG.warn("Skipping reference " + fileName);
                        continue;
                    }
                    if (HFileLink.isHFileLink(fileName)) {
                        LOG.warn("Skipping HFileLink " + fileName);
                        continue;
                    }
                    if (validateHFile) {
                        try {
                            if (!HFile.isHFileFormat(fs, hfile)) {
                                LOG.warn("the file " + hfile + " doesn't seems to be an hfile. skipping");
                            }
                            break block12;
                        }
                        catch (FileNotFoundException e) {
                            LOG.warn("the file " + hfile + " was removed");
                        }
                        continue;
                    }
                }
                visitor.bulkHFile(family, hfileStatus);
            }
        }
    }

    private ExecutorService createExecutorService() {
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.nrThreads, this.nrThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("LoadIncrementalHFiles-%1$d").build());
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private final String toString(List<Pair<byte[], String>> list) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        list.forEach(p -> sb.append('{').append(Bytes.toStringBinary((byte[])((byte[])p.getFirst()))).append(',').append((String)p.getSecond()).append('}'));
        sb.append(']');
        return sb.toString();
    }

    private boolean isSecureBulkLoadEndpointAvailable() {
        String classes = this.getConf().get("hbase.coprocessor.region.classes", "");
        return classes.contains("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
    }

    @VisibleForTesting
    static void splitStoreFile(Configuration conf, Path inFile, ColumnFamilyDescriptor familyDesc, byte[] splitKey, Path bottomOut, Path topOut) throws IOException {
        Reference topReference = Reference.createTopReference(splitKey);
        Reference bottomReference = Reference.createBottomReference(splitKey);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, topOut, topReference, familyDesc);
        LoadIncrementalHFiles.copyHFileHalf(conf, inFile, bottomOut, bottomReference, familyDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyHFileHalf(Configuration conf, Path inFile, Path outFile, Reference reference, ColumnFamilyDescriptor familyDescriptor) throws IOException {
        FileSystem fs = inFile.getFileSystem(conf);
        CacheConfig cacheConf = new CacheConfig(conf);
        StoreFileReader halfReader = null;
        StoreFileWriter halfWriter = null;
        try {
            halfReader = new HalfStoreFileReader(fs, inFile, cacheConf, reference, true, new AtomicInteger(0), true, conf);
            Map<byte[], byte[]> fileInfo = halfReader.loadFileInfo();
            int blocksize = familyDescriptor.getBlocksize();
            Compression.Algorithm compression = familyDescriptor.getCompressionType();
            BloomType bloomFilterType = familyDescriptor.getBloomFilterType();
            HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withChecksumType(HStore.getChecksumType(conf)).withBytesPerCheckSum(HStore.getBytesPerChecksum(conf)).withBlockSize(blocksize).withDataBlockEncoding(familyDescriptor.getDataBlockEncoding()).withIncludesTags(true).build();
            halfWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withFilePath(outFile).withBloomType(bloomFilterType).withFileContext(hFileContext).build();
            HFileScanner scanner = ((HalfStoreFileReader)halfReader).getScanner(false, false, false);
            scanner.seekTo();
            do {
                halfWriter.append(scanner.getCell());
            } while (scanner.next());
            for (Map.Entry<byte[], byte[]> entry : fileInfo.entrySet()) {
                if (!LoadIncrementalHFiles.shouldCopyHFileMetaKey(entry.getKey())) continue;
                halfWriter.appendFileInfo(entry.getKey(), entry.getValue());
            }
        }
        finally {
            if (halfReader != null) {
                try {
                    halfReader.close(cacheConf.shouldEvictOnClose());
                }
                catch (IOException e) {
                    LOG.warn("failed to close hfile reader for " + inFile, (Throwable)e);
                }
            }
            if (halfWriter != null) {
                halfWriter.close();
            }
        }
    }

    private static boolean shouldCopyHFileMetaKey(byte[] key) {
        if (Bytes.equals((byte[])key, (byte[])HFileDataBlockEncoder.DATA_BLOCK_ENCODING)) {
            return false;
        }
        return !HFile.isReservedFileInfoKey(key);
    }

    private boolean isCreateTable() {
        return "yes".equalsIgnoreCase(this.getConf().get(CREATE_TABLE_CONF_KEY, "yes"));
    }

    private boolean isSilence() {
        return "yes".equalsIgnoreCase(this.getConf().get(IGNORE_UNMATCHED_CF_CONF_KEY, ""));
    }

    private boolean isAlwaysCopyFiles() {
        return this.getConf().getBoolean(ALWAYS_COPY_FILES, false);
    }

    /*
     * Exception decompiling
     */
    public Map<LoadQueueItem, ByteBuffer> run(String hfofDir, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<LoadQueueItem, ByteBuffer> run(Map<byte[], List<Path>> family2Files, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            this.usage();
            return -1;
        }
        String dirPath = args[0];
        TableName tableName = TableName.valueOf((String)args[1]);
        if (args.length == 2) {
            return !this.run(dirPath, tableName).isEmpty() ? 0 : -1;
        }
        HashMap family2Files = Maps.newHashMap();
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        for (FileStatus regionDir : fs.listStatus(new Path(dirPath))) {
            FSVisitor.visitRegionStoreFiles(fs, regionDir.getPath(), (region, family, hfileName) -> {
                Path path = new Path(regionDir.getPath(), new Path(family, hfileName));
                byte[] familyName = Bytes.toBytes((String)family);
                if (family2Files.containsKey(familyName)) {
                    ((List)family2Files.get(familyName)).add(path);
                } else {
                    family2Files.put(familyName, Lists.newArrayList((Object[])new Path[]{path}));
                }
            });
        }
        return !this.run(family2Files, tableName).isEmpty() ? 0 : -1;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new LoadIncrementalHFiles(conf), (String[])args);
        System.exit(ret);
    }

    public void setBulkToken(String stagingDir) {
        this.bulkToken = stagingDir;
    }

    public static byte[][] inferBoundaries(SortedMap<byte[], Integer> bdryMap) {
        ArrayList<byte[]> keysArray = new ArrayList<byte[]>();
        int runningValue = 0;
        byte[] currStartKey = null;
        boolean firstBoundary = true;
        for (Map.Entry<byte[], Integer> item : bdryMap.entrySet()) {
            if (runningValue == 0) {
                currStartKey = item.getKey();
            }
            if ((runningValue += item.getValue().intValue()) != 0) continue;
            if (!firstBoundary) {
                keysArray.add(currStartKey);
            }
            firstBoundary = false;
        }
        return (byte[][])keysArray.toArray((T[])new byte[0][]);
    }

    private static interface BulkHFileVisitor<TFamily> {
        public TFamily bulkFamily(byte[] var1) throws IOException;

        public void bulkHFile(TFamily var1, FileStatus var2) throws IOException;
    }

    @InterfaceAudience.Public
    public static class LoadQueueItem {
        private final byte[] family;
        private final Path hfilePath;

        public LoadQueueItem(byte[] family, Path hfilePath) {
            this.family = family;
            this.hfilePath = hfilePath;
        }

        public String toString() {
            return "family:" + Bytes.toString((byte[])this.family) + " path:" + this.hfilePath.toString();
        }

        public byte[] getFamily() {
            return this.family;
        }

        public Path getFilePath() {
            return this.hfilePath;
        }
    }
}

