/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core.task;

import com.aliyun.openservices.ots.internal.streamclient.core.RecordProcessorCheckpointer;
import com.aliyun.openservices.ots.internal.streamclient.core.ShardSyncer;
import com.aliyun.openservices.ots.internal.streamclient.core.exceptions.ApplicationException;
import com.aliyun.openservices.ots.internal.streamclient.core.task.ITask;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskResult;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskType;
import com.aliyun.openservices.ots.internal.streamclient.model.IRecordProcessor;
import com.aliyun.openservices.ots.internal.streamclient.model.ShardInfo;
import com.aliyun.openservices.ots.internal.streamclient.model.ShutdownInput;
import com.aliyun.openservices.ots.internal.streamclient.model.ShutdownReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTask
implements ITask {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownTask.class);
    private final ShardInfo shardInfo;
    private final IRecordProcessor recordProcessor;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final ShutdownReason shutdownReason;
    private final ShardSyncer shardSyncer;

    public ShutdownTask(ShardInfo shardInfo, IRecordProcessor recordProcessor, RecordProcessorCheckpointer recordProcessorCheckpointer, ShutdownReason shutdownReason, ShardSyncer shardSyncer) {
        this.shardInfo = shardInfo;
        this.recordProcessor = recordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.shutdownReason = shutdownReason;
        this.shardSyncer = shardSyncer;
    }

    @Override
    public TaskResult call() {
        LOG.debug("Start, ShardId: {}, Reason: {}.", (Object)this.shardInfo.getShardId(), (Object)this.shutdownReason);
        try {
            if (this.shutdownReason == ShutdownReason.TERMINATE) {
                this.recordProcessorCheckpointer.setLargestPermittedCheckpointValue("SHARD_END");
            }
            ShutdownInput shutdownInput = new ShutdownInput();
            shutdownInput.setCheckpointer(this.recordProcessorCheckpointer);
            shutdownInput.setShutdownReason(this.shutdownReason);
            try {
                this.recordProcessor.shutdown(shutdownInput);
            }
            catch (ApplicationException e) {
                throw new ApplicationException("ApplicationShutDownError", e);
            }
            LOG.debug("Complete, ShardId: {}.", (Object)this.shardInfo.getShardId());
            if (this.shutdownReason == ShutdownReason.TERMINATE) {
                this.shardSyncer.syncShardAndLeaseInfo(true);
            }
            return new TaskResult(true);
        }
        catch (Exception e) {
            LOG.warn("ShardId: {}, Exception: {}.", (Object)this.shardInfo.getShardId(), (Object)e);
            return new TaskResult(e);
        }
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SHUTDOWN;
    }
}

