/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.aliyun.openservices.ots.internal.streamclient.lease.AbstractLeaseSerializer;
import com.aliyun.openservices.ots.internal.streamclient.lease.ShardLease;
import java.util.HashSet;
import java.util.Set;

public class ShardLeaseSerializer
extends AbstractLeaseSerializer<ShardLease> {
    private static final String CHECKPOINT = "Checkpoint";
    private static final String PARENT_SHARD_IDS = "ParentShardIds";
    private static final String SEPARATOR = "\n";

    public ShardLeaseSerializer(String statusTableName, String dataTableStreamId) {
        super(statusTableName, dataTableStreamId);
    }

    @Override
    PutRowRequest getPutRowRequest(ShardLease lease) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)lease.getLeaseKey()));
        if (!lease.getStreamId().equals(this.dataTableStreamId)) {
            throw new IllegalArgumentException("The streamId mismatch.");
        }
        RowPutChange change = new RowPutChange(this.statusTableName, pk);
        change.addColumn("LeaseCounter", ColumnValue.fromLong((long)lease.getLeaseCounter()));
        change.addColumn("LeaseOwner", ColumnValue.fromString((String)lease.getLeaseOwner()));
        change.addColumn("LeaseStealer", ColumnValue.fromString((String)lease.getLeaseStealer()));
        change.addColumn(CHECKPOINT, ColumnValue.fromString((String)lease.getCheckpoint()));
        String parentShardIds = this.serializeParentShardIds(lease.getParentShardIds());
        change.addColumn(PARENT_SHARD_IDS, ColumnValue.fromString((String)parentShardIds));
        PutRowRequest request = new PutRowRequest();
        request.setRowChange(change);
        return request;
    }

    @Override
    UpdateRowRequest getUpdateRowRequestForUpdate(ShardLease lease) {
        PrimaryKey pk = this.getPrimaryKey(PrimaryKeyValue.fromString((String)lease.getLeaseKey()));
        RowUpdateChange change = new RowUpdateChange(this.statusTableName, pk);
        change.put("LeaseCounter", ColumnValue.fromLong((long)(lease.getLeaseCounter() + 1L)));
        change.put(CHECKPOINT, ColumnValue.fromString((String)lease.getCheckpoint()));
        change.setCondition(this.getCounterCheckCondition(lease.getLeaseCounter()));
        UpdateRowRequest request = new UpdateRowRequest(change);
        request.setRowChange(change);
        return request;
    }

    @Override
    ShardLease fromOTSRow(Row row) {
        if (row.getColumns().length < 5) {
            return null;
        }
        String streamId = row.getPrimaryKey().getPrimaryKeyColumn(0).getValue().asString();
        String leaseKey = row.getPrimaryKey().getPrimaryKeyColumn(2).getValue().asString();
        ShardLease result = new ShardLease(leaseKey);
        result.setStreamId(streamId);
        result.setLeaseOwner(((Column)row.getColumn("LeaseOwner").get(0)).getValue().asString());
        result.setLeaseCounter(((Column)row.getColumn("LeaseCounter").get(0)).getValue().asLong());
        result.setLeaseStealer(((Column)row.getColumn("LeaseStealer").get(0)).getValue().asString());
        result.setCheckpoint(((Column)row.getColumn(CHECKPOINT).get(0)).getValue().asString());
        String parentShardIds = ((Column)row.getColumn(PARENT_SHARD_IDS).get(0)).getValue().asString();
        result.setParentShardIds(this.deserializeParentShardIds(parentShardIds));
        return result;
    }

    private String serializeParentShardIds(Set<String> parentShardIds) {
        StringBuilder builder = new StringBuilder();
        for (String parentShardId : parentShardIds) {
            builder.append(parentShardId);
            builder.append(SEPARATOR);
        }
        return builder.toString();
    }

    private Set<String> deserializeParentShardIds(String parentShardIds) {
        HashSet<String> parentShardsList = new HashSet<String>();
        for (String parentShardId : parentShardIds.split(SEPARATOR)) {
            if (parentShardId.isEmpty()) continue;
            parentShardsList.add(parentShardId);
        }
        return parentShardsList;
    }
}

