/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteChangeSetRequestMarshaller
implements Marshaller<Request<DeleteChangeSetRequest>, DeleteChangeSetRequest> {
    public Request<DeleteChangeSetRequest> marshall(DeleteChangeSetRequest deleteChangeSetRequest) {
        if (deleteChangeSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteChangeSetRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DeleteChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteChangeSetRequest.getChangeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)deleteChangeSetRequest.getChangeSetName()));
        }
        if (deleteChangeSetRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)deleteChangeSetRequest.getStackName()));
        }
        return request;
    }
}

