/*
 * Copyright 2011-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not
 * use this file except in compliance with the License. A copy of the License is
 * located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

/**
 * <fullname>AWS CodeCommit</fullname>
 * <p>
 * This is the <i>AWS CodeCommit API Reference</i>. This reference provides
 * descriptions of the operations and data types for AWS CodeCommit API.
 * </p>
 * <p>
 * You can use the AWS CodeCommit API to work with the following objects:
 * </p>
 * <ul>
 * <li>Repositories, by calling the following:
 * <ul>
 * <li><a>BatchGetRepositories</a>, which returns information about one or more
 * repositories associated with your AWS account</li>
 * <li><a>CreateRepository</a>, which creates an AWS CodeCommit repository</li>
 * <li><a>DeleteRepository</a>, which deletes an AWS CodeCommit repository</li>
 * <li><a>GetRepository</a>, which returns information about a specified
 * repository</li>
 * <li><a>ListRepositories</a>, which lists all AWS CodeCommit repositories
 * associated with your AWS account</li>
 * <li><a>UpdateRepositoryDescription</a>, which sets or updates the description
 * of the repository</li>
 * <li><a>UpdateRepositoryName</a>, which changes the name of the repository. If
 * you change the name of a repository, no other users of that repository will
 * be able to access it until you send them the new HTTPS or SSH URL to use.</li>
 * </ul>
 * </li>
 * <li>Branches, by calling the following:
 * <ul>
 * <li><a>CreateBranch</a>, which creates a new branch in a specified repository
 * </li>
 * <li><a>GetBranch</a>, which returns information about a specified branch</li>
 * <li><a>ListBranches</a>, which lists all branches for a specified repository</li>
 * <li><a>UpdateDefaultBranch</a>, which changes the default branch for a
 * repository</li>
 * </ul>
 * </li>
 * <li>Information about committed code in a repository, by calling the
 * following:
 * <ul>
 * <li><a>GetCommit</a>, which returns information about a commit, including
 * commit messages and committer information.</li>
 * </ul>
 * </li>
 * <li>Triggers, by calling the following:
 * <ul>
 * <li><a>GetRepositoryTriggers</a>, which returns information about triggers
 * configured for a repository</li>
 * <li><a>PutRepositoryTriggers</a>, which replaces all triggers for a
 * repository and can be used to create or delete triggers</li>
 * <li><a>TestRepositoryTriggers</a>, which tests the functionality of a
 * repository trigger by sending data to the trigger target</li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * For information about how to use AWS CodeCommit, see the <a
 * href="http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html"
 * >AWS CodeCommit User Guide</a>.
 * </p>
 */
package com.amazonaws.services.codecommit;

