/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.AuthenticationResultType;
import com.amazonaws.services.cognitoidp.model.transform.NewDeviceMetadataTypeJsonMarshaller;

public class AuthenticationResultTypeJsonMarshaller {
    private static AuthenticationResultTypeJsonMarshaller instance;

    public void marshall(AuthenticationResultType authenticationResultType, StructuredJsonGenerator jsonGenerator) {
        if (authenticationResultType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (authenticationResultType.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(authenticationResultType.getAccessToken());
            }
            if (authenticationResultType.getExpiresIn() != null) {
                jsonGenerator.writeFieldName("ExpiresIn").writeValue(authenticationResultType.getExpiresIn().intValue());
            }
            if (authenticationResultType.getTokenType() != null) {
                jsonGenerator.writeFieldName("TokenType").writeValue(authenticationResultType.getTokenType());
            }
            if (authenticationResultType.getRefreshToken() != null) {
                jsonGenerator.writeFieldName("RefreshToken").writeValue(authenticationResultType.getRefreshToken());
            }
            if (authenticationResultType.getIdToken() != null) {
                jsonGenerator.writeFieldName("IdToken").writeValue(authenticationResultType.getIdToken());
            }
            if (authenticationResultType.getNewDeviceMetadata() != null) {
                jsonGenerator.writeFieldName("NewDeviceMetadata");
                NewDeviceMetadataTypeJsonMarshaller.getInstance().marshall(authenticationResultType.getNewDeviceMetadata(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AuthenticationResultTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AuthenticationResultTypeJsonMarshaller();
        }
        return instance;
    }
}

