/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.util.StringUtils;
import java.util.concurrent.Semaphore;

public class ProfileCredentialsProvider
implements AWSCredentialsProvider {
    private static final long REFRESH_INTERVAL_NANOS = 300000000000L;
    private static final long FORCE_RELOAD_INTERVAL_NANOS = 600000000000L;
    private volatile ProfilesConfigFile profilesConfigFile;
    private volatile long lastRefreshed;
    private final String profileName;
    private final Semaphore refreshSemaphore = new Semaphore(1);

    public ProfileCredentialsProvider() {
        this(null);
    }

    public ProfileCredentialsProvider(String profileName) {
        this((ProfilesConfigFile)null, profileName);
    }

    public ProfileCredentialsProvider(String profilesConfigFilePath, String profileName) {
        this(new ProfilesConfigFile(profilesConfigFilePath), profileName);
    }

    public ProfileCredentialsProvider(ProfilesConfigFile profilesConfigFile, String profileName) {
        this.profilesConfigFile = profilesConfigFile;
        if (this.profilesConfigFile != null) {
            this.lastRefreshed = System.nanoTime();
        }
        if (profileName == null) {
            String profileEnvVarOverride = System.getenv("AWS_PROFILE");
            if (!StringUtils.isNullOrEmpty(profileEnvVarOverride = StringUtils.trim(profileEnvVarOverride))) {
                this.profileName = profileEnvVarOverride;
            } else {
                String profileSysPropOverride = System.getProperty("aws.profile");
                this.profileName = !StringUtils.isNullOrEmpty(profileSysPropOverride = StringUtils.trim(profileSysPropOverride)) ? profileSysPropOverride : "default";
            }
        } else {
            this.profileName = profileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSCredentials getCredentials() {
        long now;
        long age;
        if (this.profilesConfigFile == null) {
            ProfileCredentialsProvider profileCredentialsProvider = this;
            synchronized (profileCredentialsProvider) {
                if (this.profilesConfigFile == null) {
                    this.profilesConfigFile = new ProfilesConfigFile();
                    this.lastRefreshed = System.nanoTime();
                }
            }
        }
        if ((age = (now = System.nanoTime()) - this.lastRefreshed) > 600000000000L) {
            this.refresh();
        } else if (age > 300000000000L && this.refreshSemaphore.tryAcquire()) {
            try {
                this.refresh();
            }
            finally {
                this.refreshSemaphore.release();
            }
        }
        return this.profilesConfigFile.getCredentials(this.profileName);
    }

    @Override
    public void refresh() {
        this.profilesConfigFile.refresh();
        this.lastRefreshed = System.nanoTime();
    }
}

