/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.SymbolFileProvider;
import com.android.builder.model.AaptOptions;
import com.android.resources.Density;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AaptPackageCommandBuilder {
    @NonNull
    private final File mManifestFile;
    @NonNull
    private final AaptOptions mOptions;
    @Nullable
    private File mResFolder;
    @Nullable
    private File mAssetsFolder;
    private boolean mVerboseExec = false;
    @Nullable
    private String mSourceOutputDir;
    @Nullable
    private String mSymbolOutputDir;
    @Nullable
    private List<? extends SymbolFileProvider> mLibraries;
    @Nullable
    private String mResPackageOutput;
    @Nullable
    private String mProguardOutput;
    @Nullable
    private VariantConfiguration.Type mType;
    private boolean mDebuggable = false;
    private boolean mPseudoLocalesEnabled = false;
    @Nullable
    private Collection<String> mResourceConfigs;
    @Nullable
    Collection<String> mSplits;
    @Nullable
    String mPackageForR;
    @Nullable
    String mPreferredDensity;

    public AaptPackageCommandBuilder(@NonNull File manifestFile, @NonNull AaptOptions options) {
        Preconditions.checkNotNull((Object)manifestFile, (Object)"manifestFile cannot be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options cannot be null.");
        this.mManifestFile = manifestFile;
        this.mOptions = options;
    }

    public File getManifestFile() {
        return this.mManifestFile;
    }

    public AaptPackageCommandBuilder setResFolder(@NonNull File resFolder) {
        if (!resFolder.isDirectory()) {
            throw new RuntimeException("resFolder parameter is not a directory");
        }
        this.mResFolder = resFolder;
        return this;
    }

    public AaptPackageCommandBuilder setAssetsFolder(@NonNull File assetsFolder) {
        if (!assetsFolder.isDirectory()) {
            throw new RuntimeException("assetsFolder parameter is not a directory");
        }
        this.mAssetsFolder = assetsFolder;
        return this;
    }

    public AaptPackageCommandBuilder setSourceOutputDir(@Nullable String sourceOutputDir) {
        this.mSourceOutputDir = sourceOutputDir;
        return this;
    }

    @Nullable
    public String getSourceOutputDir() {
        return this.mSourceOutputDir;
    }

    public AaptPackageCommandBuilder setSymbolOutputDir(@Nullable String symbolOutputDir) {
        this.mSymbolOutputDir = symbolOutputDir;
        return this;
    }

    @Nullable
    public String getSymbolOutputDir() {
        return this.mSymbolOutputDir;
    }

    public AaptPackageCommandBuilder setLibraries(@NonNull List<? extends SymbolFileProvider> libraries) {
        this.mLibraries = libraries;
        return this;
    }

    @NonNull
    public List<? extends SymbolFileProvider> getLibraries() {
        return this.mLibraries == null ? ImmutableList.of() : this.mLibraries;
    }

    public AaptPackageCommandBuilder setResPackageOutput(@Nullable String resPackageOutput) {
        this.mResPackageOutput = resPackageOutput;
        return this;
    }

    public AaptPackageCommandBuilder setProguardOutput(@Nullable String proguardOutput) {
        this.mProguardOutput = proguardOutput;
        return this;
    }

    public AaptPackageCommandBuilder setType(@NonNull VariantConfiguration.Type type) {
        this.mType = type;
        return this;
    }

    @Nullable
    public VariantConfiguration.Type getType() {
        return this.mType;
    }

    public AaptPackageCommandBuilder setDebuggable(boolean debuggable) {
        this.mDebuggable = debuggable;
        return this;
    }

    public AaptPackageCommandBuilder setResourceConfigs(@NonNull Collection<String> resourceConfigs) {
        this.mResourceConfigs = resourceConfigs;
        return this;
    }

    public AaptPackageCommandBuilder setSplits(@NonNull Collection<String> splits) {
        this.mSplits = splits;
        return this;
    }

    public AaptPackageCommandBuilder setVerbose() {
        this.mVerboseExec = true;
        return this;
    }

    public AaptPackageCommandBuilder setPackageForR(@NonNull String packageForR) {
        this.mPackageForR = packageForR;
        return this;
    }

    public AaptPackageCommandBuilder setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.mPseudoLocalesEnabled = pseudoLocalesEnabled;
        return this;
    }

    public AaptPackageCommandBuilder setPreferredDensity(String density) {
        this.mPreferredDensity = density;
        return this;
    }

    @Nullable
    String getPackageForR() {
        return this.mPackageForR;
    }

    public List<String> build(@NonNull BuildToolInfo buildToolInfo, @NonNull IAndroidTarget target, @NonNull ILogger logger) {
        String ignoreAssets;
        Preconditions.checkArgument((this.mSourceOutputDir != null || this.mResPackageOutput != null ? 1 : 0) != 0, (Object)"No output provided for aapt task");
        if (this.mSymbolOutputDir != null || this.mSourceOutputDir != null) {
            Preconditions.checkNotNull(this.mLibraries, (Object)"libraries cannot be null if symbolOutputDir or sourceOutputDir is non-null");
        }
        this.checkResConfigsVersusSplitSettings(logger);
        ArrayList command = Lists.newArrayList();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        command.add(aapt);
        command.add("package");
        if (this.mVerboseExec) {
            command.add("-v");
        }
        command.add("-f");
        command.add("--no-crunch");
        command.add("-I");
        command.add(target.getPath(1));
        command.add("-M");
        command.add(this.mManifestFile.getAbsolutePath());
        if (this.mResFolder != null) {
            command.add("-S");
            command.add(this.mResFolder.getAbsolutePath());
        }
        if (this.mAssetsFolder != null) {
            command.add("-A");
            command.add(this.mAssetsFolder.getAbsolutePath());
        }
        if (this.mSourceOutputDir != null) {
            command.add("-m");
            command.add("-J");
            command.add(this.mSourceOutputDir);
        }
        if (this.mResPackageOutput != null) {
            command.add("-F");
            command.add(this.mResPackageOutput);
        }
        if (this.mProguardOutput != null) {
            command.add("-G");
            command.add(this.mProguardOutput);
        }
        if (this.mSplits != null) {
            for (String split : this.mSplits) {
                command.add("--split");
                command.add(split);
            }
        }
        if (this.mDebuggable) {
            command.add("--debug-mode");
        }
        if (this.mType != VariantConfiguration.Type.TEST && this.mPackageForR != null) {
            command.add("--custom-package");
            command.add(this.mPackageForR);
            logger.verbose("Custom package for R class: '%s'", new Object[]{this.mPackageForR});
        }
        if (this.mPseudoLocalesEnabled) {
            if (buildToolInfo.getRevision().getMajor() >= 21) {
                command.add("--pseudo-localize");
            } else {
                throw new RuntimeException("Pseudolocalization is only available since Build Tools version 21.0.0, please upgrade or turn it off.");
            }
        }
        if (this.mType == VariantConfiguration.Type.LIBRARY) {
            command.add("--non-constant-id");
        }
        if ((ignoreAssets = this.mOptions.getIgnoreAssets()) != null) {
            command.add("--ignore-assets");
            command.add(ignoreAssets);
        }
        if (this.mOptions.getFailOnMissingConfigEntry()) {
            if (buildToolInfo.getRevision().getMajor() > 20) {
                command.add("--error-on-missing-config-entry");
            } else {
                throw new IllegalStateException("aaptOptions:failOnMissingConfigEntry cannot be used with SDK Build Tools revision earlier than 21.0.0");
            }
        }
        command.add("-0");
        command.add("apk");
        Collection noCompressList = this.mOptions.getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                command.add("-0");
                command.add(noCompress);
            }
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>();
        if (!AaptPackageCommandBuilder.isNullOrEmpty(this.mResourceConfigs)) {
            resourceConfigs.addAll(this.mResourceConfigs);
        }
        if (buildToolInfo.getRevision().getMajor() < 21 && this.mPreferredDensity != null) {
            resourceConfigs.add(this.mPreferredDensity);
            resourceConfigs.add(Density.NODPI.getResourceValue());
        }
        if (!resourceConfigs.isEmpty()) {
            command.add("-c");
            Joiner joiner = Joiner.on((char)',');
            command.add(joiner.join(resourceConfigs));
        }
        if (buildToolInfo.getRevision().getMajor() >= 21 && this.mPreferredDensity != null) {
            Collection<String> densityResConfig;
            if (!AaptPackageCommandBuilder.isNullOrEmpty(this.mResourceConfigs) && !(densityResConfig = AaptPackageCommandBuilder.getDensityResConfigs(this.mResourceConfigs)).isEmpty()) {
                throw new RuntimeException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join(densityResConfig)));
            }
            command.add("--preferred-density");
            command.add(this.mPreferredDensity);
        }
        if (buildToolInfo.getRevision().getMajor() < 21 && this.mPreferredDensity != null) {
            logger.warning(String.format("Warning : Project is building density based multiple APKs but using tools version %1$s, you should upgrade to build-tools 21 or above to ensure proper packaging of resources.", buildToolInfo.getRevision().getMajor()), new Object[0]);
        }
        if (!(this.mSymbolOutputDir == null || this.mType != VariantConfiguration.Type.LIBRARY && this.mLibraries.isEmpty())) {
            command.add("--output-text-symbols");
            command.add(this.mSymbolOutputDir);
        }
        return command;
    }

    private void checkResConfigsVersusSplitSettings(ILogger logger) {
        if (AaptPackageCommandBuilder.isNullOrEmpty(this.mResourceConfigs) || AaptPackageCommandBuilder.isNullOrEmpty(this.mSplits)) {
            return;
        }
        Collection<String> resConfigs = AaptPackageCommandBuilder.getDensityResConfigs(this.mResourceConfigs);
        ArrayList<String> splits = new ArrayList<String>(this.mSplits);
        splits.removeAll(resConfigs);
        if (!splits.isEmpty()) {
            throw new RuntimeException(String.format("Splits for densities \"%1$s\" were configured, yet the resConfigs settings does not include such splits. The resulting split APKs would be empty.\nSuggestion : exclude those splits in your build.gradle : \nsplits {\n     density {\n         enable true\n         exclude \"%2$s\"\n     }\n}\nOR add them to the resConfigs list.", Joiner.on((String)",").join(splits), Joiner.on((String)"\",\"").join(splits)));
        }
        resConfigs.removeAll(this.mSplits);
        if (!resConfigs.isEmpty()) {
            throw new RuntimeException(String.format("Inconsistent density configuration, with \"%1$s\" present on resConfig settings, while only \"%2$s\" densities are requested in splits APK density settings.\nSuggestion : remove extra densities from the resConfig : \ndefaultConfig {\n     resConfigs \"%2$s\"\n}\nOR remove such densities from the split's exclude list.\n", Joiner.on((String)",").join(resConfigs), Joiner.on((String)"\",\"").join(this.mSplits)));
        }
    }

    private static boolean isNullOrEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private static Collection<String> getDensityResConfigs(Collection<String> resourceConfigs) {
        return Collections2.filter(new ArrayList<String>(resourceConfigs), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return Density.getEnum((String)input) != null;
            }
        });
    }
}

