/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.core.AaptPackageCommandBuilder;
import com.android.builder.core.ApkInfoParser;
import com.android.builder.core.DexOptions;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.dependency.SymbolFileProvider;
import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.incremental.DependencyData;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.internal.packaging.Packager;
import com.android.builder.model.ClassField;
import com.android.builder.model.PackagingOptions;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.builder.signing.SignedJarBuilder;
import com.android.builder.signing.SigningException;
import com.android.ide.common.internal.AaptCruncher;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidBuilder {
    private static final FullRevision MIN_BUILD_TOOLS_REV = new FullRevision(19, 1, 0);
    private static final FullRevision MIN_MULTIDEX_BUILD_TOOLS_REV = new FullRevision(21, 0, 0);
    private static final FullRevision MIN_BUILD_TOOLS_REVISION_FOR_DEX_INPUT_LIST = new FullRevision(21, 0, 0);
    private static final DependencyFileProcessor sNoOpDependencyFileProcessor = new DependencyFileProcessor(){

        @Override
        public DependencyData processFile(@NonNull File dependencyFile) {
            return null;
        }
    };
    @NonNull
    private final String mProjectId;
    @NonNull
    private final ILogger mLogger;
    @NonNull
    private final CommandLineRunner mCmdLineRunner;
    private final boolean mVerboseExec;
    @Nullable
    private String mCreatedBy;
    private SdkInfo mSdkInfo;
    private TargetInfo mTargetInfo;

    public AndroidBuilder(@NonNull String projectId, @Nullable String createdBy, @NonNull ILogger logger, boolean verboseExec) {
        this.mProjectId = projectId;
        this.mCreatedBy = createdBy;
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
        this.mCmdLineRunner = new CommandLineRunner(this.mLogger);
    }

    AndroidBuilder(@NonNull String projectId, @NonNull CommandLineRunner cmdLineRunner, @NonNull ILogger logger, boolean verboseExec) {
        this.mProjectId = projectId;
        this.mCmdLineRunner = (CommandLineRunner)Preconditions.checkNotNull((Object)cmdLineRunner);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
    }

    public void setTargetInfo(@NonNull SdkInfo sdkInfo, @NonNull TargetInfo targetInfo) {
        this.mSdkInfo = sdkInfo;
        this.mTargetInfo = targetInfo;
        if (this.mTargetInfo.getBuildTools().getRevision().compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Build Tools revision (%1$s) is too low for project '%2$s'. Minimum required is %3$s", this.mTargetInfo.getBuildTools().getRevision(), this.mProjectId, MIN_BUILD_TOOLS_REV));
        }
    }

    @Nullable
    public SdkInfo getSdkInfo() {
        return this.mSdkInfo;
    }

    @Nullable
    public TargetInfo getTargetInfo() {
        return this.mTargetInfo;
    }

    @NonNull
    public ILogger getLogger() {
        return this.mLogger;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTarget() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget();
    }

    public boolean isPreviewTarget() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call isTargetAPreview() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().isPreview();
    }

    public String getTargetCodename() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getTargetCodename() before setTargetInfo() is called.");
        return this.mTargetInfo.getTarget().getVersion().getCodename();
    }

    @NonNull
    public File getDxJar() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getDxJar() before setTargetInfo() is called.");
        return new File(this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.DX_JAR));
    }

    @NonNull
    public List<File> getBootClasspath() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
        ArrayList classpath = Lists.newArrayList();
        IAndroidTarget target = this.mTargetInfo.getTarget();
        for (String p : target.getBootClasspath()) {
            classpath.add(new File(p));
        }
        IAndroidTarget.IOptionalLibrary[] libs = target.getOptionalLibraries();
        if (libs != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                classpath.add(new File(lib.getJarPath()));
            }
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add(this.mSdkInfo.getAnnotationsJar());
        }
        return classpath;
    }

    @NonNull
    public List<String> getBootClasspathAsStrings() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getBootClasspath() before setTargetInfo() is called.");
        ArrayList classpath = Lists.newArrayList();
        IAndroidTarget target = this.mTargetInfo.getTarget();
        classpath.addAll(target.getBootClasspath());
        IAndroidTarget.IOptionalLibrary[] libs = target.getOptionalLibraries();
        if (libs != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                classpath.add(lib.getJarPath());
            }
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add(this.mSdkInfo.getAnnotationsJar().getPath());
        }
        return classpath;
    }

    @Nullable
    public File getRenderScriptSupportJar() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportJar(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    @NonNull
    public Set<File> getCompileClasspath(@NonNull VariantConfiguration<?, ?, ?> variantConfiguration) {
        HashSet compileClasspath = variantConfiguration.getCompileClasspath();
        if (variantConfiguration.getRenderscriptSupportModeEnabled()) {
            File renderScriptSupportJar = this.getRenderScriptSupportJar();
            HashSet fullJars = Sets.newHashSetWithExpectedSize((int)(compileClasspath.size() + 1));
            fullJars.addAll(compileClasspath);
            if (renderScriptSupportJar != null) {
                fullJars.add(renderScriptSupportJar);
            }
            compileClasspath = fullJars;
        }
        return compileClasspath;
    }

    @NonNull
    public Set<File> getPackagedJars(@NonNull VariantConfiguration<?, ?, ?> variantConfiguration) {
        File renderScriptSupportJar;
        HashSet packagedJars = Sets.newHashSet(variantConfiguration.getPackagedJars());
        if (variantConfiguration.getRenderscriptSupportModeEnabled() && (renderScriptSupportJar = this.getRenderScriptSupportJar()) != null) {
            packagedJars.add(renderScriptSupportJar);
        }
        return packagedJars;
    }

    @Nullable
    public File getSupportNativeLibFolder() {
        if (this.mTargetInfo != null) {
            return RenderScriptProcessor.getSupportNativeLibFolder(this.mTargetInfo.getBuildTools().getLocation().getAbsolutePath());
        }
        return null;
    }

    @NonNull
    public PngCruncher getAaptCruncher() {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call getAaptCruncher() before setTargetInfo() is called.");
        return new AaptCruncher(this.mTargetInfo.getBuildTools().getPath(BuildToolInfo.PathId.AAPT), this.mCmdLineRunner);
    }

    @NonNull
    public CommandLineRunner getCommandLineRunner() {
        return this.mCmdLineRunner;
    }

    @NonNull
    public static ClassField createClassField(@NonNull String type, @NonNull String name, @NonNull String value) {
        return new ClassFieldImpl(type, name, value);
    }

    public void mergeManifests(@NonNull File mainManifest, @NonNull List<File> manifestOverlays, @NonNull List<? extends ManifestDependency> libraries, String packageOverride, int versionCode, String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @Nullable Integer maxSdkVersion, @NonNull String outManifestLocation, ManifestMerger2.MergeType mergeType, Map<String, String> placeHolders, @Nullable File reportFile) {
        try {
            ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)mergeType).setPlaceHolderValues(placeHolders).addFlavorAndBuildTypeManifests(manifestOverlays.toArray(new File[manifestOverlays.size()])).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).setMergeReportFile(reportFile);
            if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
                manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
            }
            AndroidBuilder.setInjectableValues(manifestMergerInvoker, packageOverride, versionCode, versionName, minSdkVersion, targetSdkVersion, maxSdkVersion);
            MergingReport mergingReport = manifestMergerInvoker.merge();
            this.mLogger.info("Merging result:" + mergingReport.getResult(), new Object[0]);
            switch (mergingReport.getResult()) {
                case WARNING: {
                    mergingReport.log(this.mLogger);
                }
                case SUCCESS: {
                    XmlDocument xmlDocument = (XmlDocument)mergingReport.getMergedDocument().get();
                    try {
                        String annotatedDocument = mergingReport.getActions().blame(xmlDocument);
                        this.mLogger.verbose(annotatedDocument, new Object[0]);
                    }
                    catch (Exception e) {
                        this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                    }
                    this.save(xmlDocument, new File(outManifestLocation));
                    this.mLogger.info("Merged manifest saved to " + outManifestLocation, new Object[0]);
                    break;
                }
                case ERROR: {
                    mergingReport.log(this.mLogger);
                    throw new RuntimeException(mergingReport.getReportString());
                }
                default: {
                    throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
                }
            }
        }
        catch (ManifestMerger2.MergeFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setInjectableValues(ManifestMerger2.Invoker<?> invoker, String packageOverride, int versionCode, String versionName, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @Nullable Integer maxSdkVersion) {
        if (!Strings.isNullOrEmpty((String)packageOverride)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.PACKAGE, packageOverride);
        }
        if (versionCode > 0) {
            invoker.setOverride(ManifestMerger2.SystemProperty.VERSION_CODE, String.valueOf(versionCode));
        }
        if (!Strings.isNullOrEmpty((String)versionName)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.VERSION_NAME, versionName);
        }
        if (!Strings.isNullOrEmpty((String)minSdkVersion)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.MIN_SDK_VERSION, minSdkVersion);
        }
        if (!Strings.isNullOrEmpty((String)targetSdkVersion)) {
            invoker.setOverride(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
        }
        if (maxSdkVersion != null) {
            invoker.setOverride(ManifestMerger2.SystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
        }
    }

    private void save(XmlDocument xmlDocument, File out) {
        try {
            Files.write((CharSequence)xmlDocument.prettyPrint(), (File)out, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImmutableList<Pair<String, File>> collectLibraries(List<? extends ManifestDependency> libraries) {
        ImmutableList.Builder manifestFiles = ImmutableList.builder();
        if (libraries != null) {
            AndroidBuilder.collectLibraries(libraries, (ImmutableList.Builder<Pair<String, File>>)manifestFiles);
        }
        return manifestFiles.build();
    }

    private static void collectLibraries(List<? extends ManifestDependency> libraries, ImmutableList.Builder<Pair<String, File>> manifestFiles) {
        for (ManifestDependency manifestDependency : libraries) {
            manifestFiles.add((Object)Pair.of((Object)manifestDependency.getName(), (Object)manifestDependency.getManifest()));
            List<? extends ManifestDependency> manifestDependencies = manifestDependency.getManifestDependencies();
            if (manifestDependencies.isEmpty()) continue;
            AndroidBuilder.collectLibraries(manifestDependencies, manifestFiles);
        }
    }

    public void processTestManifest(@NonNull String testApplicationId, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NonNull String testedApplicationId, @NonNull String instrumentationRunner, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest, @Nullable File testManifestFile, @NonNull List<? extends ManifestDependency> libraries, @NonNull File outManifest, @NonNull File tmpDir) {
        Preconditions.checkNotNull((Object)testApplicationId, (Object)"testApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)testedApplicationId, (Object)"testedApplicationId cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull((Object)handleProfiling, (Object)"handleProfiling cannot be null.");
        Preconditions.checkNotNull((Object)functionalTest, (Object)"functionalTest cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifest, (Object)"outManifestLocation cannot be null.");
        try {
            tmpDir.mkdirs();
            File generatedTestManifest = libraries.isEmpty() && testManifestFile == null ? outManifest : File.createTempFile("manifestMerger", ".xml", tmpDir);
            this.mLogger.verbose("Generating in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
            AndroidBuilder.generateTestManifest(testApplicationId, minSdkVersion, targetSdkVersion.equals("-1") ? null : targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest, generatedTestManifest);
            if (testManifestFile != null) {
                File mergedTestManifest = File.createTempFile("manifestMerger", ".xml", tmpDir);
                this.mLogger.verbose("Merging user supplied manifest in %1$s", new Object[]{generatedTestManifest.getAbsolutePath()});
                ManifestMerger2.Invoker invoker = ManifestMerger2.newMerger((File)testManifestFile, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).setOverride(ManifestMerger2.SystemProperty.PACKAGE, testApplicationId).setPlaceHolderValue("instrumentationRunner", instrumentationRunner).addLibraryManifests(new File[]{generatedTestManifest});
                if (minSdkVersion != null) {
                    invoker.setOverride(ManifestMerger2.SystemProperty.MIN_SDK_VERSION, minSdkVersion);
                }
                if (!targetSdkVersion.equals("-1")) {
                    invoker.setOverride(ManifestMerger2.SystemProperty.TARGET_SDK_VERSION, targetSdkVersion);
                }
                MergingReport mergingReport = invoker.merge();
                if (libraries.isEmpty()) {
                    this.handleMergingResult(mergingReport, outManifest);
                } else {
                    this.handleMergingResult(mergingReport, mergedTestManifest);
                    generatedTestManifest = mergedTestManifest;
                }
            }
            if (!libraries.isEmpty()) {
                MergingReport mergingReport = ManifestMerger2.newMerger((File)generatedTestManifest, (ILogger)this.mLogger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS}).setOverride(ManifestMerger2.SystemProperty.PACKAGE, testApplicationId).addLibraryManifests(AndroidBuilder.collectLibraries(libraries)).merge();
                this.handleMergingResult(mergingReport, outManifest);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleMergingResult(@NonNull MergingReport mergingReport, @NonNull File outFile) {
        switch (mergingReport.getResult()) {
            case WARNING: {
                mergingReport.log(this.mLogger);
            }
            case SUCCESS: {
                XmlDocument xmlDocument = (XmlDocument)mergingReport.getMergedDocument().get();
                try {
                    String annotatedDocument = mergingReport.getActions().blame(xmlDocument);
                    this.mLogger.verbose(annotatedDocument, new Object[0]);
                }
                catch (Exception e) {
                    this.mLogger.error((Throwable)e, "cannot print resulting xml", new Object[0]);
                }
                this.save(xmlDocument, outFile);
                this.mLogger.info("Merged manifest saved to " + outFile, new Object[0]);
                break;
            }
            case ERROR: {
                mergingReport.log(this.mLogger);
                throw new RuntimeException(mergingReport.getReportString());
            }
            default: {
                throw new RuntimeException("Unhandled result type : " + mergingReport.getResult());
            }
        }
    }

    private static void generateTestManifest(@NonNull String testApplicationId, @Nullable String minSdkVersion, @Nullable String targetSdkVersion, @NonNull String testedApplicationId, @NonNull String instrumentationRunner, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest, @NonNull File outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testApplicationId, minSdkVersion, targetSdkVersion, testedApplicationId, instrumentationRunner, handleProfiling, functionalTest);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processResources(@NonNull AaptPackageCommandBuilder aaptCommand, boolean enforceUniquePackageName) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call processResources() before setTargetInfo() is called.");
        List<String> command = aaptCommand.build(this.mTargetInfo.getBuildTools(), this.mTargetInfo.getTarget(), this.mLogger);
        this.mCmdLineRunner.runCmdLine(command, null);
        if (aaptCommand.getSourceOutputDir() != null && aaptCommand.getType() != VariantConfiguration.Type.LIBRARY && !aaptCommand.getLibraries().isEmpty()) {
            String msg;
            SymbolLoader fullSymbolValues = null;
            String appPackageName = aaptCommand.getPackageForR();
            if (appPackageName == null) {
                appPackageName = VariantConfiguration.getManifestPackage(aaptCommand.getManifestFile());
            }
            ArrayListMultimap libMap = ArrayListMultimap.create();
            for (SymbolFileProvider symbolFileProvider : aaptCommand.getLibraries()) {
                String packageName = VariantConfiguration.getManifestPackage(symbolFileProvider.getManifest());
                if (appPackageName == null) continue;
                if (appPackageName.equals(packageName)) {
                    if (!enforceUniquePackageName) continue;
                    msg = String.format("Error: A library uses the same package as this project: %s\nYou can temporarily disable this error with android.enforceUniquePackageName=false\nHowever, this is temporary and will be enforced in 1.0", packageName);
                    throw new RuntimeException(msg);
                }
                File rFile = symbolFileProvider.getSymbolFile();
                if (!rFile.isFile()) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(aaptCommand.getSymbolOutputDir(), "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put((Object)packageName, (Object)libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get((Object)string);
                if (enforceUniquePackageName && symbols.size() > 1) {
                    msg = String.format("Error: more than one library with package name '%s'\nYou can temporarily disable this error with android.enforceUniquePackageName=false\nHowever, this is temporary and will be enforced in 1.0", string);
                    throw new RuntimeException(msg);
                }
                SymbolWriter writer = new SymbolWriter(aaptCommand.getSourceOutputDir(), string, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void generateApkData(@NonNull File apkFile, @NonNull File outResFolder, @NonNull String mainPkgName, @NonNull String resName) throws InterruptedException, LoggedErrorException, IOException {
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aapt = buildToolInfo.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null) {
            throw new IllegalStateException("Unable to get aapt location from Build Tools " + buildToolInfo.getRevision());
        }
        ApkInfoParser parser = new ApkInfoParser(new File(aapt), this.mCmdLineRunner);
        ApkInfoParser.ApkInfo apkInfo = parser.parseApk(apkFile);
        if (!apkInfo.getPackageName().equals(mainPkgName)) {
            throw new RuntimeException("The main and the micro apps do not have the same package name.");
        }
        String content = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<wearableApp package=\"%1$s\">\n    <versionCode>%2$s</versionCode>\n    <versionName>%3$s</versionName>\n    <rawPathResId>%4$s</rawPathResId>\n</wearableApp>", apkInfo.getPackageName(), apkInfo.getVersionCode(), apkInfo.getVersionName(), resName);
        File resXmlFile = new File(outResFolder, "xml");
        resXmlFile.mkdirs();
        Files.write((CharSequence)content, (File)new File(resXmlFile, "android_wear_micro_apk.xml"), (Charset)Charsets.UTF_8);
    }

    public void generateApkDataEntryInManifest(int minSdkVersion, int targetSdkVersion, @NonNull File manifestFile) throws InterruptedException, LoggedErrorException, IOException {
        StringBuilder content = new StringBuilder();
        content.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n").append("<manifest package=\"\" xmlns:android=\"http://schemas.android.com/apk/res/android\">\n").append("            <uses-sdk android:minSdkVersion=\"").append(minSdkVersion).append("\"");
        if (targetSdkVersion != -1) {
            content.append(" android:targetSdkVersion=\"").append(targetSdkVersion).append("\"");
        }
        content.append("/>\n");
        content.append("    <application>\n").append("        <meta-data android:name=\"com.google.android.wearable.beta.app\"\n").append("                   android:resource=\"@xml/android_wear_micro_apk").append("\" />\n").append("   </application>\n").append("</manifest>\n");
        Files.write((CharSequence)content, (File)manifestFile, (Charset)Charsets.UTF_8);
    }

    public void compileAllAidlFiles(@NonNull List<File> sourceFolders, @NonNull File sourceOutputDir, @Nullable File parcelableOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllAidlFiles() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), fullImportList, sourceOutputDir, parcelableOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(@NonNull File sourceFolder, @NonNull File aidlFile, @NonNull File sourceOutputDir, @Nullable File parcelableOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)aidlFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAidlFile() before setTargetInfo() is called.");
        IAndroidTarget target = this.mTargetInfo.getTarget();
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String aidl = buildToolInfo.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl, target.getPath(2), importFolders, sourceOutputDir, parcelableOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        processor.processFile(sourceFolder, aidlFile);
    }

    public void compileAllRenderscriptFiles(@NonNull List<File> sourceFolders, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull File resOutputDir, @NonNull File objOutputDir, @NonNull File libOutputDir, int targetApi, boolean debugBuild, int optimLevel, boolean ndkMode, boolean supportMode, @Nullable Set<String> abiFilters) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call compileAllRenderscriptFiles() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        String renderscript = buildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        RenderScriptProcessor processor = new RenderScriptProcessor(sourceFolders, importFolders, sourceOutputDir, resOutputDir, objOutputDir, libOutputDir, buildToolInfo, targetApi, debugBuild, optimLevel, ndkMode, supportMode, abiFilters);
        processor.build(this.mCmdLineRunner);
    }

    @NonNull
    public List<File> getLeafFolders(@NonNull String extension, List<File> ... importFolders) {
        ArrayList results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                }
                catch (LoggedErrorException e) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public void convertByteCode(@NonNull Collection<File> inputs, @NonNull Collection<File> preDexedLibraries, @NonNull File outDexFolder, boolean multidex, boolean multidexLegacy, @Nullable File mainDexList, @NonNull DexOptions dexOptions, @Nullable List<String> additionalParameters, @NonNull File tmpFolder, boolean incremental, boolean optimize) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull(inputs, (Object)"inputs cannot be null.");
        Preconditions.checkNotNull(preDexedLibraries, (Object)"preDexedLibraries cannot be null.");
        Preconditions.checkNotNull((Object)outDexFolder, (Object)"outDexFolder cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        Preconditions.checkNotNull((Object)tmpFolder, (Object)"tmpFolder cannot be null");
        Preconditions.checkArgument((boolean)outDexFolder.isDirectory(), (Object)"outDexFolder must be a folder");
        Preconditions.checkArgument((boolean)tmpFolder.isDirectory(), (Object)"tmpFolder must be a folder");
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call convertByteCode() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        Preconditions.checkState((!multidex || buildToolInfo.getRevision().compareTo(MIN_MULTIDEX_BUILD_TOOLS_REV) >= 0 ? 1 : 0) != 0, (Object)("Multi dex requires Build Tools " + MIN_MULTIDEX_BUILD_TOOLS_REV.toString() + " / Current: " + buildToolInfo.getRevision().toShortString()));
        ArrayList command = Lists.newArrayList();
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-JXmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("--dex");
        if (this.mVerboseExec) {
            command.add("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            command.add("--force-jumbo");
        }
        if (incremental) {
            command.add("--incremental");
            command.add("--no-strict");
        }
        if (!optimize) {
            command.add("--no-optimize");
        }
        if (multidex) {
            command.add("--multi-dex");
            if (mainDexList != null) {
                command.add("--main-dex-list");
                command.add(mainDexList.getAbsolutePath());
            }
        }
        if (additionalParameters != null) {
            for (String arg : additionalParameters) {
                command.add(arg);
            }
        }
        command.add("--output");
        command.add(outDexFolder.getAbsolutePath());
        HashSet allInputs = Sets.newHashSetWithExpectedSize((int)(preDexedLibraries.size() + inputs.size()));
        allInputs.addAll(preDexedLibraries);
        allInputs.addAll(inputs);
        command.addAll(AndroidBuilder.getFilesToAdd(allInputs, buildToolInfo, tmpFolder));
        this.mCmdLineRunner.runCmdLine((List)command, null);
    }

    private static List<String> getFilesToAdd(Set<File> includeFiles, BuildToolInfo buildToolInfo, File tmpFolder) throws IOException {
        Set existingFiles = Sets.filter(includeFiles, (Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File input) {
                return input != null && input.exists();
            }
        });
        if (existingFiles.isEmpty()) {
            throw new IOException("No files to pass to dex.");
        }
        ArrayList sortedList = Lists.newArrayList((Iterable)existingFiles);
        Collections.sort(sortedList, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                if (file.isDirectory()) {
                    return -1;
                }
                if (file2.isDirectory()) {
                    return 1;
                }
                if (file.length() > file2.length()) {
                    return 1;
                }
                return -1;
            }
        });
        ArrayList filePathList = Lists.newArrayListWithCapacity((int)sortedList.size());
        for (File f : sortedList) {
            filePathList.add(f.getAbsolutePath());
        }
        if (buildToolInfo.getRevision().compareTo(MIN_BUILD_TOOLS_REVISION_FOR_DEX_INPUT_LIST) >= 0) {
            File inputListFile = new File(tmpFolder, "inputList.txt");
            Files.asCharSink((File)inputListFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines((Iterable)filePathList);
            return Collections.singletonList("--input-list=" + inputListFile.getAbsolutePath());
        }
        return filePathList;
    }

    public void preDexLibrary(@NonNull File inputFile, @NonNull File outFile, boolean multiDex, @NonNull DexOptions dexOptions) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call preDexLibrary() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        PreDexCache.getCache().preDexLibrary(inputFile, outFile, multiDex, dexOptions, buildToolInfo, this.mVerboseExec, this.mCmdLineRunner);
    }

    @NonNull
    public static List<File> preDexLibrary(@NonNull File inputFile, @NonNull File outFile, boolean multiDex, @NonNull DexOptions dexOptions, @NonNull BuildToolInfo buildToolInfo, boolean verbose, @NonNull CommandLineRunner commandLineRunner) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        ArrayList command = Lists.newArrayList();
        String dx = buildToolInfo.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-JXmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("--dex");
        if (verbose) {
            command.add("--verbose");
        }
        if (dexOptions.getJumboMode()) {
            command.add("--force-jumbo");
        }
        if (multiDex) {
            command.add("--multi-dex");
        }
        command.add("--output");
        command.add(outFile.getAbsolutePath());
        command.add(inputFile.getAbsolutePath());
        commandLineRunner.runCmdLine((List)command, null);
        if (multiDex) {
            Object[] files = outFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.endsWith(".dex");
                }
            });
            if (files == null || files.length == 0) {
                throw new RuntimeException("No dex files created at " + outFile.getAbsolutePath());
            }
            return Lists.newArrayList((Object[])files);
        }
        return Collections.singletonList(outFile);
    }

    public void convertLibraryToJack(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkState((this.mTargetInfo != null ? 1 : 0) != 0, (Object)"Cannot call preJackLibrary() before setTargetInfo() is called.");
        BuildToolInfo buildToolInfo = this.mTargetInfo.getBuildTools();
        JackConversionCache.getCache().convertLibrary(inputFile, outFile, dexOptions, buildToolInfo, this.mVerboseExec, this.mCmdLineRunner);
    }

    public static List<File> convertLibraryToJack(@NonNull File inputFile, @NonNull File outFile, @NonNull DexOptions dexOptions, @NonNull BuildToolInfo buildToolInfo, boolean verbose, @NonNull CommandLineRunner commandLineRunner) throws IOException, InterruptedException, LoggedErrorException {
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile cannot be null.");
        Preconditions.checkNotNull((Object)outFile, (Object)"outFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        ArrayList command = Lists.newArrayList();
        String jill = buildToolInfo.getPath(BuildToolInfo.PathId.JILL);
        if (jill == null || !new File(jill).isFile()) {
            throw new IllegalStateException("jill.jar is missing");
        }
        command.add("java");
        if (dexOptions.getJavaMaxHeapSize() != null) {
            command.add("-Xmx" + dexOptions.getJavaMaxHeapSize());
        }
        command.add("-jar");
        command.add(jill);
        command.add(inputFile.getAbsolutePath());
        command.add("--output");
        command.add(outFile.getAbsolutePath());
        if (verbose) {
            command.add("--verbose");
        }
        commandLineRunner.runCmdLine((List)command, null);
        return Collections.singletonList(outFile);
    }

    public void packageApk(@NonNull String androidResPkgLocation, @Nullable File dexFolder, @NonNull Collection<File> dexedLibraries, @NonNull Collection<File> packagedJars, @Nullable String javaResourcesLocation, @Nullable Collection<File> jniLibsFolders, @Nullable Set<String> abiFilters, boolean jniDebugBuild, @Nullable SigningConfig signingConfig, @Nullable PackagingOptions packagingOptions, @NonNull String outApkLocation) throws DuplicateFileException, FileNotFoundException, KeytoolException, PackagerException, com.android.builder.packaging.SigningException {
        Preconditions.checkNotNull((Object)androidResPkgLocation, (Object)"androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull((Object)outApkLocation, (Object)"outApkLocation cannot be null.");
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady() && (certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias())) == null) {
            throw new com.android.builder.packaging.SigningException("Failed to read key from keystore", new Object[0]);
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, certificateInfo, this.mCreatedBy, packagingOptions, this.mLogger);
            if (dexFolder != null) {
                if (!dexFolder.isDirectory()) {
                    throw new IllegalArgumentException("dexFolder must be a directory");
                }
                packager.addDexFiles(dexFolder, dexedLibraries);
            }
            packager.setJniDebugMode(jniDebugBuild);
            JavaResourceProcessor resProcessor = new JavaResourceProcessor(packager);
            if (javaResourcesLocation != null) {
                resProcessor.addSourceFolder(javaResourcesLocation);
            }
            HashSet hashs = Sets.newHashSet();
            for (File jar : packagedJars) {
                String hash = AndroidBuilder.getFileHash(jar);
                if (hash == null) {
                    throw new PackagerException("Unable to compute hash of " + jar.getAbsolutePath(), new Object[0]);
                }
                if (hashs.contains(hash)) continue;
                hashs.add(hash);
                packager.addResourcesFromJar(jar);
            }
            if (jniLibsFolders != null) {
                for (File jniFolder : jniLibsFolders) {
                    if (!jniFolder.isDirectory()) continue;
                    packager.addNativeLibraries(jniFolder, abiFilters);
                }
            }
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }

    public void signApk(File in, SigningConfig signingConfig, File out) throws IOException, KeytoolException, com.android.builder.packaging.SigningException, NoSuchAlgorithmException, SignedJarBuilder.IZipEntryFilter.ZipAbortException, SigningException {
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady() && (certificateInfo = KeystoreHelper.getCertificateInfo((String)signingConfig.getStoreType(), (File)signingConfig.getStoreFile(), (String)signingConfig.getStorePassword(), (String)signingConfig.getKeyPassword(), (String)signingConfig.getKeyAlias())) == null) {
            throw new com.android.builder.packaging.SigningException("Failed to read key from keystore", new Object[0]);
        }
        SignedJarBuilder signedJarBuilder = new SignedJarBuilder(new FileOutputStream(out), certificateInfo != null ? certificateInfo.getKey() : null, certificateInfo != null ? certificateInfo.getCertificate() : null, Packager.getLocalVersion(), this.mCreatedBy);
        signedJarBuilder.writeZip(new FileInputStream(in), null);
        signedJarBuilder.close();
    }

    @Nullable
    private static String getFileHash(@NonNull File file) {
        try {
            HashCode hashCode = Files.hash((File)file, (HashFunction)Hashing.sha1());
            return hashCode.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

