/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.internal.compiler.DexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PreDexCache
extends PreProcessCache<DexKey> {
    private static final String ATTR_JUMBO_MODE = "jumboMode";
    private static final PreDexCache sSingleton = new PreDexCache();

    public static PreDexCache getCache() {
        return sSingleton;
    }

    @Override
    @NonNull
    protected PreProcessCache.KeyFactory<DexKey> getKeyFactory() {
        return new PreProcessCache.KeyFactory<DexKey>(){

            @Override
            public DexKey of(@NonNull File sourceFile, @NonNull FullRevision revision, @NonNull NamedNodeMap attrMap) {
                return DexKey.of(sourceFile, revision, Boolean.parseBoolean(attrMap.getNamedItem(PreDexCache.ATTR_JUMBO_MODE).getNodeValue()));
            }
        };
    }

    public void preDexLibrary(@NonNull File inputFile, @NonNull File outFile, boolean multiDex, @NonNull DexOptions dexOptions, @NonNull BuildToolInfo buildToolInfo, boolean verbose, @NonNull CommandLineRunner commandLineRunner) throws IOException, LoggedErrorException, InterruptedException {
        Preconditions.checkState((!multiDex || outFile.isDirectory() ? 1 : 0) != 0);
        DexKey itemKey = DexKey.of(inputFile, buildToolInfo.getRevision(), dexOptions.getJumboMode());
        Pair<PreProcessCache.Item, Boolean> pair = this.getItem(itemKey);
        PreProcessCache.Item item = (PreProcessCache.Item)pair.getFirst();
        if (((Boolean)pair.getSecond()).booleanValue()) {
            try {
                List<File> files = AndroidBuilder.preDexLibrary(inputFile, outFile, multiDex, dexOptions, buildToolInfo, verbose, commandLineRunner);
                item.getOutputFiles().clear();
                item.getOutputFiles().addAll(files);
                this.incrementMisses();
            }
            catch (IOException exception) {
                outFile.delete();
                throw exception;
            }
            catch (LoggedErrorException exception) {
                outFile.delete();
                throw exception;
            }
            catch (InterruptedException exception) {
                outFile.delete();
                throw exception;
            }
            finally {
                item.getLatch().countDown();
            }
        } else {
            item.getLatch().await();
            if (item.areOutputFilesPresent()) {
                if (multiDex) {
                    for (File sourceFile : item.getOutputFiles()) {
                        File destFile = new File(outFile, sourceFile.getName());
                        this.checkSame(sourceFile, destFile);
                        Files.copy((File)sourceFile, (File)destFile);
                    }
                } else {
                    if (item.getOutputFiles().isEmpty()) {
                        throw new RuntimeException(item.toString());
                    }
                    this.checkSame(item.getOutputFiles().get(0), outFile);
                    Files.copy((File)item.getOutputFiles().get(0), (File)outFile);
                }
                this.incrementHits();
            }
        }
    }

    @Override
    protected Node createItemNode(@NonNull Document document, @NonNull DexKey itemKey, @NonNull PreProcessCache.BaseItem item) throws IOException {
        Node itemNode = super.createItemNode(document, itemKey, item);
        Attr attr = document.createAttribute(ATTR_JUMBO_MODE);
        attr.setValue(Boolean.toString(itemKey.isJumboMode()));
        itemNode.getAttributes().setNamedItem(attr);
        return itemNode;
    }

    private void checkSame(File source, File dest) {
        if (source.equals(dest)) {
            Logger.getAnonymousLogger().info(String.format("%s l:%d ts:%d", source, source.length(), source.lastModified()));
        }
    }
}

