/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.android.annotations.NonNull;
import com.android.builder.internal.incremental.DependencyData;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DependencyDataStore {
    private static final byte TAG_HEADER = 127;
    private static final byte TAG_START = 112;
    private static final byte TAG_2NDARY_FILE = 113;
    private static final byte TAG_OUTPUT = 115;
    private static final byte TAG_2NDARY_OUTPUT = 116;
    private static final byte TAG_END = 119;
    private static final int CURRENT_VERSION = 1;
    private final Map<String, DependencyData> mMainFileMap = Maps.newHashMap();

    public void addData(@NonNull List<DependencyData> dataList) {
        for (DependencyData data : dataList) {
            this.mMainFileMap.put(data.getMainFile(), data);
        }
    }

    public void addData(@NonNull DependencyData data) {
        this.mMainFileMap.put(data.getMainFile(), data);
    }

    public void remove(@NonNull DependencyData data) {
        this.mMainFileMap.remove(data.getMainFile());
    }

    public void updateAll(@NonNull List<DependencyData> dataList) {
        for (DependencyData data : dataList) {
            this.mMainFileMap.put(data.getMainFile(), data);
        }
    }

    @NonNull
    public Collection<DependencyData> getData() {
        return this.mMainFileMap.values();
    }

    DependencyData getByMainFile(String path) {
        return this.mMainFileMap.get(path);
    }

    @NonNull
    public Map<String, DependencyData> getMainFileMap() {
        return this.mMainFileMap;
    }

    public void saveTo(@NonNull File file) throws IOException {
        Closer closer = Closer.create();
        try {
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(file));
            fos.write(127);
            DependencyDataStore.writeInt(fos, 1);
            for (DependencyData data : this.getData()) {
                fos.write(112);
                DependencyDataStore.writePath(fos, data.getMainFile());
                for (String path : data.getSecondaryFiles()) {
                    fos.write(113);
                    DependencyDataStore.writePath(fos, path);
                }
                for (String path : data.getOutputFiles()) {
                    fos.write(115);
                    DependencyDataStore.writePath(fos, path);
                }
                for (String path : data.getSecondaryOutputFiles()) {
                    fos.write(116);
                    DependencyDataStore.writePath(fos, path);
                }
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public Multimap<String, DependencyData> loadFrom(@NonNull File file) throws IOException {
        ReusableBuffer buffers;
        ArrayListMultimap inputMap = ArrayListMultimap.create();
        Closer closer = Closer.create();
        FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
        if (DependencyDataStore.readByte(fis, buffers = new ReusableBuffer()) != 127) {
            throw new IllegalStateException("Wrong first byte on " + file.getAbsolutePath());
        }
        int version = DependencyDataStore.readInt(fis, buffers);
        if (version != 1) {
            throw new IOException("Unsupported file version: " + version);
        }
        try {
            byte currentTag = DependencyDataStore.readByte(fis, buffers);
            if (currentTag != 112) {
                throw new IllegalStateException("Wrong first tag on " + file.getAbsolutePath());
            }
            DependencyData currentData = new DependencyData();
            while (currentTag != 119) {
                String path = DependencyDataStore.readPath(fis, buffers);
                switch (currentTag) {
                    case 112: {
                        currentData.setMainFile(path);
                        this.mMainFileMap.put(path, currentData);
                        inputMap.put((Object)path, (Object)currentData);
                        break;
                    }
                    case 113: {
                        currentData.addSecondaryFile(path);
                        inputMap.put((Object)path, (Object)currentData);
                        break;
                    }
                    case 115: {
                        currentData.addOutputFile(path);
                        break;
                    }
                    case 116: {
                        currentData.addSecondaryOutputFile(path);
                    }
                }
                if ((currentTag = DependencyDataStore.readByte(fis, buffers)) != 112) continue;
                currentData = new DependencyData();
            }
            ArrayListMultimap arrayListMultimap = inputMap;
            return arrayListMultimap;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    private static void writeInt(@NonNull FileOutputStream fos, int value) throws IOException {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(value);
        fos.write(b.array());
    }

    private static void writePath(@NonNull FileOutputStream fos, String path) throws IOException {
        byte[] pathBytes = path.getBytes(Charsets.UTF_8);
        DependencyDataStore.writeInt(fos, pathBytes.length);
        fos.write(pathBytes);
    }

    private static byte readByte(@NonNull FileInputStream fis, @NonNull ReusableBuffer buffers) throws IOException {
        int read = fis.read(buffers.intBuffer, 0, 1);
        if (read != 1) {
            return 119;
        }
        return buffers.intBuffer[0];
    }

    private static int readInt(@NonNull FileInputStream fis, @NonNull ReusableBuffer buffers) throws IOException {
        int read = fis.read(buffers.intBuffer);
        if (read != 4) {
            throw new IOException("Failed to read path length");
        }
        ByteBuffer b = ByteBuffer.wrap(buffers.intBuffer);
        return b.getInt();
    }

    private static String readPath(@NonNull FileInputStream fis, @NonNull ReusableBuffer buffers) throws IOException {
        int read;
        int length = DependencyDataStore.readInt(fis, buffers);
        if (buffers.pathBuffer == null || buffers.pathBuffer.length < length) {
            buffers.pathBuffer = new byte[length];
        }
        if ((read = fis.read(buffers.pathBuffer, 0, length)) != length) {
            throw new IOException("Failed to read path");
        }
        return new String(buffers.pathBuffer, 0, length, Charsets.UTF_8);
    }

    private static class ReusableBuffer {
        byte[] intBuffer = new byte[4];
        byte[] pathBuffer = null;

        private ReusableBuffer() {
        }
    }
}

