/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.ErrorReporter;
import com.android.builder.core.JackProcessOptions;
import com.android.builder.core.JackToolchain;
import com.android.builder.internal.compiler.JackDexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class JackConversionCache
extends PreProcessCache<JackDexKey> {
    private static final JackConversionCache sSingleton = new JackConversionCache();
    private static final String JACK_USED = "jack";
    private static final String JILL_USED = "jill";

    public static JackConversionCache getCache() {
        return sSingleton;
    }

    @Override
    protected PreProcessCache.KeyFactory<JackDexKey> getKeyFactory() {
        return JackDexKey.FACTORY;
    }

    public void convertLibrary(File inputFile, File outFile, JackProcessOptions options, boolean isJackInProcess, BuildToolInfo buildToolInfo, ILogger logger, ErrorReporter errorReporter, JavaProcessExecutor javaProcessExecutor) throws ProcessException, JackToolchain.ToolchainException, ClassNotFoundException, InterruptedException, IOException {
        JackDexKey itemKey = JackDexKey.of(inputFile, buildToolInfo.getRevision(), options.getJumboMode(), options.getDexOptimize(), options.getMinSdkVersion().getApiString(), options.getUseJill() ? JILL_USED : JACK_USED, options.getAdditionalParameters());
        Pair<PreProcessCache.Item, Boolean> pair = this.getItem(logger, itemKey);
        PreProcessCache.Item item = (PreProcessCache.Item)pair.getFirst();
        if (((Boolean)pair.getSecond()).booleanValue()) {
            try {
                JackToolchain toolchain = new JackToolchain(buildToolInfo, logger, errorReporter);
                toolchain.convert(options, javaProcessExecutor, isJackInProcess);
                item.getOutputFiles().add(outFile);
                this.incrementMisses();
            }
            catch (Exception exception) {
                outFile.delete();
                throw exception;
            }
            finally {
                item.getLatch().countDown();
            }
        } else {
            item.getLatch().await();
            File fromFile = item.getOutputFiles().get(0);
            if (!fromFile.getCanonicalPath().equals(outFile.getCanonicalPath()) && fromFile.isFile()) {
                FileUtils.mkdirs((File)outFile.getParentFile());
                Files.copy((File)fromFile, (File)outFile);
                this.incrementHits();
            }
        }
    }
}

