/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.io.FileOp;

public abstract class AbstractInstallerFactory
implements InstallerFactory {
    private InstallerFactory.StatusChangeListenerFactory mListenerFactory;
    protected InstallerFactory mFallbackFactory;

    @Override
    public void setFallbackFactory(InstallerFactory fallback) {
        this.mFallbackFactory = fallback;
    }

    @Override
    public void setListenerFactory(InstallerFactory.StatusChangeListenerFactory listenerFactory) {
        this.mListenerFactory = listenerFactory;
    }

    @Override
    public final Installer createInstaller(RemotePackage remote, RepoManager mgr, Downloader downloader, FileOp fop) {
        if (!this.canHandlePackage(remote, mgr, fop) && this.mFallbackFactory != null) {
            return this.mFallbackFactory.createInstaller(remote, mgr, downloader, fop);
        }
        Installer installer = this.doCreateInstaller(remote, mgr, downloader, fop);
        if (this.mFallbackFactory != null) {
            installer.setFallbackOperation(this.mFallbackFactory.createInstaller(remote, mgr, downloader, fop));
        }
        this.registerListeners(installer);
        return installer;
    }

    private void registerListeners(PackageOperation op) {
        if (this.mListenerFactory != null) {
            for (PackageOperation.StatusChangeListener listener : this.mListenerFactory.createListeners(op.getPackage())) {
                op.registerStateChangeListener(listener);
            }
        }
    }

    protected abstract Installer doCreateInstaller(RemotePackage var1, RepoManager var2, Downloader var3, FileOp var4);

    @Override
    public final Uninstaller createUninstaller(LocalPackage local, RepoManager mgr, FileOp fop) {
        if (!this.canHandlePackage(local, mgr, fop) && this.mFallbackFactory != null) {
            return this.mFallbackFactory.createUninstaller(local, mgr, fop);
        }
        Uninstaller uninstaller = this.doCreateUninstaller(local, mgr, fop);
        if (this.mFallbackFactory != null) {
            uninstaller.setFallbackOperation(this.mFallbackFactory.createUninstaller(local, mgr, fop));
        }
        this.registerListeners(uninstaller);
        return uninstaller;
    }

    protected abstract Uninstaller doCreateUninstaller(LocalPackage var1, RepoManager var2, FileOp var3);

    protected boolean canHandlePackage(RepoPackage pack, RepoManager manager, FileOp fop) {
        return true;
    }
}

