/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.output;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.blame.output.GradleMessageRewriter;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.utils.ILogger;

public class BlameRewritingLogger
implements ILogger {
    private final ILogger mLogger;
    private final GradleMessageRewriter mGradleMessageRewriter;

    public BlameRewritingLogger(@NonNull ILogger logger, @NonNull GradleMessageRewriter.ErrorFormatMode errorFormatMode) {
        this.mLogger = logger;
        ToolOutputParser parser = new ToolOutputParser(new AaptOutputParser(), logger);
        this.mGradleMessageRewriter = new GradleMessageRewriter(parser, errorFormatMode);
    }

    public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
        this.mLogger.error(t, this.mGradleMessageRewriter.rewriteMessages(msgFormat), args);
    }

    public void warning(@NonNull String msgFormat, Object ... args) {
        this.mLogger.warning(this.mGradleMessageRewriter.rewriteMessages(msgFormat), args);
    }

    public void info(@NonNull String msgFormat, Object ... args) {
        this.mLogger.info(msgFormat, args);
    }

    public void verbose(@NonNull String msgFormat, Object ... args) {
        this.mLogger.verbose(msgFormat, args);
    }
}

