/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.caching;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class CreatingCache<K, V> {
    private final Map<K, V> mCache = Maps.newHashMap();
    private final Map<K, CountDownLatch> mProcessedValues = Maps.newHashMap();
    private final ValueFactory<K, V> mValueFactory;

    public CreatingCache(ValueFactory<K, V> valueFactory) {
        this.mValueFactory = valueFactory;
    }

    public V get(K key) {
        return this.get(key, null);
    }

    public synchronized List<V> values() {
        return Lists.newArrayList(this.mCache.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V get(K key, QueryListener queryListener) {
        ValueState<V> state = this.findValueState(key);
        if (queryListener != null) {
            queryListener.onQueryState(state.getState());
        }
        switch (state.getState()) {
            case EXISTING_VALUE: {
                return state.getValue();
            }
            case NEW_VALUE: {
                V value = this.mValueFactory.create(key);
                this.addNewValue(key, value, state.getLatch());
                return value;
            }
            case PROCESSED_VALUE: {
                try {
                    state.getLatch().await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                CreatingCache creatingCache = this;
                synchronized (creatingCache) {
                    return this.mCache.get(key);
                }
            }
        }
        throw new IllegalStateException("unsupported ResultType: " + (Object)((Object)state.getState()));
    }

    public synchronized void clear() {
        if (!this.mProcessedValues.isEmpty()) {
            throw new IllegalStateException("Cache values are being processed");
        }
        this.mCache.clear();
    }

    private synchronized ValueState<V> findValueState(K key) {
        V value = this.mCache.get(key);
        if (value != null) {
            return new ValueState<V>(value);
        }
        CountDownLatch latch = this.mProcessedValues.get(key);
        if (latch != null) {
            return new ValueState(State.PROCESSED_VALUE, latch);
        }
        latch = new CountDownLatch(1);
        this.mProcessedValues.put(key, latch);
        return new ValueState(State.NEW_VALUE, latch);
    }

    private synchronized void addNewValue(K key, V value, CountDownLatch latch) {
        this.mCache.put(key, value);
        this.mProcessedValues.remove(key);
        latch.countDown();
    }

    private static final class ValueState<V> {
        private final State mType;
        private final V mValue;
        private final CountDownLatch mLatch;

        ValueState(V value) {
            this(State.EXISTING_VALUE, value, null);
        }

        ValueState(State type, CountDownLatch latch) {
            this(type, null, latch);
            Preconditions.checkArgument((type != State.EXISTING_VALUE ? 1 : 0) != 0);
        }

        private ValueState(State type, V value, CountDownLatch latch) {
            this.mType = type;
            this.mValue = value;
            this.mLatch = latch;
        }

        public State getState() {
            return this.mType;
        }

        public V getValue() {
            return this.mValue;
        }

        public CountDownLatch getLatch() {
            return this.mLatch;
        }
    }

    static enum State {
        EXISTING_VALUE,
        NEW_VALUE,
        PROCESSED_VALUE;

    }

    static interface QueryListener {
        public void onQueryState(State var1);
    }

    public static interface ValueFactory<K, V> {
        public V create(K var1);
    }
}

