/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.sql;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.apollographql.apollo.api.internal.Action;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.RecordFieldJsonAdapter;
import com.apollographql.apollo.cache.normalized.sql.ApolloSqlHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlNormalizedCache
extends NormalizedCache {
    private static final String INSERT_STATEMENT = String.format("INSERT INTO %s (%s,%s) VALUES (?,?)", "records", "key", "record");
    private static final String UPDATE_STATEMENT = String.format("UPDATE %s SET %s=?, %s=? WHERE %s=?", "records", "key", "record", "key");
    private static final String DELETE_STATEMENT = String.format("DELETE FROM %s WHERE %s=?", "records", "key");
    private static final String DELETE_ALL_RECORD_STATEMENT = String.format("DELETE FROM %s", "records");
    SQLiteDatabase database;
    private final ApolloSqlHelper dbHelper;
    private final String[] allColumns = new String[]{"_id", "key", "record"};
    private final SQLiteStatement insertStatement;
    private final SQLiteStatement updateStatement;
    private final SQLiteStatement deleteStatement;
    private final SQLiteStatement deleteAllRecordsStatement;
    private final RecordFieldJsonAdapter recordFieldAdapter;

    SqlNormalizedCache(RecordFieldJsonAdapter recordFieldAdapter, ApolloSqlHelper dbHelper) {
        this.recordFieldAdapter = recordFieldAdapter;
        this.dbHelper = dbHelper;
        this.database = dbHelper.getWritableDatabase();
        this.insertStatement = this.database.compileStatement(INSERT_STATEMENT);
        this.updateStatement = this.database.compileStatement(UPDATE_STATEMENT);
        this.deleteStatement = this.database.compileStatement(DELETE_STATEMENT);
        this.deleteAllRecordsStatement = this.database.compileStatement(DELETE_ALL_RECORD_STATEMENT);
    }

    @Nullable
    public Record loadRecord(final @NotNull String key, final @NotNull CacheHeaders cacheHeaders) {
        return (Record)this.selectRecordForKey(key).apply((Action)new Action<Record>(){

            public void apply(@NotNull Record record) {
                if (cacheHeaders.hasHeader("evict-after-read")) {
                    SqlNormalizedCache.this.deleteRecord(key);
                }
            }
        }).or(this.nextCache().flatMap((Function)new Function<NormalizedCache, Optional<Record>>(){

            @NotNull
            public Optional<Record> apply(@NotNull NormalizedCache cache) {
                return Optional.fromNullable((Object)cache.loadRecord(key, cacheHeaders));
            }
        })).orNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> recordSet, @NotNull CacheHeaders cacheHeaders) {
        Set changedKeys;
        if (cacheHeaders.hasHeader("do-not-store")) {
            return Collections.emptySet();
        }
        try {
            this.database.beginTransaction();
            changedKeys = super.merge(recordSet, cacheHeaders);
            this.database.setTransactionSuccessful();
        }
        finally {
            this.database.endTransaction();
        }
        return changedKeys;
    }

    public void clearAll() {
        this.nextCache().apply((Action)new Action<NormalizedCache>(){

            public void apply(@NotNull NormalizedCache cache) {
                cache.clearAll();
            }
        });
        this.clearCurrentCache();
    }

    public boolean remove(final @NotNull CacheKey cacheKey, final boolean cascade) {
        Utils.checkNotNull((Object)cacheKey, (Object)"cacheKey == null");
        boolean result = (Boolean)this.nextCache().map((Function)new Function<NormalizedCache, Boolean>(){

            @NotNull
            public Boolean apply(@NotNull NormalizedCache cache) {
                return cache.remove(cacheKey, cascade);
            }
        }).or((Object)Boolean.FALSE);
        if (cascade) {
            return result || (Boolean)this.selectRecordForKey(cacheKey.key()).map((Function)new Function<Record, Boolean>(){

                @NotNull
                public Boolean apply(@NotNull Record record) {
                    boolean result = true;
                    for (CacheReference cacheReference : record.referencedFields()) {
                        result &= SqlNormalizedCache.this.remove(CacheKey.from((String)cacheReference.key()), true);
                    }
                    return result;
                }
            }).or((Object)Boolean.FALSE) != false;
        }
        return result || this.deleteRecord(cacheKey.key());
    }

    public void close() {
        this.dbHelper.close();
    }

    long createRecord(String key, String fields) {
        this.insertStatement.bindString(1, key);
        this.insertStatement.bindString(2, fields);
        long recordId = this.insertStatement.executeInsert();
        return recordId;
    }

    void updateRecord(String key, String fields) {
        this.updateStatement.bindString(1, key);
        this.updateStatement.bindString(2, fields);
        this.updateStatement.bindString(3, key);
        this.updateStatement.executeInsert();
    }

    boolean deleteRecord(String key) {
        this.deleteStatement.bindString(1, key);
        return this.deleteStatement.executeUpdateDelete() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Record> selectRecordForKey(String key) {
        Cursor cursor = this.database.query("records", this.allColumns, "key = ?", new String[]{key}, null, null, null);
        if (cursor == null) {
            return Optional.absent();
        }
        try {
            if (!cursor.moveToFirst()) {
                Optional optional = Optional.absent();
                return optional;
            }
            Optional optional = Optional.of((Object)this.cursorToRecord(cursor));
            return optional;
        }
        catch (IOException exception) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            cursor.close();
        }
    }

    Record cursorToRecord(Cursor cursor) throws IOException {
        String key = cursor.getString(1);
        String jsonOfFields = cursor.getString(2);
        return Record.builder((String)key).addFields(this.recordFieldAdapter.from(jsonOfFields)).build();
    }

    void clearCurrentCache() {
        this.deleteAllRecordsStatement.execute();
    }

    @NotNull
    protected Set<String> performMerge(@NotNull Record apolloRecord, @NotNull CacheHeaders cacheHeaders) {
        Set<String> changedKeys;
        Optional<Record> optionalOldRecord = this.selectRecordForKey(apolloRecord.key());
        if (!optionalOldRecord.isPresent()) {
            this.createRecord(apolloRecord.key(), this.recordFieldAdapter.toJson(apolloRecord.fields()));
            changedKeys = Collections.emptySet();
        } else {
            Record oldRecord = (Record)optionalOldRecord.get();
            changedKeys = oldRecord.mergeWith(apolloRecord);
            if (!changedKeys.isEmpty()) {
                this.updateRecord(oldRecord.key(), this.recordFieldAdapter.toJson(oldRecord.fields()));
            }
        }
        return changedKeys;
    }
}

