/*
 * Decompiled with CFR 0.152.
 */
package com.avast.gradle.dockercompose;

import com.avast.gradle.dockercompose.ComposeExecutor;
import com.avast.gradle.dockercompose.ContainerInfo;
import com.avast.gradle.dockercompose.DockerExecutor;
import com.avast.gradle.dockercompose.RemoveImages;
import com.avast.gradle.dockercompose.ServiceInfo;
import com.avast.gradle.dockercompose.tasks.ComposeBuild;
import com.avast.gradle.dockercompose.tasks.ComposeDown;
import com.avast.gradle.dockercompose.tasks.ComposeDownForced;
import com.avast.gradle.dockercompose.tasks.ComposeLogs;
import com.avast.gradle.dockercompose.tasks.ComposePull;
import com.avast.gradle.dockercompose.tasks.ComposePush;
import com.avast.gradle.dockercompose.tasks.ComposeUp;
import com.avast.gradle.dockercompose.tasks.ServiceInfoCache;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.util.VersionNumber;

public abstract class ComposeSettings
implements GroovyObject {
    private final TaskProvider<ComposeUp> upTask;
    private final TaskProvider<ComposeDown> downTask;
    private final TaskProvider<ComposeDownForced> downForcedTask;
    private final TaskProvider<ComposeBuild> buildTask;
    private final TaskProvider<ComposePull> pullTask;
    private final TaskProvider<ComposeLogs> logsTask;
    private final TaskProvider<ComposePush> pushTask;
    private final Project project;
    private final DockerExecutor dockerExecutor;
    private final ComposeExecutor composeExecutor;
    private final ServiceInfoCache serviceInfoCache;
    protected String customProjectName;
    protected Boolean customProjectNameSet;
    protected String safeProjectNamePrefix;
    private String projectNamePrefix;
    private String nestedName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Inject
    public ComposeSettings(Project project, String name, String parentName) {
        ServiceInfoCache serviceInfoCache;
        TaskProvider taskProvider;
        TaskProvider taskProvider2;
        TaskProvider taskProvider3;
        TaskProvider taskProvider4;
        TaskProvider taskProvider5;
        TaskProvider taskProvider6;
        TaskProvider taskProvider7;
        String string;
        String string2;
        Project project2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
        this.nestedName = string2 = StringGroovyMethods.plus((String)parentName, (CharSequence)name);
        this.safeProjectNamePrefix = string = ComposeSettings.generateSafeProjectNamePrefix(project);
        this.getUseComposeFiles().empty();
        this.getStartedServices().empty();
        this.getIncludeDependencies().set((Object)false);
        this.getScale().empty();
        this.getBuildAdditionalArgs().empty();
        this.getPullAdditionalArgs().empty();
        this.getUpAdditionalArgs().empty();
        this.getDownAdditionalArgs().empty();
        this.getComposeAdditionalArgs().empty();
        this.getBuildBeforeUp().set((Object)true);
        this.getBuildBeforePull().set((Object)true);
        this.getRemoveOrphans().set((Object)false);
        this.getForceRecreate().set((Object)false);
        this.getNoRecreate().set((Object)false);
        this.getStopContainers().set((Object)true);
        this.getRemoveContainers().set((Object)true);
        this.getRetainContainersOnStartupFailure().set((Object)false);
        this.getRemoveImages().set((Object)RemoveImages.None);
        this.getRemoveVolumes().set((Object)true);
        this.getIgnorePullFailure().set((Object)false);
        this.getIgnorePushFailure().set((Object)false);
        this.getPushServices().empty();
        this.getWaitForTcpPorts().set((Object)true);
        this.getTcpPortsToIgnoreWhenWaiting().empty();
        this.getWaitAfterTcpProbeFailure().set((Object)Duration.ofSeconds(1));
        this.getWaitForTcpPortsTimeout().set((Object)Duration.ofMinutes(15));
        this.getWaitForTcpPortsDisconnectionProbeTimeout().set((Object)Duration.ofMillis(1000));
        this.getWaitAfterHealthyStateProbeFailure().set((Object)Duration.ofSeconds(5));
        this.getWaitForHealthyStateTimeout().set((Object)Duration.ofMinutes(15));
        this.getCheckContainersRunning().set((Object)true);
        this.getCaptureContainersOutput().set((Object)false);
        if (OperatingSystem.current().isMacOsX()) {
            this.getExecutable().set((Object)"/usr/local/bin/docker-compose");
            this.getDockerExecutable().set((Object)"/usr/local/bin/docker");
        } else {
            this.getExecutable().set((Object)"docker-compose");
            this.getDockerExecutable().set((Object)"docker");
        }
        this.getEnvironment().set(System.getenv());
        this.getDockerComposeStopTimeout().set((Object)Duration.ofSeconds(10));
        this.getContainerLogToDir().set(project.getBuildDir().toPath().resolve("containers-logs").toFile());
        this.upTask = taskProvider7 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeUp"}).toString() : "composeUp", ComposeUp.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure1(this, this)), Action.class));
        this.buildTask = taskProvider6 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeBuild"}).toString() : "composeBuild", ComposeBuild.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure2(this, this)), Action.class));
        this.pullTask = taskProvider5 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposePull"}).toString() : "composePull", ComposePull.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure3(this, this)), Action.class));
        this.downTask = taskProvider4 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeDown"}).toString() : "composeDown", ComposeDown.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure4(this, this)), Action.class));
        this.downForcedTask = taskProvider3 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeDownForced"}).toString() : "composeDownForced", ComposeDownForced.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure5(this, this)), Action.class));
        this.logsTask = taskProvider2 = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposeLogs"}).toString() : "composeLogs", ComposeLogs.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure6(this, this)), Action.class));
        this.pushTask = taskProvider = project.getTasks().register(DefaultTypeTransformation.booleanUnbox((Object)name) ? new GStringImpl(new Object[]{name}, new String[]{"", "ComposePush"}).toString() : "composePush", ComposePush.class, (Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure7(this, this)), Action.class));
        Object object = project.getObjects().newInstance(DockerExecutor.class, new Object[]{this});
        this.dockerExecutor = (DockerExecutor)ScriptBytecodeAdapter.castToType((Object)object, DockerExecutor.class);
        Object object2 = project.getObjects().newInstance(ComposeExecutor.class, new Object[]{this});
        this.composeExecutor = (ComposeExecutor)ScriptBytecodeAdapter.castToType((Object)object2, ComposeExecutor.class);
        this.serviceInfoCache = serviceInfoCache = new ServiceInfoCache(this);
    }

    @Generated
    public ComposeSettings(Project project, String name) {
        this(project, name, "");
    }

    @Generated
    public ComposeSettings(Project project) {
        this(project, "", "");
    }

    public abstract ListProperty<String> getUseComposeFiles();

    public abstract ListProperty<String> getStartedServices();

    public abstract Property<Boolean> getIncludeDependencies();

    public abstract MapProperty<String, Integer> getScale();

    public abstract ListProperty<String> getBuildAdditionalArgs();

    public abstract ListProperty<String> getPullAdditionalArgs();

    public abstract ListProperty<String> getUpAdditionalArgs();

    public abstract ListProperty<String> getDownAdditionalArgs();

    public abstract ListProperty<String> getComposeAdditionalArgs();

    public abstract Property<Boolean> getBuildBeforeUp();

    public abstract Property<Boolean> getBuildBeforePull();

    public abstract Property<Boolean> getRemoveOrphans();

    public abstract Property<Boolean> getForceRecreate();

    public abstract Property<Boolean> getNoRecreate();

    public abstract Property<Boolean> getStopContainers();

    public abstract Property<Boolean> getRemoveContainers();

    public abstract Property<Boolean> getRetainContainersOnStartupFailure();

    public abstract Property<RemoveImages> getRemoveImages();

    public abstract Property<Boolean> getRemoveVolumes();

    public abstract Property<Boolean> getIgnorePullFailure();

    public abstract Property<Boolean> getIgnorePushFailure();

    public abstract ListProperty<String> getPushServices();

    public abstract Property<Boolean> getWaitForTcpPorts();

    public abstract ListProperty<Integer> getTcpPortsToIgnoreWhenWaiting();

    public abstract Property<Duration> getWaitAfterTcpProbeFailure();

    public abstract Property<Duration> getWaitForTcpPortsTimeout();

    public abstract Property<Duration> getWaitForTcpPortsDisconnectionProbeTimeout();

    public abstract Property<Duration> getWaitAfterHealthyStateProbeFailure();

    public abstract Property<Duration> getWaitForHealthyStateTimeout();

    public abstract Property<Boolean> getCheckContainersRunning();

    public abstract Property<Boolean> getCaptureContainersOutput();

    public abstract RegularFileProperty getCaptureContainersOutputToFile();

    public abstract DirectoryProperty getCaptureContainersOutputToFiles();

    public abstract RegularFileProperty getComposeLogToFile();

    public abstract DirectoryProperty getContainerLogToDir();

    public void setProjectName(String customProjectName) {
        String string;
        this.customProjectName = string = customProjectName;
        boolean bl = true;
        this.customProjectNameSet = bl;
    }

    public String getProjectName() {
        Boolean bl = this.customProjectNameSet;
        if (bl == null ? false : bl) {
            return this.customProjectName;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.projectNamePrefix)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.projectNamePrefix, this.nestedName}, new String[]{"", "_", ""}));
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.safeProjectNamePrefix, this.nestedName}, new String[]{"", "_", ""}));
    }

    public abstract Property<String> getExecutable();

    public abstract Property<String> getDockerExecutable();

    public abstract MapProperty<String, Object> getEnvironment();

    public abstract DirectoryProperty getDockerComposeWorkingDirectory();

    public abstract Property<Duration> getDockerComposeStopTimeout();

    private static String generateSafeProjectNamePrefix(Project project) {
        String fullPathMd5 = EncodingGroovyMethods.encodeHex((byte[])MessageDigest.getInstance("MD5").digest(project.getProjectDir().getAbsolutePath().toString().getBytes(StandardCharsets.UTF_8))).toString();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fullPathMd5, project.getName().replace(".", "_")}, new String[]{"", "_", ""}));
    }

    protected ComposeSettings cloneAsNested(String name) {
        ComposeSettings r = (ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.project.getObjects().newInstance(ComposeSettings.class, new Object[]{this.project, name, this.nestedName}), ComposeSettings.class);
        r.getIncludeDependencies().set(this.getIncludeDependencies().get());
        r.getBuildAdditionalArgs().set(new ArrayList((Collection)ScriptBytecodeAdapter.castToType((Object)this.getBuildAdditionalArgs().get(), Collection.class)));
        r.getPullAdditionalArgs().set(new ArrayList((Collection)ScriptBytecodeAdapter.castToType((Object)this.getPullAdditionalArgs().get(), Collection.class)));
        r.getUpAdditionalArgs().set(new ArrayList((Collection)ScriptBytecodeAdapter.castToType((Object)this.getUpAdditionalArgs().get(), Collection.class)));
        r.getDownAdditionalArgs().set(new ArrayList((Collection)ScriptBytecodeAdapter.castToType((Object)this.getDownAdditionalArgs().get(), Collection.class)));
        r.getComposeAdditionalArgs().set(new ArrayList((Collection)ScriptBytecodeAdapter.castToType((Object)this.getComposeAdditionalArgs().get(), Collection.class)));
        r.getBuildBeforeUp().set(this.getBuildBeforeUp().get());
        r.getBuildBeforePull().set(this.getBuildBeforePull().get());
        r.getRemoveOrphans().set(this.getRemoveOrphans().get());
        r.getForceRecreate().set(this.getForceRecreate().get());
        r.getNoRecreate().set(this.getNoRecreate().get());
        r.getStopContainers().set(this.getStopContainers().get());
        r.getRemoveContainers().set(this.getRemoveContainers().get());
        r.getRetainContainersOnStartupFailure().set(this.getRetainContainersOnStartupFailure().get());
        r.getRemoveImages().set(this.getRemoveImages().get());
        r.getRemoveVolumes().set(this.getRemoveVolumes().get());
        r.getIgnorePullFailure().set(this.getIgnorePullFailure().get());
        r.getIgnorePushFailure().set(this.getIgnorePushFailure().get());
        r.getWaitForTcpPorts().set(this.getWaitForTcpPorts().get());
        r.getTcpPortsToIgnoreWhenWaiting().set(new ArrayList((Collection)ScriptBytecodeAdapter.castToType((Object)this.getTcpPortsToIgnoreWhenWaiting().get(), Collection.class)));
        r.getWaitAfterTcpProbeFailure().set(this.getWaitAfterTcpProbeFailure().get());
        r.getWaitForTcpPortsTimeout().set(this.getWaitForTcpPortsTimeout().get());
        r.getWaitForTcpPortsDisconnectionProbeTimeout().set(this.getWaitForTcpPortsDisconnectionProbeTimeout().get());
        r.getWaitAfterHealthyStateProbeFailure().set(this.getWaitAfterHealthyStateProbeFailure().get());
        r.getWaitForHealthyStateTimeout().set(this.getWaitForHealthyStateTimeout().get());
        r.getCheckContainersRunning().set(this.getCheckContainersRunning().get());
        r.getCaptureContainersOutput().set(this.getCaptureContainersOutput().get());
        String string = this.projectNamePrefix;
        r.setProjectNamePrefix(string);
        r.getExecutable().set(this.getExecutable().get());
        r.getDockerExecutable().set(this.getDockerExecutable().get());
        r.getEnvironment().set(new HashMap((Map)ScriptBytecodeAdapter.castToType((Object)this.getEnvironment().get(), Map.class)));
        r.getDockerComposeWorkingDirectory().set(this.getDockerComposeWorkingDirectory().getOrNull());
        r.getDockerComposeStopTimeout().set(this.getDockerComposeStopTimeout().get());
        return r;
    }

    void isRequiredByCore(Task task, boolean fromConfigure) {
        Reference task2 = new Reference((Object)task);
        Reference fromConfigure2 = new Reference((Object)fromConfigure);
        ((Task)task2.get()).dependsOn(new Object[]{this.upTask});
        ((Task)task2.get()).finalizedBy(new Object[]{this.downTask});
        public final class _isRequiredByCore_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isRequiredByCore_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return Task.class.isAssignableFrom(it.getClass()) && ((Task)ScriptBytecodeAdapter.castToType((Object)it, Task.class)).getName().toLowerCase().contains("classes");
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _isRequiredByCore_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference fromConfigure;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isRequiredByCore_closure9(Object _outerInstance, Object _thisObject, Reference fromConfigure) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.fromConfigure = reference = fromConfigure;
            }

            public Object doCall(Object classesTask) {
                Reference classesTask2 = new Reference(classesTask);
                if (DefaultTypeTransformation.booleanUnbox((Object)this.fromConfigure.get())) {
                    return ((ComposeUp)((Object)((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).getUpTask().get())).shouldRunAfter(new Object[]{classesTask2.get()});
                }
                public final class _closure19
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference classesTask;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure19(Object _outerInstance, Object _thisObject, Reference classesTask) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.classesTask = reference = classesTask;
                    }

                    public Object doCall(Object it) {
                        return ((ComposeUp)((Object)it)).shouldRunAfter(new Object[]{this.classesTask.get()});
                    }

                    @Generated
                    public Object getClassesTask() {
                        return this.classesTask.get();
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure19.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).getUpTask().configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _closure19((Object)this, this.getThisObject(), classesTask2)), Action.class));
                return null;
            }

            @Generated
            public boolean getFromConfigure() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.fromConfigure.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)this.project.getTasks().findAll((Closure)new _isRequiredByCore_closure8(this, this)), (Closure)new _isRequiredByCore_closure9(this, this, fromConfigure2));
        if ((Task)task2.get() instanceof ProcessForkOptions) {
            public final class _isRequiredByCore_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference task;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isRequiredByCore_closure10(Object _outerInstance, Object _thisObject, Reference task) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.task = reference = task;
                }

                public Object doCall(Object it) {
                    ((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).exposeAsEnvironment((ProcessForkOptions)ScriptBytecodeAdapter.asType((Object)this.task.get(), ProcessForkOptions.class));
                    return null;
                }

                @Generated
                public Task getTask() {
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Task)task2.get()).doFirst((Closure)new _isRequiredByCore_closure10(this, this, task2));
        }
        if ((Task)task2.get() instanceof JavaForkOptions) {
            public final class _isRequiredByCore_closure11
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference task;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _isRequiredByCore_closure11(Object _outerInstance, Object _thisObject, Reference task) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.task = reference = task;
                }

                public Object doCall(Object it) {
                    ((ComposeSettings)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ComposeSettings.class)).exposeAsSystemProperties((JavaForkOptions)ScriptBytecodeAdapter.asType((Object)this.task.get(), JavaForkOptions.class));
                    return null;
                }

                @Generated
                public Task getTask() {
                    return (Task)ScriptBytecodeAdapter.castToType((Object)this.task.get(), Task.class);
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _isRequiredByCore_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ((Task)task2.get()).doFirst((Closure)new _isRequiredByCore_closure11(this, this, task2));
        }
    }

    public void isRequiredBy(Task task) {
        this.isRequiredByCore(task, false);
    }

    public void isRequiredBy(TaskProvider<? extends Task> taskProvider) {
        public final class _isRequiredBy_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isRequiredBy_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"isRequiredByCore", (Object)new Object[]{it, true});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isRequiredBy_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        taskProvider.configure((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _isRequiredBy_closure12(this, this)), Action.class));
    }

    public Map<String, ServiceInfo> getServicesInfos() {
        return ((ComposeUp)((Object)this.upTask.get())).getServicesInfos();
    }

    public void exposeAsEnvironment(ProcessForkOptions task) {
        Reference task2 = new Reference((Object)task);
        public final class _exposeAsEnvironment_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _exposeAsEnvironment_closure13(Object _outerInstance, Object _thisObject, Reference task) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.task = reference = task;
            }

            public Object doCall(Object serviceInfo) {
                Reference serviceInfo2 = new Reference(serviceInfo);
                public final class _closure20
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference serviceInfo;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure20(Object _outerInstance, Object _thisObject, Reference task, Reference serviceInfo) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.task = reference2 = task;
                        this.serviceInfo = reference = serviceInfo;
                    }

                    public Object doCall(Object instanceName, Object si) {
                        if (((String)instanceName).endsWith("_1") || ((String)instanceName).endsWith("-1")) {
                            DefaultGroovyMethods.leftShift((Map)((ProcessForkOptions)this.task.get()).getEnvironment(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createEnvironmentVariables", (Object)new Object[]{((ServiceInfo)this.serviceInfo.get()).getName().toUpperCase(), si}), Map.class)));
                        }
                        return DefaultGroovyMethods.leftShift((Map)((ProcessForkOptions)this.task.get()).getEnvironment(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createEnvironmentVariables", (Object)new Object[]{((String)instanceName).toUpperCase(), si}), Map.class)));
                    }

                    public Object call(Object instanceName, Object si) {
                        return this.doCall(instanceName, si);
                    }

                    @Generated
                    public ProcessForkOptions getTask() {
                        return (ProcessForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), ProcessForkOptions.class);
                    }

                    @Generated
                    public Object getServiceInfo() {
                        return this.serviceInfo.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure20.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each(((ServiceInfo)serviceInfo2.get()).getContainerInfos(), (Closure)new _closure20((Object)this, this.getThisObject(), this.task, serviceInfo2));
            }

            @Generated
            public ProcessForkOptions getTask() {
                return (ProcessForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), ProcessForkOptions.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exposeAsEnvironment_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getServicesInfos().values(), (Closure)new _exposeAsEnvironment_closure13(this, this, task2));
    }

    public void exposeAsSystemProperties(JavaForkOptions task) {
        Reference task2 = new Reference((Object)task);
        public final class _exposeAsSystemProperties_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference task;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _exposeAsSystemProperties_closure14(Object _outerInstance, Object _thisObject, Reference task) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.task = reference = task;
            }

            public Object doCall(Object serviceInfo) {
                Reference serviceInfo2 = new Reference(serviceInfo);
                public final class _closure21
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference task;
                    private /* synthetic */ Reference serviceInfo;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure21(Object _outerInstance, Object _thisObject, Reference task, Reference serviceInfo) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.task = reference2 = task;
                        this.serviceInfo = reference = serviceInfo;
                    }

                    public Object doCall(Object instanceName, Object si) {
                        if (((String)instanceName).endsWith("_1") || ((String)instanceName).endsWith("-1")) {
                            DefaultGroovyMethods.leftShift((Map)((JavaForkOptions)this.task.get()).getSystemProperties(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createSystemProperties", (Object)new Object[]{((ServiceInfo)this.serviceInfo.get()).getName(), si}), Map.class)));
                        }
                        return DefaultGroovyMethods.leftShift((Map)((JavaForkOptions)this.task.get()).getSystemProperties(), (Map)((Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethodSafe((Object)((ComposeSettings)this.getThisObject()), (String)"createSystemProperties", (Object)new Object[]{instanceName, si}), Map.class)));
                    }

                    public Object call(Object instanceName, Object si) {
                        return this.doCall(instanceName, si);
                    }

                    @Generated
                    public JavaForkOptions getTask() {
                        return (JavaForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), JavaForkOptions.class);
                    }

                    @Generated
                    public Object getServiceInfo() {
                        return this.serviceInfo.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure21.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return DefaultGroovyMethods.each(((ServiceInfo)serviceInfo2.get()).getContainerInfos(), (Closure)new _closure21((Object)this, this.getThisObject(), this.task, serviceInfo2));
            }

            @Generated
            public JavaForkOptions getTask() {
                return (JavaForkOptions)ScriptBytecodeAdapter.castToType((Object)this.task.get(), JavaForkOptions.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exposeAsSystemProperties_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getServicesInfos().values(), (Closure)new _exposeAsSystemProperties_closure14(this, this, task2));
    }

    protected Map<String, Object> createEnvironmentVariables(String variableName, ContainerInfo ci) {
        Reference serviceName = new Reference((Object)ComposeSettings.replaceV2Separator(variableName));
        Reference environmentVariables = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        ((LinkedHashMap)environmentVariables.get()).put(new GStringImpl(new Object[]{(String)serviceName.get()}, new String[]{"", "_HOST"}).toString(), ci.getHost());
        ((LinkedHashMap)environmentVariables.get()).put(new GStringImpl(new Object[]{(String)serviceName.get()}, new String[]{"", "_CONTAINER_HOSTNAME"}).toString(), ci.getContainerHostname());
        public final class _createEnvironmentVariables_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference environmentVariables;
            private /* synthetic */ Reference serviceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEnvironmentVariables_closure15(Object _outerInstance, Object _thisObject, Reference environmentVariables, Reference serviceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.environmentVariables = reference2 = environmentVariables;
                this.serviceName = reference = serviceName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.environmentVariables.get()).put(new GStringImpl(new Object[]{this.serviceName.get(), ((Map.Entry)it).getKey()}, new String[]{"", "_TCP_", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getEnvironmentVariables() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.environmentVariables.get(), Map.class);
            }

            @Generated
            public Object getServiceName() {
                return this.serviceName.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEnvironmentVariables_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getTcpPorts(), (Closure)new _createEnvironmentVariables_closure15(this, this, environmentVariables, serviceName));
        public final class _createEnvironmentVariables_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference environmentVariables;
            private /* synthetic */ Reference serviceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createEnvironmentVariables_closure16(Object _outerInstance, Object _thisObject, Reference environmentVariables, Reference serviceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.environmentVariables = reference2 = environmentVariables;
                this.serviceName = reference = serviceName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.environmentVariables.get()).put(new GStringImpl(new Object[]{this.serviceName.get(), ((Map.Entry)it).getKey()}, new String[]{"", "_UDP_", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getEnvironmentVariables() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.environmentVariables.get(), Map.class);
            }

            @Generated
            public Object getServiceName() {
                return this.serviceName.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createEnvironmentVariables_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getUdpPorts(), (Closure)new _createEnvironmentVariables_closure16(this, this, environmentVariables, serviceName));
        return (LinkedHashMap)environmentVariables.get();
    }

    protected Map<String, Object> createSystemProperties(String variableName, ContainerInfo ci) {
        Reference serviceName = new Reference((Object)ComposeSettings.replaceV2Separator(variableName));
        Reference systemProperties = new Reference((Object)((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class)));
        ((LinkedHashMap)systemProperties.get()).put(new GStringImpl(new Object[]{(String)serviceName.get()}, new String[]{"", ".host"}).toString(), ci.getHost());
        ((LinkedHashMap)systemProperties.get()).put(new GStringImpl(new Object[]{(String)serviceName.get()}, new String[]{"", ".containerHostname"}).toString(), ci.getContainerHostname());
        public final class _createSystemProperties_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference systemProperties;
            private /* synthetic */ Reference serviceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createSystemProperties_closure17(Object _outerInstance, Object _thisObject, Reference systemProperties, Reference serviceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.systemProperties = reference2 = systemProperties;
                this.serviceName = reference = serviceName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.systemProperties.get()).put(new GStringImpl(new Object[]{this.serviceName.get(), ((Map.Entry)it).getKey()}, new String[]{"", ".tcp.", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getSystemProperties() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.systemProperties.get(), Map.class);
            }

            @Generated
            public Object getServiceName() {
                return this.serviceName.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createSystemProperties_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getTcpPorts(), (Closure)new _createSystemProperties_closure17(this, this, systemProperties, serviceName));
        public final class _createSystemProperties_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference systemProperties;
            private /* synthetic */ Reference serviceName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createSystemProperties_closure18(Object _outerInstance, Object _thisObject, Reference systemProperties, Reference serviceName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.systemProperties = reference2 = systemProperties;
                this.serviceName = reference = serviceName;
            }

            public Object doCall(Object it) {
                return ((LinkedHashMap)this.systemProperties.get()).put(new GStringImpl(new Object[]{this.serviceName.get(), ((Map.Entry)it).getKey()}, new String[]{"", ".udp.", ""}).toString(), ((Map.Entry)it).getValue());
            }

            @Generated
            public Map getSystemProperties() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.systemProperties.get(), Map.class);
            }

            @Generated
            public Object getServiceName() {
                return this.serviceName.get();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createSystemProperties_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(ci.getUdpPorts(), (Closure)new _createSystemProperties_closure18(this, this, systemProperties, serviceName));
        return (LinkedHashMap)systemProperties.get();
    }

    public static String replaceV2Separator(String serviceName) {
        return serviceName.replaceAll("-(\\d+)$", "_$1");
    }

    public boolean removeOrphans() {
        return ScriptBytecodeAdapter.compareGreaterThanEqual((Object)this.composeExecutor.getVersion(), (Object)VersionNumber.parse((String)"1.7.0")) && DefaultTypeTransformation.booleanUnbox((Object)this.getRemoveOrphans().get());
    }

    public boolean scale() {
        VersionNumber v = this.composeExecutor.getVersion();
        if (ScriptBytecodeAdapter.compareLessThan((Object)v, (Object)VersionNumber.parse((String)"1.13.0")) && DefaultTypeTransformation.booleanUnbox(this.getScale())) {
            throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{v}, new String[]{"docker-compose version ", " doesn't support --scale option"})));
        }
        return !((Map)this.getScale().get()).isEmpty();
    }

    public static /* synthetic */ TaskProvider<ComposeUp> pfaccess$0(ComposeSettings $that) {
        return $that.getUpTask();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ComposeSettings.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public final TaskProvider<ComposeUp> getUpTask() {
        return this.upTask;
    }

    @Generated
    public final TaskProvider<ComposeDown> getDownTask() {
        return this.downTask;
    }

    @Generated
    public final TaskProvider<ComposeDownForced> getDownForcedTask() {
        return this.downForcedTask;
    }

    @Generated
    public final TaskProvider<ComposeBuild> getBuildTask() {
        return this.buildTask;
    }

    @Generated
    public final TaskProvider<ComposePull> getPullTask() {
        return this.pullTask;
    }

    @Generated
    public final TaskProvider<ComposeLogs> getLogsTask() {
        return this.logsTask;
    }

    @Generated
    public final TaskProvider<ComposePush> getPushTask() {
        return this.pushTask;
    }

    @Generated
    public final Project getProject() {
        return this.project;
    }

    @Generated
    public final DockerExecutor getDockerExecutor() {
        return this.dockerExecutor;
    }

    @Generated
    public final ComposeExecutor getComposeExecutor() {
        return this.composeExecutor;
    }

    @Generated
    public final ServiceInfoCache getServiceInfoCache() {
        return this.serviceInfoCache;
    }

    @Generated
    public String getProjectNamePrefix() {
        return this.projectNamePrefix;
    }

    @Generated
    public void setProjectNamePrefix(String string) {
        this.projectNamePrefix = string;
    }

    @Generated
    public String getNestedName() {
        return this.nestedName;
    }

    @Generated
    public void setNestedName(String string) {
        this.nestedName = string;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeUp)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeBuild)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure3(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposePull)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure4
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure4(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ScriptBytecodeAdapter.setProperty((Object)composeSettings, null, (Object)it, (String)"settings");
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure5
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure5(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeDownForced)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure5.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure6
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure6(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposeLogs)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure6.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure7
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure7(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            ComposeSettings composeSettings = (ComposeSettings)this.getThisObject();
            ((ComposePush)((Object)it)).setSettings(composeSettings);
            return composeSettings;
        }

        public Object call(Object args) {
            return this.doCall(args);
        }

        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure7.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

