// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentRecurringScansProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A database vulnerability assessment. */
@JsonFlatten
@Fluent
public class DatabaseVulnerabilityAssessmentInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DatabaseVulnerabilityAssessmentInner.class);

    /*
     * A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/).  It is required if
     * server level vulnerability assessment policy doesn't set
     */
    @JsonProperty(value = "properties.storageContainerPath")
    private String storageContainerPath;

    /*
     * A shared access signature (SAS Key) that has read and write access to
     * the blob container specified in 'storageContainerPath' parameter. If
     * 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is
     * required.
     */
    @JsonProperty(value = "properties.storageContainerSasKey")
    private String storageContainerSasKey;

    /*
     * Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified,
     * storageAccountAccessKey is required.
     */
    @JsonProperty(value = "properties.storageAccountAccessKey")
    private String storageAccountAccessKey;

    /*
     * The recurring scans settings
     */
    @JsonProperty(value = "properties.recurringScans")
    private VulnerabilityAssessmentRecurringScansProperties recurringScans;

    /**
     * Get the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/). It is required if server level vulnerability assessment policy
     * doesn't set.
     *
     * @return the storageContainerPath value.
     */
    public String storageContainerPath() {
        return this.storageContainerPath;
    }

    /**
     * Set the storageContainerPath property: A blob storage container path to hold the scan results (e.g.
     * https://myStorage.blob.core.windows.net/VaScans/). It is required if server level vulnerability assessment policy
     * doesn't set.
     *
     * @param storageContainerPath the storageContainerPath value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageContainerPath(String storageContainerPath) {
        this.storageContainerPath = storageContainerPath;
        return this;
    }

    /**
     * Get the storageContainerSasKey property: A shared access signature (SAS Key) that has read and write access to
     * the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required.
     *
     * @return the storageContainerSasKey value.
     */
    public String storageContainerSasKey() {
        return this.storageContainerSasKey;
    }

    /**
     * Set the storageContainerSasKey property: A shared access signature (SAS Key) that has read and write access to
     * the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified,
     * StorageContainerSasKey is required.
     *
     * @param storageContainerSasKey the storageContainerSasKey value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageContainerSasKey(String storageContainerSasKey) {
        this.storageContainerSasKey = storageContainerSasKey;
        return this;
    }

    /**
     * Get the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     *
     * @return the storageAccountAccessKey value.
     */
    public String storageAccountAccessKey() {
        return this.storageAccountAccessKey;
    }

    /**
     * Set the storageAccountAccessKey property: Specifies the identifier key of the storage account for vulnerability
     * assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
     *
     * @param storageAccountAccessKey the storageAccountAccessKey value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withStorageAccountAccessKey(String storageAccountAccessKey) {
        this.storageAccountAccessKey = storageAccountAccessKey;
        return this;
    }

    /**
     * Get the recurringScans property: The recurring scans settings.
     *
     * @return the recurringScans value.
     */
    public VulnerabilityAssessmentRecurringScansProperties recurringScans() {
        return this.recurringScans;
    }

    /**
     * Set the recurringScans property: The recurring scans settings.
     *
     * @param recurringScans the recurringScans value to set.
     * @return the DatabaseVulnerabilityAssessmentInner object itself.
     */
    public DatabaseVulnerabilityAssessmentInner withRecurringScans(
        VulnerabilityAssessmentRecurringScansProperties recurringScans) {
        this.recurringScans = recurringScans;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (recurringScans() != null) {
            recurringScans().validate();
        }
    }
}
