// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.azure.resourcemanager.sql.models.SyncGroupState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** An Azure SQL Database sync group. */
@JsonFlatten
@Fluent
public class SyncGroupInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SyncGroupInner.class);

    /*
     * Sync interval of the sync group.
     */
    @JsonProperty(value = "properties.interval")
    private Integer interval;

    /*
     * Last sync time of the sync group.
     */
    @JsonProperty(value = "properties.lastSyncTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastSyncTime;

    /*
     * Conflict resolution policy of the sync group.
     */
    @JsonProperty(value = "properties.conflictResolutionPolicy")
    private SyncConflictResolutionPolicy conflictResolutionPolicy;

    /*
     * ARM resource id of the sync database in the sync group.
     */
    @JsonProperty(value = "properties.syncDatabaseId")
    private String syncDatabaseId;

    /*
     * User name for the sync group hub database credential.
     */
    @JsonProperty(value = "properties.hubDatabaseUserName")
    private String hubDatabaseUsername;

    /*
     * Password for the sync group hub database credential.
     */
    @JsonProperty(value = "properties.hubDatabasePassword")
    private String hubDatabasePassword;

    /*
     * Sync state of the sync group.
     */
    @JsonProperty(value = "properties.syncState", access = JsonProperty.Access.WRITE_ONLY)
    private SyncGroupState syncState;

    /*
     * Sync schema of the sync group.
     */
    @JsonProperty(value = "properties.schema")
    private SyncGroupSchema schema;

    /**
     * Get the interval property: Sync interval of the sync group.
     *
     * @return the interval value.
     */
    public Integer interval() {
        return this.interval;
    }

    /**
     * Set the interval property: Sync interval of the sync group.
     *
     * @param interval the interval value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the lastSyncTime property: Last sync time of the sync group.
     *
     * @return the lastSyncTime value.
     */
    public OffsetDateTime lastSyncTime() {
        return this.lastSyncTime;
    }

    /**
     * Get the conflictResolutionPolicy property: Conflict resolution policy of the sync group.
     *
     * @return the conflictResolutionPolicy value.
     */
    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    /**
     * Set the conflictResolutionPolicy property: Conflict resolution policy of the sync group.
     *
     * @param conflictResolutionPolicy the conflictResolutionPolicy value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withConflictResolutionPolicy(SyncConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    /**
     * Get the syncDatabaseId property: ARM resource id of the sync database in the sync group.
     *
     * @return the syncDatabaseId value.
     */
    public String syncDatabaseId() {
        return this.syncDatabaseId;
    }

    /**
     * Set the syncDatabaseId property: ARM resource id of the sync database in the sync group.
     *
     * @param syncDatabaseId the syncDatabaseId value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withSyncDatabaseId(String syncDatabaseId) {
        this.syncDatabaseId = syncDatabaseId;
        return this;
    }

    /**
     * Get the hubDatabaseUsername property: User name for the sync group hub database credential.
     *
     * @return the hubDatabaseUsername value.
     */
    public String hubDatabaseUsername() {
        return this.hubDatabaseUsername;
    }

    /**
     * Set the hubDatabaseUsername property: User name for the sync group hub database credential.
     *
     * @param hubDatabaseUsername the hubDatabaseUsername value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withHubDatabaseUsername(String hubDatabaseUsername) {
        this.hubDatabaseUsername = hubDatabaseUsername;
        return this;
    }

    /**
     * Get the hubDatabasePassword property: Password for the sync group hub database credential.
     *
     * @return the hubDatabasePassword value.
     */
    public String hubDatabasePassword() {
        return this.hubDatabasePassword;
    }

    /**
     * Set the hubDatabasePassword property: Password for the sync group hub database credential.
     *
     * @param hubDatabasePassword the hubDatabasePassword value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withHubDatabasePassword(String hubDatabasePassword) {
        this.hubDatabasePassword = hubDatabasePassword;
        return this;
    }

    /**
     * Get the syncState property: Sync state of the sync group.
     *
     * @return the syncState value.
     */
    public SyncGroupState syncState() {
        return this.syncState;
    }

    /**
     * Get the schema property: Sync schema of the sync group.
     *
     * @return the schema value.
     */
    public SyncGroupSchema schema() {
        return this.schema;
    }

    /**
     * Set the schema property: Sync schema of the sync group.
     *
     * @param schema the schema value to set.
     * @return the SyncGroupInner object itself.
     */
    public SyncGroupInner withSchema(SyncGroupSchema schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schema() != null) {
            schema().validate();
        }
    }
}
