// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient;
import com.azure.resourcemanager.sql.fluent.models.DatabaseVulnerabilityAssessmentRuleBaselineInner;
import com.azure.resourcemanager.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentName;
import com.azure.resourcemanager.sql.models.VulnerabilityAssessmentPolicyBaselineName;
import java.util.List;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient.
 */
public final class ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientImpl
    implements ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient {
    private final ClientLogger logger =
        new ClientLogger(ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService service;

    /** The service client containing this operation class. */
    private final SqlManagementClientImpl client;

    /**
     * Initializes an instance of ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientImpl(SqlManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService.class,
                    client.getHttpPipeline(),
                    client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for
     * SqlManagementClientManagedDatabaseVulnerabilityAssessmentRuleBaselines to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SqlManagementClientM")
    private interface ManagedDatabaseVulnerabilityAssessmentRuleBaselinesService {
        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql"
                + "/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments"
                + "/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("ruleId") String ruleId,
            @PathParam("baselineName") VulnerabilityAssessmentPolicyBaselineName baselineName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql"
                + "/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments"
                + "/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("ruleId") String ruleId,
            @PathParam("baselineName") VulnerabilityAssessmentPolicyBaselineName baselineName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DatabaseVulnerabilityAssessmentRuleBaselineInner parameters,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql"
                + "/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments"
                + "/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("managedInstanceName") String managedInstanceName,
            @PathParam("databaseName") String databaseName,
            @PathParam("vulnerabilityAssessmentName") VulnerabilityAssessmentName vulnerabilityAssessmentName,
            @PathParam("ruleId") String ruleId,
            @PathParam("baselineName") VulnerabilityAssessmentPolicyBaselineName baselineName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            Context context);
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-10-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            managedInstanceName,
                            databaseName,
                            vulnerabilityAssessmentName,
                            ruleId,
                            baselineName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> getWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> getAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return getWithResponseAsync(
                resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName)
            .flatMap(
                (Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentRuleBaselineInner get(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return getAsync(
                resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName)
            .block();
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database's vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> getWithResponse(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        Context context) {
        return getWithResponseAsync(
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                context)
            .block();
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param baselineResults The rule baseline result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (baselineResults != null) {
            baselineResults.forEach(e -> e.validate());
        }
        final String apiVersion = "2017-10-01-preview";
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters =
            new DatabaseVulnerabilityAssessmentRuleBaselineInner();
        parameters.withBaselineResults(baselineResults);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            managedInstanceName,
                            databaseName,
                            vulnerabilityAssessmentName,
                            ruleId,
                            baselineName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            parameters,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param baselineResults The rule baseline result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DatabaseVulnerabilityAssessmentRuleBaselineInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (baselineResults != null) {
            baselineResults.forEach(e -> e.validate());
        }
        final String apiVersion = "2017-10-01-preview";
        DatabaseVulnerabilityAssessmentRuleBaselineInner parameters =
            new DatabaseVulnerabilityAssessmentRuleBaselineInner();
        parameters.withBaselineResults(baselineResults);
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                this.client.getSubscriptionId(),
                apiVersion,
                parameters,
                context);
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param baselineResults The rule baseline result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults) {
        return createOrUpdateWithResponseAsync(
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                baselineResults)
            .flatMap(
                (Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        final List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults = null;
        return createOrUpdateWithResponseAsync(
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                baselineResults)
            .flatMap(
                (Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DatabaseVulnerabilityAssessmentRuleBaselineInner createOrUpdate(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        final List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults = null;
        return createOrUpdateAsync(
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                baselineResults)
            .block();
    }

    /**
     * Creates or updates a database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param baselineResults The rule baseline result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a database vulnerability assessment rule baseline.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DatabaseVulnerabilityAssessmentRuleBaselineInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        List<DatabaseVulnerabilityAssessmentRuleBaselineItem> baselineResults,
        Context context) {
        return createOrUpdateWithResponseAsync(
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                baselineResults,
                context)
            .block();
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-10-01-preview";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            managedInstanceName,
                            databaseName,
                            vulnerabilityAssessmentName,
                            ruleId,
                            baselineName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (vulnerabilityAssessmentName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter vulnerabilityAssessmentName is required and cannot be null."));
        }
        if (ruleId == null) {
            return Mono.error(new IllegalArgumentException("Parameter ruleId is required and cannot be null."));
        }
        if (baselineName == null) {
            return Mono.error(new IllegalArgumentException("Parameter baselineName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2017-10-01-preview";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                this.client.getSubscriptionId(),
                apiVersion,
                context);
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        return deleteWithResponseAsync(
                resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName)
            .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName) {
        deleteAsync(
                resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName)
            .block();
    }

    /**
     * Removes the database's vulnerability assessment rule baseline.
     *
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value
     *     from the Azure Resource Manager API or the portal.
     * @param managedInstanceName The name of the managed instance.
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param ruleId The vulnerability assessment rule ID.
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a
     *     database level rule and master for server level rule).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
        String resourceGroupName,
        String managedInstanceName,
        String databaseName,
        VulnerabilityAssessmentName vulnerabilityAssessmentName,
        String ruleId,
        VulnerabilityAssessmentPolicyBaselineName baselineName,
        Context context) {
        return deleteWithResponseAsync(
                resourceGroupName,
                managedInstanceName,
                databaseName,
                vulnerabilityAssessmentName,
                ruleId,
                baselineName,
                context)
            .block();
    }
}
