// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of sync group schema. */
@Fluent
public final class SyncGroupSchema {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SyncGroupSchema.class);

    /*
     * List of tables in sync group schema.
     */
    @JsonProperty(value = "tables")
    private List<SyncGroupSchemaTable> tables;

    /*
     * Name of master sync member where the schema is from.
     */
    @JsonProperty(value = "masterSyncMemberName")
    private String masterSyncMemberName;

    /**
     * Get the tables property: List of tables in sync group schema.
     *
     * @return the tables value.
     */
    public List<SyncGroupSchemaTable> tables() {
        return this.tables;
    }

    /**
     * Set the tables property: List of tables in sync group schema.
     *
     * @param tables the tables value to set.
     * @return the SyncGroupSchema object itself.
     */
    public SyncGroupSchema withTables(List<SyncGroupSchemaTable> tables) {
        this.tables = tables;
        return this;
    }

    /**
     * Get the masterSyncMemberName property: Name of master sync member where the schema is from.
     *
     * @return the masterSyncMemberName value.
     */
    public String masterSyncMemberName() {
        return this.masterSyncMemberName;
    }

    /**
     * Set the masterSyncMemberName property: Name of master sync member where the schema is from.
     *
     * @param masterSyncMemberName the masterSyncMemberName value to set.
     * @return the SyncGroupSchema object itself.
     */
    public SyncGroupSchema withMasterSyncMemberName(String masterSyncMemberName) {
        this.masterSyncMemberName = masterSyncMemberName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tables() != null) {
            tables().forEach(e -> e.validate());
        }
    }
}
