// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties of a Vulnerability Assessment recurring scans. */
@Fluent
public final class VulnerabilityAssessmentRecurringScansProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VulnerabilityAssessmentRecurringScansProperties.class);

    /*
     * Recurring scans state.
     */
    @JsonProperty(value = "isEnabled")
    private Boolean isEnabled;

    /*
     * Specifies that the schedule scan notification will be is sent to the
     * subscription administrators.
     */
    @JsonProperty(value = "emailSubscriptionAdmins")
    private Boolean emailSubscriptionAdmins;

    /*
     * Specifies an array of e-mail addresses to which the scan notification is
     * sent.
     */
    @JsonProperty(value = "emails")
    private List<String> emails;

    /**
     * Get the isEnabled property: Recurring scans state.
     *
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Recurring scans state.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the emailSubscriptionAdmins property: Specifies that the schedule scan notification will be is sent to the
     * subscription administrators.
     *
     * @return the emailSubscriptionAdmins value.
     */
    public Boolean emailSubscriptionAdmins() {
        return this.emailSubscriptionAdmins;
    }

    /**
     * Set the emailSubscriptionAdmins property: Specifies that the schedule scan notification will be is sent to the
     * subscription administrators.
     *
     * @param emailSubscriptionAdmins the emailSubscriptionAdmins value to set.
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withEmailSubscriptionAdmins(
        Boolean emailSubscriptionAdmins) {
        this.emailSubscriptionAdmins = emailSubscriptionAdmins;
        return this;
    }

    /**
     * Get the emails property: Specifies an array of e-mail addresses to which the scan notification is sent.
     *
     * @return the emails value.
     */
    public List<String> emails() {
        return this.emails;
    }

    /**
     * Set the emails property: Specifies an array of e-mail addresses to which the scan notification is sent.
     *
     * @param emails the emails value to set.
     * @return the VulnerabilityAssessmentRecurringScansProperties object itself.
     */
    public VulnerabilityAssessmentRecurringScansProperties withEmails(List<String> emails) {
        this.emails = emails;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
