/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitm.manager;

import com.browserup.bup.mitm.CertificateAndKey;
import com.browserup.bup.mitm.CertificateAndKeySource;
import com.browserup.bup.mitm.CertificateInfo;
import com.browserup.bup.mitm.CertificateInfoGenerator;
import com.browserup.bup.mitm.HostnameCertificateInfoGenerator;
import com.browserup.bup.mitm.RootCertificateGenerator;
import com.browserup.bup.mitm.TrustSource;
import com.browserup.bup.mitm.exception.MitmException;
import com.browserup.bup.mitm.exception.SslContextInitializationException;
import com.browserup.bup.mitm.keys.ECKeyGenerator;
import com.browserup.bup.mitm.keys.KeyGenerator;
import com.browserup.bup.mitm.keys.RSAKeyGenerator;
import com.browserup.bup.mitm.stats.CertificateGenerationStatistics;
import com.browserup.bup.mitm.tools.DefaultSecurityProviderTool;
import com.browserup.bup.mitm.tools.SecurityProviderTool;
import com.browserup.bup.mitm.util.EncryptionUtil;
import com.browserup.bup.mitm.util.MitmConstants;
import com.browserup.bup.mitm.util.SslUtil;
import com.browserup.bup.util.HttpUtil;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.littleshoot.proxy.MitmManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpersonatingMitmManager
implements MitmManager {
    private static final Logger log = LoggerFactory.getLogger(ImpersonatingMitmManager.class);
    private final List<String> serverCipherSuites;
    private final List<String> clientCipherSuites;
    private final Supplier<SslContext> upstreamServerSslContext = Suppliers.memoize((Supplier)new Supplier<SslContext>(){

        public SslContext get() {
            return SslUtil.getUpstreamServerSslContext(ImpersonatingMitmManager.this.serverCipherSuites, ImpersonatingMitmManager.this.trustSource);
        }
    });
    private final Cache<String, SslContext> sslContextCache;
    private final KeyGenerator serverKeyGenerator;
    private final CertificateAndKeySource rootCertificateSource;
    private final String serverCertificateMessageDigest;
    private final TrustSource trustSource;
    private final CertificateInfoGenerator certificateInfoGenerator;
    private final SecurityProviderTool securityProviderTool;
    private Supplier<CertificateAndKey> rootCertificate = Suppliers.memoize((Supplier)new Supplier<CertificateAndKey>(){

        public CertificateAndKey get() {
            return ImpersonatingMitmManager.this.rootCertificateSource.load();
        }
    });
    private final CertificateGenerationStatistics statistics = new CertificateGenerationStatistics();

    public ImpersonatingMitmManager(CertificateAndKeySource rootCertificateSource, KeyGenerator serverKeyGenerator, String serverMessageDigest, TrustSource trustSource, int sslContextCacheConcurrencyLevel, long cacheExpirationIntervalMs, SecurityProviderTool securityProviderTool, CertificateInfoGenerator certificateInfoGenerator, Collection<String> serverCipherSuites, Collection<String> clientCipherSuites) {
        if (rootCertificateSource == null) {
            throw new IllegalArgumentException("CA root certificate source cannot be null");
        }
        if (serverKeyGenerator == null) {
            throw new IllegalArgumentException("Server key generator cannot be null");
        }
        if (serverMessageDigest == null) {
            throw new IllegalArgumentException("Server certificate message digest cannot be null");
        }
        if (securityProviderTool == null) {
            throw new IllegalArgumentException("The certificate tool implementation cannot be null");
        }
        if (certificateInfoGenerator == null) {
            throw new IllegalArgumentException("Certificate info generator cannot be null");
        }
        this.rootCertificateSource = rootCertificateSource;
        this.trustSource = trustSource;
        this.serverCertificateMessageDigest = serverMessageDigest;
        this.serverKeyGenerator = serverKeyGenerator;
        this.sslContextCache = CacheBuilder.newBuilder().concurrencyLevel(sslContextCacheConcurrencyLevel).expireAfterAccess(cacheExpirationIntervalMs, TimeUnit.MILLISECONDS).build();
        this.securityProviderTool = securityProviderTool;
        this.certificateInfoGenerator = certificateInfoGenerator;
        this.serverCipherSuites = ImmutableList.copyOf(serverCipherSuites);
        log.debug("Allowed ciphers for proxy connections to upstream servers (some ciphers may not be available): {}", serverCipherSuites);
        this.clientCipherSuites = ImmutableList.copyOf(clientCipherSuites);
        log.debug("Allowed ciphers for client connections to proxy (some ciphers may not be available): {}", clientCipherSuites);
    }

    public SSLEngine serverSslEngine() {
        try {
            SSLEngine sslEngine = ((SslContext)this.upstreamServerSslContext.get()).newEngine(ByteBufAllocator.DEFAULT);
            return sslEngine;
        }
        catch (RuntimeException e) {
            throw new MitmException("Error creating SSLEngine for connection to upstream server", e);
        }
    }

    public SSLEngine serverSslEngine(String peerHost, int peerPort) {
        try {
            SSLEngine sslEngine = ((SslContext)this.upstreamServerSslContext.get()).newEngine(ByteBufAllocator.DEFAULT, peerHost, peerPort);
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
            return sslEngine;
        }
        catch (RuntimeException e) {
            throw new MitmException("Error creating SSLEngine for connection to upstream server: " + peerHost + ":" + peerPort, e);
        }
    }

    public SSLEngine clientSslEngineFor(HttpRequest httpRequest, SSLSession sslSession) {
        String requestedHostname = HttpUtil.getHostFromRequest(httpRequest);
        try {
            SslContext ctx = this.getHostnameImpersonatingSslContext(requestedHostname, sslSession);
            return ctx.newEngine(ByteBufAllocator.DEFAULT);
        }
        catch (RuntimeException e) {
            throw new MitmException("Error creating SSLEngine for connection to client to impersonate upstream host: " + requestedHostname, e);
        }
    }

    private SslContext getHostnameImpersonatingSslContext(final String hostnameToImpersonate, final SSLSession sslSession) {
        try {
            return (SslContext)this.sslContextCache.get((Object)hostnameToImpersonate, (Callable)new Callable<SslContext>(){

                @Override
                public SslContext call() throws Exception {
                    return ImpersonatingMitmManager.this.createImpersonatingSslContext(sslSession, hostnameToImpersonate);
                }
            });
        }
        catch (ExecutionException e) {
            throw new SslContextInitializationException("An error occurred while impersonating the remote host: " + hostnameToImpersonate, e);
        }
    }

    private SslContext createImpersonatingSslContext(SSLSession sslSession, String hostnameToImpersonate) {
        X509Certificate originalCertificate = SslUtil.getServerCertificate(sslSession);
        CertificateInfo certificateInfo = this.certificateInfoGenerator.generate(Collections.singletonList(hostnameToImpersonate), originalCertificate);
        SslContext sslContext = this.createImpersonatingSslContext(certificateInfo);
        return sslContext;
    }

    private SslContext createImpersonatingSslContext(CertificateInfo certificateInfo) {
        SslContext sslContext;
        long impersonationStart = System.currentTimeMillis();
        KeyPair serverKeyPair = this.serverKeyGenerator.generate();
        X509Certificate caRootCertificate = ((CertificateAndKey)this.rootCertificate.get()).getCertificate();
        PrivateKey caPrivateKey = ((CertificateAndKey)this.rootCertificate.get()).getPrivateKey();
        if (caRootCertificate == null || caPrivateKey == null) {
            throw new IllegalStateException("A CA root certificate and private key are required to sign a server certificate. Root certificate was: " + caRootCertificate + ". Private key was: " + caPrivateKey);
        }
        if (EncryptionUtil.isEcKey(serverKeyPair.getPrivate()) && EncryptionUtil.isRsaKey(caPrivateKey)) {
            log.warn("CA private key is an RSA key and impersonated server private key is an Elliptic Curve key. JDK bug 8136442 may prevent the proxy server from creating connections to clients due to 'no cipher suites in common'.");
        }
        CertificateAndKey impersonatedCertificateAndKey = this.securityProviderTool.createServerCertificate(certificateInfo, caRootCertificate, caPrivateKey, serverKeyPair, this.serverCertificateMessageDigest);
        X509Certificate[] certChain = new X509Certificate[]{impersonatedCertificateAndKey.getCertificate(), caRootCertificate};
        try {
            sslContext = SslContextBuilder.forServer((PrivateKey)impersonatedCertificateAndKey.getPrivateKey(), (X509Certificate[])certChain).ciphers(this.clientCipherSuites, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
        }
        catch (SSLException e) {
            throw new MitmException("Error creating SslContext for connection to client using impersonated certificate and private key", e);
        }
        long impersonationFinish = System.currentTimeMillis();
        this.statistics.certificateCreated(impersonationStart, impersonationFinish);
        log.debug("Impersonated certificate for {} in {}ms", (Object)certificateInfo.getCommonName(), (Object)(impersonationFinish - impersonationStart));
        return sslContext;
    }

    public CertificateGenerationStatistics getStatistics() {
        return this.statistics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderWithECC() {
        return new Builder().serverKeyGenerator(new ECKeyGenerator()).rootCertificateSource(RootCertificateGenerator.builder().keyGenerator(new ECKeyGenerator()).build());
    }

    public static class Builder {
        private CertificateAndKeySource rootCertificateSource = RootCertificateGenerator.builder().build();
        private KeyGenerator serverKeyGenerator = new RSAKeyGenerator();
        private TrustSource trustSource = TrustSource.defaultTrustSource();
        private int cacheConcurrencyLevel = 8;
        private long cacheExpirationIntervalMs = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        private String serverMessageDigest = MitmConstants.DEFAULT_MESSAGE_DIGEST;
        private SecurityProviderTool securityProviderTool = new DefaultSecurityProviderTool();
        private CertificateInfoGenerator certificateInfoGenerator = new HostnameCertificateInfoGenerator();
        private Collection<String> serverCiphers;
        private Collection<String> clientCiphers;

        public Builder rootCertificateSource(CertificateAndKeySource certificateAndKeySource) {
            this.rootCertificateSource = certificateAndKeySource;
            return this;
        }

        public Builder serverMessageDigest(String serverMessageDigest) {
            this.serverMessageDigest = serverMessageDigest;
            return this;
        }

        public Builder trustAllServers(boolean trustAllServers) {
            if (trustAllServers) {
                this.trustSource = null;
            } else if (this.trustSource == null) {
                this.trustSource = TrustSource.defaultTrustSource();
            }
            return this;
        }

        public Builder trustSource(TrustSource trustSource) {
            this.trustSource = trustSource;
            return this;
        }

        public Builder serverKeyGenerator(KeyGenerator serverKeyGenerator) {
            this.serverKeyGenerator = serverKeyGenerator;
            return this;
        }

        public Builder cacheConcurrencyLevel(int cacheConcurrencyLevel) {
            this.cacheConcurrencyLevel = cacheConcurrencyLevel;
            return this;
        }

        public Builder cacheExpirationInterval(long cacheExpirationInterval, TimeUnit timeUnit) {
            this.cacheExpirationIntervalMs = TimeUnit.MILLISECONDS.convert(cacheExpirationInterval, timeUnit);
            return this;
        }

        public Builder certificateInfoGenerator(CertificateInfoGenerator certificateInfoGenerator) {
            this.certificateInfoGenerator = certificateInfoGenerator;
            return this;
        }

        public Builder serverCiphers(Collection<String> serverCiphers) {
            this.serverCiphers = serverCiphers;
            return this;
        }

        public Builder clientCiphers(Collection<String> clientCiphers) {
            this.clientCiphers = clientCiphers;
            return this;
        }

        public Builder certificateTool(SecurityProviderTool securityProviderTool) {
            this.securityProviderTool = securityProviderTool;
            return this;
        }

        public ImpersonatingMitmManager build() {
            if (this.clientCiphers == null) {
                this.clientCiphers = SslUtil.getDefaultCipherList();
            }
            if (this.serverCiphers == null) {
                this.serverCiphers = SslUtil.getDefaultCipherList();
            }
            return new ImpersonatingMitmManager(this.rootCertificateSource, this.serverKeyGenerator, this.serverMessageDigest, this.trustSource, this.cacheConcurrencyLevel, this.cacheExpirationIntervalMs, this.securityProviderTool, this.certificateInfoGenerator, this.serverCiphers, this.clientCiphers);
        }
    }
}

