/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Facility implements Comparable<Facility>
{
    KERN(0, "KERN"),
    USER(8, "USER"),
    MAIL(16, "MAIL"),
    DAEMON(24, "DAEMON"),
    AUTH(32, "AUTH"),
    SYSLOG(40, "SYSLOG"),
    LPR(48, "LPR"),
    NEWS(56, "NEWS"),
    UUCP(64, "UUCP"),
    CRON(72, "CRON"),
    AUTHPRIV(80, "AUTHPRIV"),
    FTP(88, "FTP"),
    NTP(96, "NTP"),
    AUDIT(104, "AUDIT"),
    ALERT(112, "ALERT"),
    CLOCK(120, "CLOCK"),
    LOCAL0(128, "LOCAL0"),
    LOCAL1(136, "LOCAL1"),
    LOCAL2(144, "LOCAL2"),
    LOCAL3(152, "LOCAL3"),
    LOCAL4(160, "LOCAL4"),
    LOCAL5(168, "LOCAL5"),
    LOCAL6(176, "LOCAL6"),
    LOCAL7(184, "LOCAL7");

    private static final Map<String, Facility> facilityFromLabel;
    private static final Map<Integer, Facility> facilityFromNumericalCode;
    private final int numericalCode;
    @Nonnull
    private final String label;

    private Facility(int numericalCode, String label) {
        this.numericalCode = numericalCode;
        this.label = label;
    }

    @Nonnull
    public static Facility fromNumericalCode(int numericalCode) throws IllegalArgumentException {
        Facility facility = facilityFromNumericalCode.get(numericalCode);
        if (facility == null) {
            throw new IllegalArgumentException("Invalid facility '" + numericalCode + "'");
        }
        return facility;
    }

    @Nullable
    public static Facility fromLabel(String label) throws IllegalArgumentException {
        if (label == null || label.isEmpty()) {
            return null;
        }
        Facility facility = facilityFromLabel.get(label);
        if (facility == null) {
            throw new IllegalArgumentException("Invalid facility '" + label + "'");
        }
        return facility;
    }

    public int numericalCode() {
        return this.numericalCode;
    }

    public String label() {
        return this.label;
    }

    public static Comparator<Facility> comparator() {
        return new Comparator<Facility>(){

            @Override
            public int compare(Facility f1, Facility f2) {
                return Integer.compare(f1.numericalCode, f2.numericalCode);
            }
        };
    }

    static {
        facilityFromLabel = new HashMap<String, Facility>();
        facilityFromNumericalCode = new HashMap<Integer, Facility>();
        for (Facility facility : Facility.values()) {
            facilityFromLabel.put(facility.label, facility);
            facilityFromNumericalCode.put(facility.numericalCode, facility);
        }
    }
}

