/*
 * Decompiled with CFR 0.152.
 */
package com.cyberark.conjur.api;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    private static final String DEFAULT_INTEGRATION_NAME = "SecretsManagerJava API";
    private static final String DEFAULT_INTEGRATION_TYPE = "cybr-secretsmanager-java-api";
    private static final String DEFAULT_VENDOR_NAME = "CyberArk";
    private String integrationName = System.getenv().getOrDefault("INTEGRATION_NAME", "SecretsManagerJava API");
    private String integrationType = System.getenv().getOrDefault("INTEGRATION_TYPE", "cybr-secretsmanager-java-api");
    private String integrationVersion = Configuration.getSDKVersion();
    private String vendorName = System.getenv().getOrDefault("VENDOR_NAME", "CyberArk");
    private String telemetryHeader = null;

    public String getIntegrationName() {
        return this.integrationName;
    }

    public void setIntegrationName(String integrationName) {
        this.integrationName = integrationName != null && !integrationName.isEmpty() ? integrationName : DEFAULT_INTEGRATION_NAME;
        this.telemetryHeader = null;
    }

    public String getIntegrationType() {
        return this.integrationType;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType != null && !integrationType.isEmpty() ? integrationType : DEFAULT_INTEGRATION_TYPE;
        this.telemetryHeader = null;
    }

    public String getIntegrationVersion() {
        return this.integrationVersion;
    }

    public void setIntegrationVersion(String integrationVersion) {
        this.integrationVersion = integrationVersion != null && !integrationVersion.isEmpty() ? integrationVersion : Configuration.getSDKVersion();
        this.telemetryHeader = null;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName != null && !vendorName.isEmpty() ? vendorName : DEFAULT_VENDOR_NAME;
        this.telemetryHeader = null;
    }

    public String getTelemetryHeader() {
        if (this.telemetryHeader == null) {
            this.telemetryHeader = this.generateTelemetryHeader(this.integrationName, this.integrationType, this.integrationVersion, this.vendorName);
        }
        return this.telemetryHeader;
    }

    private String generateTelemetryHeader(String integrationName, String integrationType, String integrationVersion, String vendorName) {
        String fieldValuePairs = "in=" + integrationName + "&it=" + integrationType + "&iv=" + integrationVersion + "&vn=" + vendorName;
        return Base64.getUrlEncoder().encodeToString(fieldValuePairs.getBytes());
    }

    public static String getSDKVersion() {
        try {
            Path rootDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path versionFile = rootDir.resolve("VERSION");
            if (Files.exists(versionFile, new LinkOption[0])) {
                String version = new String(Files.readAllBytes(versionFile)).trim();
                if (version.isEmpty()) {
                    LOGGER.warning("VERSION file is empty.");
                    return "unknown";
                }
                String versionWithoutSnapshot = version.split("-")[0];
                return versionWithoutSnapshot;
            }
            LOGGER.warning("VERSION file not found at: " + versionFile);
            return "unknown";
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading VERSION file: " + e.getMessage(), e);
            return "unknown";
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected error occurred: " + e.getMessage(), e);
            return "unknown";
        }
    }
}

