/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;

public abstract class BaseDecorator {
    protected final boolean traceAnalyticsEnabled;
    protected final float traceAnalyticsSampleRate;

    protected BaseDecorator() {
        Config config = Config.get();
        String[] instrumentationNames = this.instrumentationNames();
        this.traceAnalyticsEnabled = instrumentationNames.length > 0 && config.isTraceAnalyticsIntegrationEnabled(new TreeSet<String>(Arrays.asList(instrumentationNames)), this.traceAnalyticsDefault());
        this.traceAnalyticsSampleRate = config.getInstrumentationAnalyticsSampleRate(instrumentationNames);
    }

    protected abstract String[] instrumentationNames();

    protected abstract String spanType();

    protected abstract String component();

    protected boolean traceAnalyticsDefault() {
        return false;
    }

    public AgentSpan afterStart(AgentSpan span) {
        assert (span != null);
        if (this.spanType() != null) {
            span.setTag("span.type", this.spanType());
        }
        span.setTag("component", this.component());
        if (this.traceAnalyticsEnabled) {
            span.setTag("_dd1.sr.eausr", this.traceAnalyticsSampleRate);
        }
        return span;
    }

    public AgentScope beforeFinish(AgentScope scope) {
        assert (scope != null);
        this.beforeFinish(scope.span());
        return scope;
    }

    public AgentSpan beforeFinish(AgentSpan span) {
        assert (span != null);
        return span;
    }

    public AgentScope onError(AgentScope scope, Throwable throwable) {
        assert (scope != null);
        this.onError(scope.span(), throwable);
        return scope;
    }

    public AgentSpan onError(AgentSpan span, Throwable throwable) {
        assert (span != null);
        if (throwable != null) {
            span.setError(true);
            span.addThrowable(throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
        return span;
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetSocketAddress remoteConnection) {
        assert (span != null);
        if (remoteConnection != null) {
            this.onPeerConnection(span, remoteConnection.getAddress());
            span.setTag("peer.hostname", remoteConnection.getHostName());
            span.setTag("peer.port", remoteConnection.getPort());
        }
        return span;
    }

    public AgentSpan onPeerConnection(AgentSpan span, InetAddress remoteAddress) {
        assert (span != null);
        if (remoteAddress != null) {
            span.setTag("peer.hostname", remoteAddress.getHostName());
            if (remoteAddress instanceof Inet4Address) {
                span.setTag("peer.ipv4", remoteAddress.getHostAddress());
            } else if (remoteAddress instanceof Inet6Address) {
                span.setTag("peer.ipv6", remoteAddress.getHostAddress());
            }
        }
        return span;
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForClass(method.getDeclaringClass()) + "." + method.getName();
    }

    public String spanNameForClass(Class clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = clazz.getName().replace(pkgName, "").substring(1);
        }
        return className;
    }
}

