/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;

public abstract class DatabaseClientDecorator<CONNECTION>
extends ClientDecorator {
    protected abstract String dbType();

    protected abstract String dbUser(CONNECTION var1);

    protected abstract String dbInstance(CONNECTION var1);

    @Override
    public AgentSpan afterStart(AgentSpan span) {
        assert (span != null);
        span.setTag("db.type", this.dbType());
        return super.afterStart(span);
    }

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        assert (span != null);
        if (connection != null) {
            span.setTag("db.user", this.dbUser(connection));
            String instanceName = this.dbInstance(connection);
            span.setTag("db.instance", instanceName);
            if (instanceName != null && Config.get().isDbClientSplitByInstance()) {
                span.setTag("service.name", instanceName);
            }
        }
        return span;
    }

    public AgentSpan onStatement(AgentSpan span, String statement) {
        assert (span != null);
        span.setTag("db.statement", statement);
        return span;
    }
}

