/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;

public final class RunnableWrapper
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RunnableWrapper.class);
    private final Runnable runnable;

    public RunnableWrapper(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    public static Runnable wrapIfNeeded(Runnable task) {
        if (task.getClass().getName().contains("/") && !(task instanceof RunnableWrapper)) {
            log.debug("Wrapping runnable task {}", (Object)task);
            return new RunnableWrapper(task);
        }
        return task;
    }
}

