/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;

class AzurePipelinesInfo
extends CIProviderInfo {
    public static final String AZURE = "TF_BUILD";
    public static final String AZURE_PROVIDER_NAME = "azurepipelines";
    public static final String AZURE_PIPELINE_NAME = "BUILD_DEFINITIONNAME";
    public static final String AZURE_SYSTEM_TEAMFOUNDATIONSERVERURI = "SYSTEM_TEAMFOUNDATIONSERVERURI";
    public static final String AZURE_SYSTEM_TEAMPROJECTID = "SYSTEM_TEAMPROJECTID";
    public static final String AZURE_BUILD_BUILDID = "BUILD_BUILDID";
    public static final String AZURE_SYSTEM_JOBID = "SYSTEM_JOBID";
    public static final String AZURE_SYSTEM_TASKINSTANCEID = "SYSTEM_TASKINSTANCEID";
    public static final String AZURE_WORKSPACE_PATH = "BUILD_SOURCESDIRECTORY";
    public static final String AZURE_SYSTEM_PULLREQUEST_SOURCEREPOSITORYURI = "SYSTEM_PULLREQUEST_SOURCEREPOSITORYURI";
    public static final String AZURE_BUILD_REPOSITORY_URI = "BUILD_REPOSITORY_URI";
    public static final String AZURE_SYSTEM_PULLREQUEST_SOURCECOMMITID = "SYSTEM_PULLREQUEST_SOURCECOMMITID";
    public static final String AZURE_BUILD_SOURCEVERSION = "BUILD_SOURCEVERSION";
    public static final String AZURE_SYSTEM_PULLREQUEST_SOURCEBRANCH = "SYSTEM_PULLREQUEST_SOURCEBRANCH";
    public static final String AZURE_BUILD_SOURCEBRANCH = "BUILD_SOURCEBRANCH";

    AzurePipelinesInfo() {
        String uri = System.getenv(AZURE_SYSTEM_TEAMFOUNDATIONSERVERURI);
        String project = System.getenv(AZURE_SYSTEM_TEAMPROJECTID);
        String buildId = System.getenv(AZURE_BUILD_BUILDID);
        String jobId = System.getenv(AZURE_SYSTEM_JOBID);
        String taskId = System.getenv(AZURE_SYSTEM_TASKINSTANCEID);
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(AZURE_PROVIDER_NAME).withCiPipelineId(System.getenv(AZURE_BUILD_BUILDID)).withCiPipelineName(System.getenv(AZURE_PIPELINE_NAME)).withCiPipelineNumber(System.getenv(AZURE_BUILD_BUILDID)).withCiPipelineUrl(this.buildCiPipelineUrl(uri, project, buildId)).withCiJorUrl(this.buildCiJobUrl(uri, project, buildId, jobId, taskId)).withCiWorkspacePath(this.expandTilde(System.getenv(AZURE_WORKSPACE_PATH))).withGitRepositoryUrl(this.buildGitRepositoryUrl()).withGitCommit(this.buildGitCommit()).withGitBranch(this.buildGitBranch()).withGitTag(this.buildGitTag()).build();
    }

    private String buildGitTag() {
        String branchOrTag = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCEBRANCH);
        if (branchOrTag == null || branchOrTag.isEmpty()) {
            branchOrTag = System.getenv(AZURE_BUILD_SOURCEBRANCH);
        }
        if (branchOrTag != null && branchOrTag.contains("tags")) {
            return this.normalizeRef(branchOrTag);
        }
        return null;
    }

    private String buildGitBranch() {
        String branchOrTag = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCEBRANCH);
        if (branchOrTag == null || branchOrTag.isEmpty()) {
            branchOrTag = System.getenv(AZURE_BUILD_SOURCEBRANCH);
        }
        if (branchOrTag != null && !branchOrTag.contains("tags")) {
            return this.normalizeRef(branchOrTag);
        }
        return null;
    }

    private String buildGitCommit() {
        String commit = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCECOMMITID);
        if (commit == null || commit.isEmpty()) {
            commit = System.getenv(AZURE_BUILD_SOURCEVERSION);
        }
        return commit;
    }

    private String buildGitRepositoryUrl() {
        String repoUrl = System.getenv(AZURE_SYSTEM_PULLREQUEST_SOURCEREPOSITORYURI);
        if (repoUrl == null || repoUrl.isEmpty()) {
            repoUrl = System.getenv(AZURE_BUILD_REPOSITORY_URI);
        }
        return this.filterSensitiveInfo(repoUrl);
    }

    private String buildCiJobUrl(String uri, String project, String buildId, String jobId, String taskId) {
        return String.format("%s%s/_build/results?buildId=%s&view=logs&j=%s&t=%s", uri, project, buildId, jobId, taskId);
    }

    private String buildCiPipelineUrl(String uri, String project, String buildId) {
        return String.format("%s%s/_build/results?buildId=%s", uri, project, buildId);
    }
}

